/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.xml.sax.DocumentHandler;
import org.xml.sax.helpers.ParserAdapter;

public class XSLTResultTarget {
    private StreamResult sr = null;
    private SAXResult saxResult = null;
    private DOMResult dr = null;
    private String encoding;
    private DocumentHandler formatterListener = null;

    public XSLTResultTarget() {
        this.sr = new StreamResult();
    }

    public XSLTResultTarget(OutputStream outputStream) {
        this.sr = new StreamResult();
        this.sr.setOutputStream(outputStream);
    }

    public XSLTResultTarget(Writer writer) {
        this.sr = new StreamResult();
        this.sr.setWriter(writer);
    }

    public XSLTResultTarget(String string) {
        this.sr = new StreamResult();
        this.sr.setSystemId(string);
    }

    public XSLTResultTarget(Node node) {
        this.dr = new DOMResult();
        this.dr.setNode(node);
    }

    public XSLTResultTarget(DocumentHandler documentHandler) {
        SAXResult sAXResult = new SAXResult();
        this.setDocumentHandler(documentHandler);
    }

    public OutputStream getByteStream() {
        if (this.sr != null) {
            return this.sr.getOutputStream();
        }
        return null;
    }

    public Writer getCharacterStream() {
        if (this.sr != null) {
            return this.sr.getWriter();
        }
        return null;
    }

    public DocumentHandler getDocumentHandler() {
        return this.formatterListener;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFileName() {
        if (this.sr != null) {
            return this.sr.getSystemId();
        }
        return null;
    }

    public Node getNode() {
        if (this.dr != null) {
            return this.dr.getNode();
        }
        return null;
    }

    public Result getResultObject() {
        if (this.sr != null) {
            return this.sr;
        }
        if (this.dr != null) {
            return this.dr;
        }
        return this.saxResult;
    }

    public String getSystemId() {
        if (this.sr != null) {
            return this.sr.getSystemId();
        }
        if (this.dr != null) {
            this.dr.getSystemId();
        } else if (this.saxResult != null) {
            this.saxResult.getSystemId();
        }
        return null;
    }

    public void setByteStream(OutputStream outputStream) {
        if (this.sr == null) {
            this.sr = new StreamResult();
        }
        this.sr.setOutputStream(outputStream);
    }

    public void setCharacterStream(Writer writer) {
        if (this.sr == null) {
            this.sr = new StreamResult();
        }
        this.sr.setWriter(writer);
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.formatterListener = documentHandler;
        if (documentHandler instanceof ParserAdapter) {
            if (this.saxResult == null) {
                this.saxResult = new SAXResult();
            }
            this.saxResult.setHandler(((ParserAdapter)documentHandler).getContentHandler());
        }
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setFileName(String string) {
        if (this.sr == null) {
            this.sr = new StreamResult();
        }
        this.sr.setSystemId(string);
    }

    public void setNode(Node node) {
        if (this.dr == null) {
            this.dr = new DOMResult();
        }
        this.dr.setNode(node);
    }

    public void setSystemId(String string) {
        if (this.sr != null) {
            this.sr.setSystemId(string);
        } else if (this.dr != null) {
            this.dr.setSystemId(string);
        } else if (this.saxResult != null) {
            this.saxResult.setSystemId(string);
        }
    }
}

