/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.test.remoting.transport.multiplex;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Level;
import org.jboss.jrunit.extensions.ServerTestCase;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MasterServerSocket;

/**
 * <p/>
 * Copyright (c) 2005
 * <p/>
 *
 * @author <a href="mailto:r.sigal@computer.org">Ron Sigal</a>
 */
public class SimpleServerTest extends ServerTestCase
{
   private static final Logger log = Logger.getLogger(SimpleServerTest.class);

   private Socket socket = null;
   private ServerSocket serverSocket = null;

   private boolean testOver = false;

   public void setUp()
   {
      log.info("Start server test");

      try
      {
         serverSocket = new MasterServerSocket(1999);
         log.info("ServerTest.main(): created MasterServerSocket");
      }
      catch(IOException e)
      {
         log.error("ServerTest.main(): cannot create MasterServerSocket");
         e.printStackTrace();
      }

      new Thread(new Runnable()
      {

         public void run()
         {
            while(!testOver)
            {
               try
               {
                  socket = serverSocket.accept();
                  log.info("ServerTest.main(): created VirtualSocket");
                  Thread thread = new ServerTestThread(socket);
                  thread.start();
               }
               catch(SocketException ignored)
               {
                  // it's because the ServerSocket was closed
               }
               catch(IOException e)
               {
                  log.error("ServerTest.main(): cannot create VirtualSocket");
                  e.printStackTrace();
               }
            }

         }

      }).start();

   }

   public void tearDown()
   {
      testOver = true;

      try
      {
         serverSocket.close();
      }
      catch(IOException ignored)
      {
         log.info("i/o error closing server socket");
      }

   }


   public static void main(String[] args)
   {
      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.DEBUG);

      new SimpleServerTest().setUp();
   }


   class ServerTestThread extends Thread
   {
      private Socket socket;
      private ObjectInputStream ois;
      private ObjectOutputStream oos;
      private DataInputStream is;
//      private BufferedDataOutputStream os;


      public ServerTestThread(Socket socket)
      {
         this.socket = socket;

         try
         {
            ois = new ObjectInputStream(socket.getInputStream());
            oos = new ObjectOutputStream(socket.getOutputStream());
         }
         catch(IOException e)
         {
            log.error("ServerTest.ServerTestThread(): i/o error creating InputStream or OutputStream", e);
            e.printStackTrace();
         }
      }

      public void run()
      {
         log.info("Starting server test thread");

         boolean stillReading = true;

         while(stillReading)
         {
            try
            {
               Object o = ois.readObject();

               Integer i = (Integer) o;
               int val = i.intValue();
               val = val + 100;

               oos.writeObject(new Integer(val));
            }

            catch(IOException e)
            {
               log.error("ServerTest.ServerTestThread.run(): i/o error", e);
               e.printStackTrace();
               break;
            }
            catch(ClassNotFoundException e)
            {
               log.error("ServerTest.ServerTestThread.run(): class not found", e);
               e.printStackTrace();
               break;
            }
         }

         try
         {
            socket.close();
         }
         catch(IOException ignored)
         {
            log.info("i/o error closing socket");
         }

         log.info("Ending server test thread");
      }
   }


}