package org.jboss.test.remoting.detection.jndi;

import org.jboss.jrunit.harness.TestDriver;
import org.jnp.server.Main;
import org.apache.log4j.Level;

import java.net.InetAddress;

/**
 * This should be used as the main test case for JNDI detector.
 * It will start two JNDIDetectors in seperate instances.  The first
 * will detect the second and then the second will shutdown and the first
 * will detect that the second is no longer present.  This also requires
 * this class to start an instance of the JNP
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class JNDIDetector2TestCase extends TestDriver
{

   /**
    * This method should call the addTestClasses() method with the client class to run, number of clients to run
    * and the server class to run.
    */
   public void declareTestClasses()
   {
      try
      {
         String host = InetAddress.getLocalHost().getHostAddress();

         Main jserver = new Main();
         int port = 2410;
         jserver.setPort(port);
         jserver.setBindAddress(host);
         jserver.setRmiPort(31000);
         jserver.start();
         System.out.println("Started JNDI server on " + host + ":" + port);

         addTestClasses(Client.class.getName(),
                        1,
                        Server.class.getName());
      }
      catch(Exception e)
      {
         System.out.println("Error starting JNDI server.");
         e.printStackTrace();
      }
   }

   protected Level getTestLogLevel()
   {
      return Level.DEBUG;
   }

   /**
    * How long to wait for test results to be returned from the client(s).  If goes longer than the
    * specified limit, will throw an exception and kill the running test cases.  Default value is
    * RESULTS_TIMEOUT.
    *
    * @return
    */
   protected long getResultsTimeout()
   {
      return 300000;
   }

   /**
    * How long for the server test case to wait for tear down message.  If exceeds timeout,
    * will throw exception.  The default value is TEARDOWN_TIMEOUT.
    *
    * @return
    */
   protected long getTearDownTimeout()
   {
      return 300000;
   }

   /**
    * How long to allow each of the test cases to run their tests.  If exceeds this timeout
    * will throw exception and kill tests.  The default value is RUN_TEST_TIMEOUT.
    *
    * @return
    */
   protected long getRunTestTimeout()
   {
      return 300000;
   }
}
