/* DefaultMap.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.help;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.Map.ID;

/**
 * Provides the mapping of context-sensitive help IDs and URLs for help page.
 * This class is a common superclass of {@link GraphFactoryMap} and {@link InvariantMap}.
 */
public class DefaultMap implements Map {
    
    /**
     * creates new DefaultMap with given list of ids.
     */
    protected DefaultMap(List<String> ids){
        this.ids = ids;
    }
    
    /**
     * creates new DefaultMap with empty list of ids. Use {@link #setIDList(List) setIDList} to
     * set the ids.
     */
    protected DefaultMap(){
        ids = new ArrayList<String>();
    }
    
    private List<String> ids;
    
    private String urlPrefix = "";
    
    /**
     * allows superclasses to set the list of IDs
     * when this can not be done in the constructor.
     */
    protected void setIDList(List<String> ids){
        this.ids = ids;
    }
    
    /**
     * method for superclasses to set the prefix for URLs.
     */
    protected void setURLPrefix(String urlPrefix){
        this.urlPrefix = urlPrefix;
    }
    
    public boolean isValidID(String string, HelpSet helpSet) {
        return ids.contains(string);
    }
    
    public Enumeration getAllIDs() {
        Vector<Map.ID> mapids = new Vector<Map.ID>(); // NOPMD
        for(int i = 0; i<ids.size(); i++)
            mapids.add(ID.create(ids.get(i), HelpManager.getHelpSet()));
        return mapids.elements();
    }
      
    public URL getURLFromID(Map.ID iD) throws MalformedURLException {
        String id = iD.id;
        if(ids.contains(id))
            return new URL(urlPrefix + id);
        else
            return null;
    }
    
    public boolean isID(URL uRL) {
        return ids.contains(uRL.getHost());
    }
    
    public Map.ID getIDFromURL(URL uRL) {
        if(uRL==null) return null;
        String id = uRL.getHost();
        if(ids.contains(id))
            return ID.create(id, HelpManager.getHelpSet());
        else
            return null;
    }
    
    public Map.ID getClosestID(URL uRL) {
        return getIDFromURL(uRL);
    }
    
    public Enumeration getIDs(URL uRL) {
        Vector<String> mapids = new Vector<String>(); // NOPMD
        mapids.add(getIDFromURL(uRL).id);
        return mapids.elements();
    }

}
