/* LightweightGraphBundle.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.graphs;

import java.util.Collection;
import java.util.Set;

import org.grinvin.gui.icons.GraphIconFactory;
import org.grinvin.invariants.Invariant;
import org.grinvin.invariants.InvariantValue;
import org.grinvin.util.InternationalizedProperties;

/**
 * Lightweight implementation of GraphBundle. This implementation only keeps a
 * reference to a Graph, nothing more.
 */
public class LightweightGraphBundle implements GraphBundle {
    
    //
    private Graph graph;
    
    //
    public LightweightGraphBundle() {
    }

    public Graph getGraph() {
        return graph;
    }

    public void setProperties(InternationalizedProperties properties) {
        //ignore
    }

    public Graph createGraph() {
        this.graph = new DefaultGraph();
        return graph;
    }

    public Embedding createEmbedding() {
        return null; //ignore
    }
    
    public Annotation createAnnotation() {
        return null;
    }

    public void addInvariantValue(InvariantValue value) {
        //ignore
    }

    public void invalidate() {
        //ignore
    }

    public void invalidate(InvariantValue value) {
        //ignore
    }
    
    public void setGraphIconFactory(GraphIconFactory graphIconFactory) {
        //ignore
    }

    public void addGraphBundleListener(GraphBundleListener listener) {
        //ignore
    }

    public void removeGraphBundleListener(GraphBundleListener listener) {
        //ignore
    }

    public int getEmbeddingCount() {
        return 0;
    }

    public EmbeddingView getEmbedding() {
        return null;
    }

    public EmbeddingView getEmbedding(int index) {
        return null;
    }
    
    public int getAnnotationCount() {
        return 0;
    }

    public AnnotationView getAnnotation() {
        return null;
    }
    
    public AnnotationView getAnnotation(int index) {
        return null;
    }

    public InternationalizedProperties getProperties() {
        return null;
    }

    public String getName() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public InvariantValue getInvariantValue(Invariant invariant) {
        return null;
    }

    public InvariantValue getCachedInvariantValue(Invariant invariant) {
        return null;
    }

    public Collection<InvariantValue> getInvariantValues() {
        return null;
    }

    public Set<Invariant> getInvariants() {
        return null;
    }

    public GraphIconFactory getGraphIconFactory() {
        return null;
    }

    public boolean[][] booleanAdjacencyMatrix() {
        return Graphs.booleanAdjacencyMatrix(graph);
    }

    public int[][] adjacencyList() {
        return Graphs.adjacencyList(graph);
    }

    public int[][] distanceMatrix() {
        return Graphs.distanceMatrix(graph);
    }

    public double[] eigenValues() {
        return Graphs.eigenValues(graph);
    }

    public int[] eccentricityList() {
        return Graphs.eccentricityList(graph);
    }

}
