/* FilteredInvariantListGeneratorSink.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.generators.graphs;

import org.grinvin.conjecture.filter.GraphFilter;
import org.grinvin.graphs.GraphBundle;
import org.grinvin.invariants.Invariant;
import org.grinvin.invariants.InvariantValue;

/**
 * Graph generator sink which computes invariants for graph bundles handed
 * to it that pass through a certain filter.
 */
public class FilteredInvariantListGeneratorSink extends InvariantListGeneratorSink {
      
    //
    private GraphFilter filter;
    
    /**
     * Create a sink which computes the values of all given invariants
     * for all graph bundles handed to it.
     */
    public FilteredInvariantListGeneratorSink(Invariant[] invariants, GraphFilter filter) {
        super(invariants);
        this.filter = filter;
    }
    
    @Override
    public void receiveGraphBundle(GraphBundle bundle) {
        if(filter.accepts(bundle)){
            int count = computers.length;
            InvariantValue[] values = new InvariantValue[count];
            try {
                for (int i = 0; i < count; i++){
                    values[i] = computers[i].compute(bundle);
                }
                result.add(values);
            } catch (Exception ex) {
                // TODO: implement this
                // ignored for now
            }
        }
    }
    
}
