/* Engine.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.conjecture.engine;

import javax.swing.JPanel;

import org.grinvin.expr.Expression;
import org.grinvin.worksheet.WorksheetModel;
import org.grinvin.invariants.Invariant;
import org.grinvin.invariants.InvariantValue;
import org.grinvin.list.HasURI;

import org.jdom.Element;

/**
 * Conjecturing engine.
 */
public interface Engine extends HasURI {
    
    /**
     * Run the engine for the given invariant values.
     * @param values Array of invariant values, every row corresponds
     * to a single graph, every column to a single invariant.
     * @return An expression representing the resulting conjecture.
     */
    public Expression run (InvariantValue [][] values);
    
    /**
     * Can the engine make use of the given invariant?
     */
    public boolean allows (Invariant invariant);
    
    /**
     * Returns a configuration panel for this engine that can 
     * be shown in the conjecturing window.
     */
    public JPanel getConfigurationPanel(WorksheetModel worksheetModel);
    
    /**
     * Returns true if the engine is properly configured and ready to be runned.
     */
    public boolean isReadyForRun();
    
    /**
     * Load the settings for this engine from an element.
     */
    public void load(Element element, WorksheetModel worksheetModel);
    
    /**
     * Save the settings for this engine to an element.
     */
    public void save(Element element);
}
