package com.ibm.bsf.util.type;

/**
 * A <em>TypeConvertor</em> is used to convert an object of one type to
 * one of another type. The convertor is invoked with the class of the
 * from object, the desired class, and the from object itself. The
 * convertor must return a new object of the desired class.
 * 
 * @author   Sanjiva Weerawarana
 * @see      TypeConvertorRegistry
 */
public interface TypeConvertor {
  public Object convert (Class from, Class to, Object obj);
  public String getCodeGenString ();
}

