/*********************************************************************
 *
 *	Copyright (C) 2000 Nathan Fiedler
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * PROJECT:     Utilities
 * MODULE:      Name/Value Pair Comparator
 * FILE:        NameValueComparator.java
 *
 * AUTHOR:      Nathan Fiedler
 *
 * REVISION HISTORY:
 *      Name    Date            Description
 *      ----    ----            -----------
 *      nf      06/10/00        Initial version
 *
 * DESCRIPTION:
 *      Defines the name/value pair comparator.
 *
 * $Id: NameValueComparator.java,v 1.1 2000/06/29 07:17:36 nfiedler Exp $
 *
 ********************************************************************/

package com.bluemarsh.util;

import java.util.Comparator;

/**
 * Class NameValueComparator implements a Comparator of NameValuePair
 * objects.
 *
 * @author  Nathan Fiedler
 * @version 1.0  6/10/00
 */
public class NameValueComparator implements Comparator {

    /**
     * Compares its two arguments for order. Returns a negative integer,
     * zero, or a positive integer as the first argument is less than,
     * equal to, or greater than the second.
     */
    public int compare(Object o1, Object o2) {
        if ((o1 instanceof NameValuePair) &&
            (o2 instanceof NameValuePair)) {
            String s1 = ((NameValuePair)o1).getName();
            String s2 = ((NameValuePair)o2).getName();
            return s1.compareTo(s2);
        } else {
            throw new ClassCastException("o1 and o2 must be NameValuePair");
        }
    } // compare

    /**
     * Indicates whether some other object is "equal to" this Comparator.
     *
     * @param  obj  the reference object with which to compare.
     * @return  true only if the specified object is also a comparator
     *          and it imposes the same ordering as this comparator.
     */
    public boolean equals(Object obj) {
        if (obj instanceof NameValueComparator) {
            return true;
        } else {
            return false;
        }
    } // equals
} // NameValueComparator
