/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.oscache.web.tag;

import com.opensymphony.module.oscache.base.Cache;
import com.opensymphony.module.oscache.web.ServletCacheAdministrator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

public class FlushTag
extends TagSupport {
    String scope = null;
    int cacheScope = -1;
    ServletCacheAdministrator admin = null;
    String key = null;
    String pattern = null;
    private String language = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspTagException {
        if (this.admin == null) {
            this.admin = ServletCacheAdministrator.getInstance(this.pageContext.getServletContext());
        }
        if (this.pattern != null) {
            if (this.cacheScope < 0) throw new JspTagException("Cache key specified with invalid or no scope specified");
            Cache cache = this.admin.getCache((HttpServletRequest)this.pageContext.getRequest(), this.cacheScope);
            cache.flushPattern(this.pattern);
        } else if (this.key == null) {
            if (this.cacheScope >= 0) {
                this.admin.setFlushTime(this.cacheScope);
            } else {
                this.admin.flushAll();
            }
        } else {
            if (this.cacheScope < 0) throw new JspTagException("Cache key specified with invalid or no scope specified");
            this.key = this.admin.generateEntryKey(this.key, (HttpServletRequest)this.pageContext.getRequest(), this.cacheScope, this.language);
            Cache cache = this.admin.getCache((HttpServletRequest)this.pageContext.getRequest(), this.cacheScope);
            cache.flushEntry(this.key);
        }
        this.cacheScope = -1;
        this.scope = null;
        this.key = null;
        return 6;
    }

    public void setScope(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("session")) {
                this.cacheScope = 3;
            } else if (string.equalsIgnoreCase("application")) {
                this.cacheScope = 4;
            }
        }
    }

    public void setKey(String string) {
        this.key = string;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setLanguage(String string) {
        this.language = string;
    }
}

