/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Layout;
import org.apache.log4j.Priority;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.xml.XMLWatchdog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DOMConfigurator
extends BasicConfigurator
implements Configurator {
    static final String CONFIGURATION_TAG = "log4j:configuration";
    static final String OLD_CONFIGURATION_TAG = "configuration";
    static final String RENDERER_TAG = "renderer";
    static final String APPENDER_TAG = "appender";
    static final String APPENDER_REF_TAG = "appender-ref";
    static final String PARAM_TAG = "param";
    static final String LAYOUT_TAG = "layout";
    static final String CATEGORY = "category";
    static final String NAME_ATTR = "name";
    static final String CLASS_ATTR = "class";
    static final String VALUE_ATTR = "value";
    static final String ROOT_TAG = "root";
    static final String PRIORITY_TAG = "priority";
    static final String FILTER_TAG = "filter";
    static final String ERROR_HANDLER_TAG = "errorHandler";
    static final String REF_ATTR = "ref";
    static final String ADDITIVITY_ATTR = "additivity";
    static final String DISABLE_OVERRIDE_ATTR = "disableOverride";
    static final String DISABLE_ATTR = "disable";
    static final String CONFIG_DEBUG_ATTR = "configDebug";
    static final String INTERNAL_DEBUG_ATTR = "debug";
    static final String RENDERING_CLASS_ATTR = "renderingClass";
    static final String RENDERED_CLASS_ATTR = "renderedClass";
    static final String EMPTY_STR = "";
    static final Class[] ONE_STRING_PARAM = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DOMConfigurator.class$("java.lang.String")) : class$java$lang$String};
    static final String dbfKey = "javax.xml.parsers.DocumentBuilderFactory";
    Hashtable appenderBag = new Hashtable();
    Properties props;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$spi$ErrorHandler;
    static /* synthetic */ Class class$org$apache$log4j$spi$Filter;

    protected Appender findAppenderByReference(Element appenderRef) {
        String appenderName = this.subst(appenderRef.getAttribute(REF_ATTR));
        Appender appender = (Appender)this.appenderBag.get(appenderName);
        if (appender != null) {
            return appender;
        }
        Document doc = appenderRef.getOwnerDocument();
        Element element = null;
        NodeList list = doc.getElementsByTagName(APPENDER_TAG);
        int t = 0;
        while (t < list.getLength()) {
            Node node = list.item(t);
            NamedNodeMap map = node.getAttributes();
            Node attrNode = map.getNamedItem(NAME_ATTR);
            if (appenderName.equals(attrNode.getNodeValue())) {
                element = (Element)node;
                break;
            }
            ++t;
        }
        if (element == null) {
            LogLog.error("No appender named [" + appenderName + "] could be found.");
            return null;
        }
        appender = this.parseAppender(element);
        this.appenderBag.put(appenderName, appender);
        return appender;
    }

    protected Appender parseAppender(Element appenderElement) {
        String className = this.subst(appenderElement.getAttribute(CLASS_ATTR));
        LogLog.debug("Class name: [" + className + ']');
        try {
            Object instance = Class.forName(className).newInstance();
            Appender appender = (Appender)instance;
            PropertySetter propSetter = new PropertySetter(appender);
            appender.setName(this.subst(appenderElement.getAttribute(NAME_ATTR)));
            NodeList children = appenderElement.getChildNodes();
            int length = children.getLength();
            int loop = 0;
            while (loop < length) {
                Node currentNode = children.item(loop);
                if (currentNode.getNodeType() == 1) {
                    Element currentElement = (Element)currentNode;
                    if (currentElement.getTagName().equals(PARAM_TAG)) {
                        this.setParameter(currentElement, propSetter);
                    } else if (currentElement.getTagName().equals(LAYOUT_TAG)) {
                        appender.setLayout(this.parseLayout(currentElement));
                    } else if (currentElement.getTagName().equals(FILTER_TAG)) {
                        this.parseFilters(currentElement, appender);
                    } else if (currentElement.getTagName().equals(ERROR_HANDLER_TAG)) {
                        this.parseErrorHandler(currentElement, appender);
                    } else if (currentElement.getTagName().equals(APPENDER_REF_TAG)) {
                        String refName = this.subst(currentElement.getAttribute(REF_ATTR));
                        if (appender instanceof AppenderAttachable) {
                            AppenderAttachable aa = (AppenderAttachable)((Object)appender);
                            LogLog.debug("Attaching appender named [" + refName + "] to appender named [" + appender.getName() + "].");
                            aa.addAppender(this.findAppenderByReference(currentElement));
                        } else {
                            LogLog.error("Requesting attachment of appender named [" + refName + "] to appender named [" + appender.getName() + "] which does not implement org.apache.log4j.spi.AppenderAttachable.");
                        }
                    }
                }
                ++loop;
            }
            propSetter.activate();
            return appender;
        }
        catch (Exception oops) {
            LogLog.error("Could not create an Appender. Reported error follows.", oops);
            return null;
        }
    }

    protected void parseErrorHandler(Element element, Appender appender) {
        ErrorHandler eh = (ErrorHandler)OptionConverter.instantiateByClassName(this.subst(element.getAttribute(CLASS_ATTR)), class$org$apache$log4j$spi$ErrorHandler == null ? (class$org$apache$log4j$spi$ErrorHandler = DOMConfigurator.class$("org.apache.log4j.spi.ErrorHandler")) : class$org$apache$log4j$spi$ErrorHandler, null);
        if (eh != null) {
            PropertySetter propSetter = new PropertySetter(eh);
            NodeList children = element.getChildNodes();
            int length = children.getLength();
            int loop = 0;
            while (loop < length) {
                Element currentElement;
                String tagName;
                Node currentNode = children.item(loop);
                if (currentNode.getNodeType() == 1 && (tagName = (currentElement = (Element)currentNode).getTagName()).equals(PARAM_TAG)) {
                    this.setParameter(currentElement, propSetter);
                }
                ++loop;
            }
            propSetter.activate();
            appender.setErrorHandler(eh);
        }
    }

    protected void parseFilters(Element element, Appender appender) {
        String clazz = this.subst(element.getAttribute(CLASS_ATTR));
        Filter filter = (Filter)OptionConverter.instantiateByClassName(clazz, class$org$apache$log4j$spi$Filter == null ? (class$org$apache$log4j$spi$Filter = DOMConfigurator.class$("org.apache.log4j.spi.Filter")) : class$org$apache$log4j$spi$Filter, null);
        if (filter != null) {
            PropertySetter propSetter = new PropertySetter(filter);
            NodeList children = element.getChildNodes();
            int length = children.getLength();
            int loop = 0;
            while (loop < length) {
                Element currentElement;
                String tagName;
                Node currentNode = children.item(loop);
                if (currentNode.getNodeType() == 1 && (tagName = (currentElement = (Element)currentNode).getTagName()).equals(PARAM_TAG)) {
                    this.setParameter(currentElement, propSetter);
                }
                ++loop;
            }
            propSetter.activate();
            appender.addFilter(filter);
        }
    }

    protected void parseCategory(Element categoryElement, Hierarchy hierarchy) {
        Category cat;
        String catName = this.subst(categoryElement.getAttribute(NAME_ATTR));
        String className = this.subst(categoryElement.getAttribute(CLASS_ATTR));
        if (EMPTY_STR.equals(className)) {
            LogLog.debug("Retreiving an instance of org.apache.log4j.Category.");
            cat = hierarchy.getInstance(catName);
        } else {
            LogLog.debug("Desired category sub-class: [" + className + ']');
            try {
                Class<?> clazz = Class.forName(className);
                Method getInstanceMethod = clazz.getMethod("getInstance", ONE_STRING_PARAM);
                cat = (Category)getInstanceMethod.invoke(null, catName);
            }
            catch (Exception oops) {
                LogLog.error("Could not retrieve category [" + catName + "]. Reported error follows.", oops);
                return;
            }
        }
        Category category = cat;
        synchronized (category) {
            boolean additivity = OptionConverter.toBoolean(this.subst(categoryElement.getAttribute(ADDITIVITY_ATTR)), true);
            LogLog.debug("Setting [" + cat.getName() + "] additivity to [" + additivity + "].");
            cat.setAdditivity(additivity);
            this.parseChildrenOfCategoryElement(categoryElement, cat, false);
        }
    }

    protected void parseRoot(Element rootElement, Hierarchy hierarchy) {
        Category root;
        Category category = root = hierarchy.getRoot();
        synchronized (category) {
            this.parseChildrenOfCategoryElement(rootElement, root, true);
        }
    }

    protected void parseChildrenOfCategoryElement(Element catElement, Category cat, boolean isRoot) {
        PropertySetter propSetter = new PropertySetter(cat);
        cat.removeAllAppenders();
        NodeList children = catElement.getChildNodes();
        int length = children.getLength();
        int loop = 0;
        while (loop < length) {
            Node currentNode = children.item(loop);
            if (currentNode.getNodeType() == 1) {
                Element currentElement = (Element)currentNode;
                String tagName = currentElement.getTagName();
                if (tagName.equals(APPENDER_REF_TAG)) {
                    Element appenderRef = (Element)currentNode;
                    Appender appender = this.findAppenderByReference(appenderRef);
                    String refName = this.subst(appenderRef.getAttribute(REF_ATTR));
                    if (appender != null) {
                        LogLog.debug("Adding appender named [" + refName + "] to category [" + cat.getName() + "].");
                    } else {
                        LogLog.debug("Appender named [" + refName + "] not found.");
                    }
                    cat.addAppender(appender);
                } else if (tagName.equals(PRIORITY_TAG)) {
                    this.parsePriority(currentElement, cat, isRoot);
                } else if (tagName.equals(PARAM_TAG)) {
                    this.setParameter(currentElement, propSetter);
                }
            }
            ++loop;
        }
        propSetter.activate();
    }

    protected Layout parseLayout(Element layout_element) {
        String className = this.subst(layout_element.getAttribute(CLASS_ATTR));
        LogLog.debug("Parsing layout of class: \"" + className + "\"");
        try {
            Object instance = Class.forName(className).newInstance();
            Layout layout = (Layout)instance;
            PropertySetter propSetter = new PropertySetter(layout);
            NodeList params = layout_element.getChildNodes();
            int length = params.getLength();
            int loop = 0;
            while (loop < length) {
                Element currentElement;
                String tagName;
                Node currentNode = params.item(loop);
                if (currentNode.getNodeType() == 1 && (tagName = (currentElement = (Element)currentNode).getTagName()).equals(PARAM_TAG)) {
                    this.setParameter(currentElement, propSetter);
                }
                ++loop;
            }
            propSetter.activate();
            return layout;
        }
        catch (Exception oops) {
            LogLog.error("Could not create the Layout. Reported error follows.", oops);
            return null;
        }
    }

    protected void parseRenderer(Element element, Hierarchy hierarchy) {
        String renderingClass = this.subst(element.getAttribute(RENDERING_CLASS_ATTR));
        String renderedClass = this.subst(element.getAttribute(RENDERED_CLASS_ATTR));
        this.addRenderer(hierarchy, renderedClass, renderingClass);
    }

    protected void parsePriority(Element element, Category cat, boolean isRoot) {
        String catName = cat.getName();
        if (isRoot) {
            catName = ROOT_TAG;
        }
        String priStr = this.subst(element.getAttribute(VALUE_ATTR));
        LogLog.debug("Priority value for " + catName + " is  [" + priStr + "].");
        if ("inherited".equals(priStr)) {
            if (isRoot) {
                LogLog.error("Root priority cannot be inherited. Ignoring directive.");
            } else {
                cat.setPriority(null);
            }
        } else {
            String className = this.subst(element.getAttribute(CLASS_ATTR));
            if (EMPTY_STR.equals(className)) {
                cat.setPriority(Priority.toPriority(priStr));
            } else {
                LogLog.debug("Desired Priority sub-class: [" + className + ']');
                try {
                    Class<?> clazz = Class.forName(className);
                    Method toPriorityMethod = clazz.getMethod("toPriority", ONE_STRING_PARAM);
                    Priority pri = (Priority)toPriorityMethod.invoke(null, priStr);
                    cat.setPriority(pri);
                }
                catch (Exception oops) {
                    LogLog.error("Could not create priority [" + priStr + "]. Reported error follows.", oops);
                    return;
                }
            }
        }
        LogLog.debug(catName + " priority set to " + cat.getPriority());
    }

    protected void setParameter(Element elem, PropertySetter propSetter) {
        String name = this.subst(elem.getAttribute(NAME_ATTR));
        String value = elem.getAttribute(VALUE_ATTR);
        value = this.subst(OptionConverter.convertSpecialChars(value));
        propSetter.setProperty(name, value);
    }

    public static void configure(Element element) {
        DOMConfigurator configurator = new DOMConfigurator();
        configurator.parse(element, Category.getDefaultHierarchy());
    }

    public static void configureAndWatch(String configFilename) {
        DOMConfigurator.configureAndWatch(configFilename, 60000L);
    }

    public static void configureAndWatch(String configFilename, long delay) {
        XMLWatchdog xdog = new XMLWatchdog(configFilename);
        xdog.setDelay(delay);
        xdog.start();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doConfigure(String filename, Hierarchy hierarchy) {
        FileInputStream fis = null;
        fis = new FileInputStream(filename);
        this.doConfigure(fis, hierarchy);
        Object var6_4 = null;
        if (fis == null) return;
        try {
            fis.close();
            return;
        }
        catch (IOException e2) {
            LogLog.error("Could not close [" + filename + "].", e2);
        }
        return;
        {
            catch (IOException e) {
                LogLog.error("Could not open [" + filename + "].", e);
                Object var6_5 = null;
                if (fis == null) return;
                try {
                    fis.close();
                    return;
                }
                catch (IOException e2) {
                    LogLog.error("Could not close [" + filename + "].", e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e2) {
                LogLog.error("Could not close [" + filename + "].", e2);
            }
            throw throwable;
        }
    }

    public void doConfigure(URL url, Hierarchy hierarchy) {
        try {
            this.doConfigure(url.openStream(), hierarchy);
        }
        catch (IOException e) {
            LogLog.error("Could not open [" + url + "].", e);
        }
    }

    public void doConfigure(InputStream input, Hierarchy hierarchy) throws FactoryConfigurationError {
        DocumentBuilderFactory dbf = null;
        try {
            LogLog.debug("System property is :" + OptionConverter.getSystemProperty(dbfKey, null));
            dbf = DocumentBuilderFactory.newInstance();
            LogLog.debug("Standard DocumentBuilderFactory search succeded.");
            LogLog.debug("DocumentBuilderFactory is: " + dbf.getClass().getName());
        }
        catch (FactoryConfigurationError fce) {
            Exception e = fce.getException();
            LogLog.debug("Could not instantiate a DocumentBuilderFactory.", e);
            throw fce;
        }
        try {
            dbf.setValidating(true);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            InputSource inputSource = new InputSource(input);
            Class<?> clazz = this.getClass();
            URL dtdURL = clazz.getResource("/org/apache/log4j/xml/log4j.dtd");
            if (dtdURL == null) {
                LogLog.error("Could not find [log4j.dtd]. Used [" + clazz.getClassLoader() + "] class loader in the search.");
            } else {
                LogLog.debug("URL to log4j.dtd is [" + dtdURL.toString() + "].");
                inputSource.setSystemId(dtdURL.toString());
            }
            Document doc = docBuilder.parse(inputSource);
            this.parse(doc.getDocumentElement(), hierarchy);
        }
        catch (Exception e) {
            LogLog.error("Could not parse input stream [" + input + "].", e);
        }
    }

    public static void configure(String filename) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(filename, Category.getDefaultHierarchy());
    }

    protected void parse(Element element, Hierarchy hierarchy) {
        String rootElementName = element.getTagName();
        if (!rootElementName.equals(CONFIGURATION_TAG)) {
            if (rootElementName.equals(OLD_CONFIGURATION_TAG)) {
                LogLog.warn("The <configuration> element has been deprecated.");
                LogLog.warn("Use the <log4j:configuration> element instead.");
            } else {
                LogLog.error("DOM element is - not a <log4j:configuration> element.");
                return;
            }
        }
        String debugAttrib = this.subst(element.getAttribute(INTERNAL_DEBUG_ATTR));
        LogLog.debug("debug attribute= \"" + debugAttrib + "\".");
        if (!debugAttrib.equals(EMPTY_STR) && !debugAttrib.equals("null")) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(debugAttrib, true));
        } else {
            LogLog.debug("Ignoring debug attribute.");
        }
        String confDebug = this.subst(element.getAttribute(CONFIG_DEBUG_ATTR));
        if (!confDebug.equals(EMPTY_STR) && !confDebug.equals("null")) {
            LogLog.warn("The \"configDebug\" attribute is deprecated.");
            LogLog.warn("Use the \"debug\" attribute instead.");
            LogLog.setInternalDebugging(OptionConverter.toBoolean(confDebug, true));
        }
        String override = this.subst(element.getAttribute(DISABLE_OVERRIDE_ATTR));
        LogLog.debug("Disable override=\"" + override + "\".");
        if (!override.equals(EMPTY_STR) && !override.equals("null")) {
            hierarchy.overrideAsNeeded(override);
        }
        String disableStr = this.subst(element.getAttribute(DISABLE_ATTR));
        LogLog.debug("Disable =\"" + disableStr + "\".");
        if (!EMPTY_STR.equals(disableStr) && !"null".equals(disableStr)) {
            hierarchy.disable(disableStr);
        }
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int loop = 0;
        while (loop < length) {
            Node currentNode = children.item(loop);
            if (currentNode.getNodeType() == 1) {
                Element currentElement = (Element)currentNode;
                String tagName = currentElement.getTagName();
                if (tagName.equals(CATEGORY)) {
                    this.parseCategory(currentElement, hierarchy);
                } else if (tagName.equals(ROOT_TAG)) {
                    this.parseRoot(currentElement, hierarchy);
                } else if (tagName.equals(RENDERER_TAG)) {
                    this.parseRenderer(currentElement, hierarchy);
                }
            }
            ++loop;
        }
    }

    protected String subst(String value) {
        try {
            return OptionConverter.substVars(value, this.props);
        }
        catch (IllegalArgumentException e) {
            LogLog.warn("Could not perform variable substitution.", e);
            return value;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

