use ExtUtils::MakeMaker;


## If this is being installed with Atoms of with Ifeffit, then
## $ENV{INSTALLING_WITH} will be set by Atoms' topmost Makefile.PL.
my $blib;
SWITCH : {
  $blib = "blib",       last SWITCH if (not $ENV{INSTALLING_WITH});
  $blib = "../blib",    last SWITCH if ($ENV{INSTALLING_WITH} eq 'atoms');
  $blib = "../blib",    last SWITCH if ($ENV{INSTALLING_WITH} eq 'horae');
  $blib = "../../blib", last SWITCH if ($ENV{INSTALLING_WITH} eq 'ifeffit');
};

#print "In Absorption:  blib=$blib\n";

my @cl_ok = ('linux', 'irix');
my $cl_match = join('|', @cl_ok);
my $make_cl = 0; #($^O =~ /($cl_match)/);

WriteMakefile
  (
   'NAME'	  => 'Xray::Absorption',
   'DISTNAME'	  => 'Absorption',
   'VERSION_FROM' => 'Absorption.pm', # finds $VERSION
   'dist'	  => { COMPRESS => 'gzip -f', SUFFIX => 'gz' },
   ($] >= 5.005 ?
    ('ABSTRACT' =>
     'Absorption.pm: Object methods for x-ray absorption cross sections',
     'AUTHOR'   => 'Bruce Ravel (ravel@phys.washington.edu)') : ()),
   'PL_FILES'	=>
   {
    'dat2st.PL'	      => 'mcmaster.db',
    'elam2st.PL'      => 'elam.db',
    'henke2st.PL'     => 'henke.db',
    'chantler2st.PL'  => 'chantler.db',
    'cl2st.PL'	      => 'cl.db',
    'hubbell_g2st.PL' => 'hubbell_g.db',
   },
   'PM' =>
   {				# the modules
    'Absorption.pm' => "$blib/lib/Xray/Absorption.pm",
    'McMaster.pm'   => "$blib/lib/Xray/Absorption/McMaster.pm",
    'mcmaster.db'   => "$blib/lib/Xray/Absorption/mcmaster.db",
    'Elam.pm'	    => "$blib/lib/Xray/Absorption/Elam.pm",
    'elam.db'	    => "$blib/lib/Xray/Absorption/elam.db",
    'Henke.pm'	    => "$blib/lib/Xray/Absorption/Henke.pm",
    'henke.db'	    => "$blib/lib/Xray/Absorption/henke.db",
    'Chantler.pm'   => "$blib/lib/Xray/Absorption/Chantler.pm",
    'chantler.db'   => "$blib/lib/Xray/Absorption/chantler.db",
    'None.pm'       => "$blib/lib/Xray/Absorption/None.pm",
    'CL.pm'	    => "$blib/lib/Xray/Absorption/CL.pm",
    'cl.db'	    => "$blib/lib/Xray/Absorption/cl.db",
    'hubbell_g.db'  => "$blib/lib/Xray/Absorption/hubbell_g.db",
   }
  );
