/*
 * ActiveAssistant.java
 *
 * Created on December 25, 2003, 11:39 AM
 */

package com.sun.enterprise.config.backup;
import com.sun.enterprise.config.backup.status.Status;
import com.sun.enterprise.config.backup.utils.FactoryHelper;


/**
 * Actively adds assistance information into the status
 *
 * @author  sridatta
 */
public class ActiveAssistanceManager {
    
    /** Creates a new instance of ActiveAssistant */
    public ActiveAssistanceManager() {
    }
    
    public void assist(Status s) {
        //get status
        if(s == null) {
            //nothing to assist
            return;
        }
        
        if(s.isSuccess()) {
            addDidYouKnow(s);
        } else {
            addDiagnosabilityInfo(s);
        }
    }
    
    private void addDidYouKnow(Status s) {
        s.setExtraInfo(getDidYouKnow(s));
    }
    
    private String getDidYouKnow(Status s) {
        String text = getDidYouKnowText(s);
        if (text == null || "".equals(text)) return null;
        return "Did You Know? \n" + text;
    }
    
    private void addDiagnosabilityInfo(Status s) {
        if(s == null) return;
        
        String info = getDiagInfo(s);
        if (info == null || "".equals(info)) return;

        s.setExtraInfo(info);
    }
    private String getDiagInfo(Status s) {
        String info = getDiagText(s);
        if(info == null) return null;
        return "Hints: \n" + info;
    }
    
    private String getDidYouKnowText(Status status) {
        return FactoryHelper.getAssistance().getDidYouKnow(status); 
    }
     
    private String getDiagText(Status s) {
        return FactoryHelper.getAssistance().getDiagnosabilityInfo(s); 
    }
}
