/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.UtilErrors;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;

public class Util {
    private static UtilErrors error = UtilErrors.NO_ERROR;

    public static boolean validFile(File f) {
        error.setDetails("File passed to method validFile()");
        boolean valid = false;
        if (f == null) {
            error = UtilErrors.PARAM_NULL;
        } else {
            if (!f.exists()) {
                error = UtilErrors.DOES_NOT_EXIST;
            } else if (!f.isFile()) {
                error = UtilErrors.NOT_A_FILE;
            } else if (!f.canRead()) {
                error = UtilErrors.NOT_READABLE;
            } else {
                valid = true;
            }
            error.setDetails(f.getAbsolutePath());
        }
        return valid;
    }

    public static UtilErrors getError() {
        return error;
    }

    public static int pow2(int x) {
        int res = 1;
        int i = 0;
        while (i < x) {
            res *= 2;
            ++i;
        }
        return res;
    }

    public static String tabs(int n) {
        int i = 0;
        String res = "";
        i = 0;
        while (i < n) {
            res = String.valueOf(res) + "\t";
            ++i;
        }
        return res;
    }

    public static void showDialogOk(Component parent, String title, Object message) {
        JOptionPane.showMessageDialog(parent, message, title, 1);
    }

    public static String closeIS(InputStream IS) {
        String res = null;
        if (IS != null) {
            try {
                IS.close();
            }
            catch (IOException IOE) {
                res = IOE.toString();
            }
        }
        return res;
    }

    public static void waitFor(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String fieldFor(String fieldName, Object object, Boolean firstField) {
        String resp = "";
        if (object != null) {
            Boolean booleanField = new Boolean(false);
            if (!object.getClass().isInstance(booleanField)) {
                String string = resp = fieldName != null ? String.valueOf(fieldName) + ": " : "";
                if (firstField.booleanValue()) {
                    firstField = new Boolean(false);
                } else {
                    resp = ", " + resp;
                }
                resp = String.valueOf(resp) + object;
            } else {
                booleanField = (Boolean)object;
                if (booleanField.booleanValue()) {
                    firstField = new Boolean(false);
                    resp = fieldName;
                }
            }
        }
        return resp;
    }

    public static String fieldFor(String fieldName, boolean aFlag, Boolean firstField) {
        return Util.fieldFor(fieldName, new Boolean(aFlag), firstField);
    }

    public static void drawLine(Graphics g, Point a, Point b) {
        g.drawLine(a.x, a.y, b.x, b.y);
    }

    public static void centerComponent(Component c, Point p, Dimension dim) {
        if (c != null && p != null && dim != null) {
            c.setBounds(p.x - dim.width / 2, p.y - dim.height / 2, dim.width, dim.height);
        }
    }

    public static void drawString(Graphics g, String text, Point p) {
        g.drawString(text, p.x, p.y);
    }

    public static Point centerString(Graphics g, String text, int x, int y) {
        Point p = null;
        if (g != null) {
            int dx = g.getFontMetrics().stringWidth(text);
            int fontAscent = g.getFontMetrics().getAscent();
            p = new Point();
            p.x = x - dx / 2 + 1;
            p.y = y - fontAscent;
        }
        return p;
    }
}

