/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.format;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Stack;
import org.apache.log.ContextStack;
import org.apache.log.Formatter;
import org.apache.log.LogEntry;
import org.apache.log.LogKit;
import org.apache.log.Priority;

public class PatternFormatter
implements Formatter {
    protected static final int TYPE_TEXT = 1;
    protected static final int TYPE_CATEGORY = 2;
    protected static final int TYPE_CONTEXT = 3;
    protected static final int TYPE_MESSAGE = 4;
    protected static final int TYPE_TIME = 5;
    protected static final int TYPE_THROWABLE = 6;
    protected static final int TYPE_PRIORITY = 7;
    protected static final String TYPE_CATEGORY_STR = "category";
    protected static final String TYPE_CONTEXT_STR = "context";
    protected static final String TYPE_MESSAGE_STR = "message";
    protected static final String TYPE_TIME_STR = "time";
    protected static final String TYPE_THROWABLE_STR = "throwable";
    protected static final String TYPE_PRIORITY_STR = "priority";
    protected static final String SPACE_16 = "                ";
    protected static final String SPACE_8 = "        ";
    protected static final String SPACE_4 = "    ";
    protected static final String SPACE_2 = "  ";
    protected static final String SPACE_1 = " ";
    protected PatternRun[] m_formatSpecification;

    protected int addPatternRun(Stack stack, char[] cArray, int n) {
        int n2;
        PatternRun patternRun = new PatternRun();
        int n3 = n++;
        if ('+' == cArray[n]) {
            ++n;
        } else if ('-' == cArray[n]) {
            patternRun.m_rightJustify = true;
            ++n;
        }
        if (Character.isDigit(cArray[n])) {
            n2 = 0;
            while (Character.isDigit(cArray[n])) {
                n2 = n2 * 10 + (cArray[n] - 48);
                ++n;
            }
            patternRun.m_minSize = n2;
        }
        if (n < cArray.length && '.' == cArray[n] && Character.isDigit(cArray[++n])) {
            n2 = 0;
            while (Character.isDigit(cArray[n])) {
                n2 = n2 * 10 + (cArray[n] - 48);
                ++n;
            }
            patternRun.m_maxSize = n2;
        }
        if (n >= cArray.length || '{' != cArray[n]) {
            throw new IllegalArgumentException("Badly formed pattern at character " + n);
        }
        n2 = n;
        while (n < cArray.length && cArray[n] != ':' && cArray[n] != '}') {
            ++n;
        }
        int n4 = n - 1;
        String string = new String(cArray, n2 + 1, n4 - n2);
        patternRun.m_type = this.getTypeIdFor(string);
        if (n < cArray.length && cArray[n] == ':') {
            ++n;
            while (n < cArray.length && cArray[n] != '}') {
                ++n;
            }
            int n5 = n - n4 - 2;
            if (n5 != 0) {
                patternRun.m_format = new String(cArray, n4 + 2, n5);
            }
        }
        if (n >= cArray.length || '}' != cArray[n]) {
            throw new IllegalArgumentException("Unterminated type in pattern at character " + n);
        }
        stack.push(patternRun);
        return ++n - n3;
    }

    protected int addTextRun(Stack stack, char[] cArray, int n) {
        PatternRun patternRun = new PatternRun();
        int n2 = n;
        boolean bl = false;
        if ('%' == cArray[n]) {
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n < cArray.length && cArray[n] != '%') {
            if (bl) {
                if ('n' == cArray[n]) {
                    stringBuffer.append('\n');
                } else if ('t' == cArray[n]) {
                    stringBuffer.append('\t');
                } else {
                    stringBuffer.append(cArray[n]);
                }
                bl = false;
            } else if ('\\' == cArray[n]) {
                bl = true;
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        patternRun.m_data = stringBuffer.toString();
        patternRun.m_type = 1;
        stack.push(patternRun);
        return n - n2;
    }

    protected void append(StringBuffer stringBuffer, int n, int n2, boolean bl, String string) {
        int n3 = string.length();
        if (n3 < n) {
            if (bl) {
                this.appendWhiteSpace(stringBuffer, n - n3);
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string);
                this.appendWhiteSpace(stringBuffer, n - n3);
            }
        } else if (n2 > 0 && n2 < n3) {
            stringBuffer.append(string.substring(0, n2));
        } else {
            stringBuffer.append(string);
        }
    }

    protected void appendWhiteSpace(StringBuffer stringBuffer, int n) {
        while (n >= 16) {
            stringBuffer.append(SPACE_16);
            n -= 16;
        }
        if (n >= 8) {
            stringBuffer.append(SPACE_8);
            n -= 8;
        }
        if (n >= 4) {
            stringBuffer.append(SPACE_4);
            n -= 4;
        }
        if (n >= 2) {
            stringBuffer.append(SPACE_2);
            n -= 2;
        }
        if (n >= 1) {
            stringBuffer.append(SPACE_1);
            --n;
        }
    }

    public String format(LogEntry logEntry) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        int n = 0;
        while (n < this.m_formatSpecification.length) {
            block10: {
                PatternRun patternRun = this.m_formatSpecification[n];
                switch (patternRun.m_type) {
                    case 1: {
                        stringBuffer.append(patternRun.m_data);
                        break block10;
                    }
                    case 5: {
                        string = this.getTime(logEntry.getTime(), patternRun.m_format);
                        break;
                    }
                    case 6: {
                        string = this.getStackTrace(logEntry.getThrowable(), patternRun.m_format);
                        break;
                    }
                    case 4: {
                        string = this.getMessage(logEntry.getMessage(), patternRun.m_format);
                        break;
                    }
                    case 3: {
                        string = this.getContext(logEntry.getContextStack(), patternRun.m_format);
                        break;
                    }
                    case 2: {
                        string = this.getCategory(logEntry.getCategory().getName(), patternRun.m_format);
                        break;
                    }
                    case 7: {
                        string = this.getPriority(logEntry.getPriority(), patternRun.m_format);
                        break;
                    }
                    default: {
                        LogKit.log("Unknown Pattern specification." + patternRun.m_type);
                        break block10;
                    }
                }
                this.append(stringBuffer, patternRun.m_minSize, patternRun.m_maxSize, patternRun.m_rightJustify, string);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected String getCategory(String string, String string2) {
        return string;
    }

    protected String getPriority(Priority.Enum enum_, String string) {
        return enum_.getName();
    }

    protected String getContext(ContextStack contextStack, String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = contextStack.getSize();
        int n3 = Integer.MAX_VALUE;
        if (string != null) {
            try {
                n3 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        int n4 = n2 - 1;
        int n5 = n = Math.max(n4 - n3 + 1, 0);
        while (n5 < n4) {
            stringBuffer.append(contextStack.get(n5));
            stringBuffer.append('.');
            ++n5;
        }
        stringBuffer.append(contextStack.get(n4));
        return stringBuffer.toString();
    }

    protected String getMessage(String string, String string2) {
        return string;
    }

    protected String getStackTrace(Throwable throwable, String string) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    protected String getTime(long l, String string) {
        return Long.toString(l);
    }

    protected int getTypeIdFor(String string) {
        if (string.equalsIgnoreCase(TYPE_CATEGORY_STR)) {
            return 2;
        }
        if (string.equalsIgnoreCase(TYPE_CONTEXT_STR)) {
            return 3;
        }
        if (string.equalsIgnoreCase(TYPE_MESSAGE_STR)) {
            return 4;
        }
        if (string.equalsIgnoreCase(TYPE_PRIORITY_STR)) {
            return 7;
        }
        if (string.equalsIgnoreCase(TYPE_TIME_STR)) {
            return 5;
        }
        if (string.equalsIgnoreCase(TYPE_THROWABLE_STR)) {
            return 6;
        }
        throw new IllegalArgumentException("Unknown Type in pattern - " + string);
    }

    protected void parse(String string) {
        Stack stack = new Stack();
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        string.getChars(0, n, cArray, 0);
        while (n2 < n) {
            if (cArray[n2] == '%' && (n2 == n - 1 || cArray[n2 + 1] != '%')) {
                n2 += this.addPatternRun(stack, cArray, n2);
                continue;
            }
            n2 += this.addTextRun(stack, cArray, n2);
        }
        int n3 = stack.size();
        this.m_formatSpecification = new PatternRun[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.m_formatSpecification[n4] = (PatternRun)stack.elementAt(n4);
            ++n4;
        }
    }

    public void setFormat(String string) {
        this.parse(string);
    }

    protected static class PatternRun {
        String m_data;
        boolean m_rightJustify;
        int m_minSize;
        int m_maxSize;
        int m_type;
        String m_format;

        PatternRun() {
        }
    }
}

