/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import org.apache.log.Category;
import org.apache.log.ContextStack;
import org.apache.log.LogEngine;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;

public final class LogKit {
    protected static final ThreadLocal c_context = new ThreadLocal();
    protected static final LogEngine c_engine = new LogEngine();

    public static LogEngine getDefaultLogEngine() {
        return c_engine;
    }

    public static void addLogTarget(String string, LogTarget logTarget) {
        c_engine.addLogTarget(string, logTarget);
    }

    public static LogTarget getLogTarget(String string) {
        return c_engine.getLogTarget(string);
    }

    public static Category createCategory(String string, Priority.Enum enum_) {
        return c_engine.createCategory(string, enum_);
    }

    public static Logger createLogger(Category category) {
        return c_engine.createLogger(category);
    }

    public static Logger createLogger(Category category, LogTarget[] logTargetArray) {
        return c_engine.createLogger(category, logTargetArray);
    }

    public static ContextStack getCurrentContext() {
        ContextStack contextStack = (ContextStack)c_context.get();
        if (contextStack == null) {
            contextStack = new ContextStack();
            contextStack.push(Thread.currentThread().getName());
            c_context.set(contextStack);
        }
        return contextStack;
    }

    public static LogTarget getDefaultLogTarget() {
        return c_engine.getDefaultLogTarget();
    }

    public static Priority.Enum getGlobalPriority() {
        return c_engine.getGlobalPriority();
    }

    public static Logger getLoggerFor(String string) {
        return c_engine.getLoggerFor(string);
    }

    public static Priority.Enum getPriorityForName(String string) {
        if (Priority.DEBUG.getName().equals(string)) {
            return Priority.DEBUG;
        }
        if (Priority.INFO.getName().equals(string)) {
            return Priority.INFO;
        }
        if (Priority.WARN.getName().equals(string)) {
            return Priority.WARN;
        }
        if (Priority.ERROR.getName().equals(string)) {
            return Priority.ERROR;
        }
        if (Priority.FATAL_ERROR.getName().equals(string)) {
            return Priority.FATAL_ERROR;
        }
        return Priority.DEBUG;
    }

    public static void log(String string, Throwable throwable) {
        c_engine.log(string, throwable);
    }

    public static void log(String string) {
        c_engine.log(string);
    }

    public static void setDefaultLogTarget(LogTarget logTarget) {
        c_engine.setDefaultLogTarget(logTarget);
    }

    public static void setGlobalPriority(Priority.Enum enum_) {
        c_engine.setGlobalPriority(enum_);
    }

    private LogKit() {
    }
}

