/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.net;

import com.oroinc.net.telnet.TelnetClient;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class TelnetTask
extends Task {
    private String userid = null;
    private String password = null;
    private String server = null;
    private int port = 23;
    private AntTelnetClient telnet = null;
    private Vector telnetTasks = new Vector();
    private boolean addCarriageReturn = false;
    private Integer defaultTimeout = null;

    public void execute() throws BuildException {
        if (this.server == null) {
            throw new BuildException("No Server Specified");
        }
        if (this.userid == null && this.password != null) {
            throw new BuildException("No Userid Specified");
        }
        if (this.password == null && this.userid != null) {
            throw new BuildException("No Password Specified");
        }
        this.telnet = new AntTelnetClient();
        try {
            this.telnet.connect(this.server, this.port);
        }
        catch (IOException iOException) {
            throw new BuildException("Can't connect to " + this.server);
        }
        if (this.userid != null && this.password != null) {
            this.login();
        }
        Enumeration enumeration = this.telnetTasks.elements();
        while (enumeration != null && enumeration.hasMoreElements()) {
            TelnetSubTask telnetSubTask = (TelnetSubTask)enumeration.nextElement();
            if (telnetSubTask instanceof TelnetRead && this.defaultTimeout != null) {
                ((TelnetRead)telnetSubTask).setDefaultTimeout(this.defaultTimeout);
            }
            telnetSubTask.execute(this.telnet);
        }
    }

    private void login() {
        if (this.addCarriageReturn) {
            this.telnet.sendString("\n", true);
        }
        this.telnet.waitForString("ogin:");
        this.telnet.sendString(this.userid, true);
        this.telnet.waitForString("assword:");
        this.telnet.sendString(this.password, false);
    }

    public void setUserid(String string) {
        this.userid = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setInitialCR(boolean bl) {
        this.addCarriageReturn = bl;
    }

    public void setTimeout(Integer n) {
        this.defaultTimeout = n;
    }

    public TelnetSubTask createRead() {
        TelnetRead telnetRead = new TelnetRead();
        this.telnetTasks.addElement(telnetRead);
        return telnetRead;
    }

    public TelnetSubTask createWrite() {
        TelnetWrite telnetWrite = new TelnetWrite();
        this.telnetTasks.addElement(telnetWrite);
        return telnetWrite;
    }

    public class AntTelnetClient
    extends TelnetClient {
        public void waitForString(String string) {
            this.waitForString(string, null);
        }

        /*
         * Unable to fully structure code
         */
        public void waitForString(String var1_1, Integer var2_2) {
            var3_3 = this.getInputStream();
            try {
                block8: {
                    block7: {
                        var4_4 = new StringBuffer();
                        if (var2_2 != null && var2_2 != 0) break block7;
                        while (var4_4.toString().indexOf(var1_1) == -1) {
                            var4_4.append((char)var3_3.read());
                        }
                        break block8;
                    }
                    var5_6 = Calendar.getInstance();
                    var5_6.add(13, var2_2);
                    ** GOTO lbl21
                    {
                        Thread.sleep(250L);
                        do {
                            if (Calendar.getInstance().before(var5_6) && var3_3.available() == 0) continue block4;
                            if (var3_3.available() == 0) {
                                throw new BuildException("Response Timed-Out", TelnetTask.this.getLocation());
                            }
                            var4_4.append((char)var3_3.read());
lbl21:
                            // 2 sources

                        } while (var4_4.toString().indexOf(var1_1) == -1);
                    }
                }
                TelnetTask.this.log(var4_4.toString(), 2);
            }
            catch (BuildException var4_5) {
                throw var4_5;
            }
            catch (Exception var5_7) {
                throw new BuildException((Throwable)var5_7, TelnetTask.this.getLocation());
            }
        }

        public void sendString(String string, boolean bl) {
            OutputStream outputStream = this.getOutputStream();
            try {
                outputStream.write((string + "\n").getBytes());
                if (bl) {
                    TelnetTask.this.log(string, 2);
                }
                outputStream.flush();
            }
            catch (Exception exception) {
                throw new BuildException((Throwable)exception, TelnetTask.this.getLocation());
            }
        }
    }

    public class TelnetRead
    extends TelnetSubTask {
        private Integer timeout = null;

        public void execute(AntTelnetClient antTelnetClient) throws BuildException {
            antTelnetClient.waitForString(this.taskString, this.timeout);
        }

        public void setTimeout(Integer n) {
            this.timeout = n;
        }

        public void setDefaultTimeout(Integer n) {
            if (this.timeout == null) {
                this.timeout = n;
            }
        }
    }

    public class TelnetWrite
    extends TelnetSubTask {
        private boolean echoString = true;

        public void execute(AntTelnetClient antTelnetClient) throws BuildException {
            antTelnetClient.sendString(this.taskString, this.echoString);
        }

        public void setEcho(boolean bl) {
            this.echoString = bl;
        }
    }

    public class TelnetSubTask {
        protected String taskString = "";

        public void execute(AntTelnetClient antTelnetClient) throws BuildException {
            throw new BuildException("Shouldn't be able instantiate a SubTask directly");
        }

        public void addText(String string) {
            this.setString(string);
        }

        public void setString(String string) {
            this.taskString = this.taskString + string;
        }
    }
}

