/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;

public class WLRun
extends Task {
    protected static final String DEFAULT_WL51_POLICY_FILE = "weblogic.policy";
    protected static final String DEFAULT_WL60_POLICY_FILE = "lib/weblogic.policy";
    protected static final String DEFAULT_PROPERTIES_FILE = "weblogic.properties";
    private Path classpath;
    private Path weblogicClasspath;
    private String weblogicMainClass = "weblogic.Server";
    private String additionalArgs = "";
    private String securityPolicy;
    private File weblogicSystemHome;
    private String weblogicDomainName;
    private String weblogicSystemName = "myserver";
    private String weblogicPropertiesFile = null;
    private String additionalJvmArgs = "";
    private File beaHome = null;
    private String managementUsername = "system";
    private String managementPassword = null;
    private String pkPassword = null;

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public Path createWLClasspath() {
        if (this.weblogicClasspath == null) {
            this.weblogicClasspath = new Path(this.project);
        }
        return this.weblogicClasspath.createPath();
    }

    public void execute() throws BuildException {
        if (this.weblogicSystemHome == null) {
            throw new BuildException("weblogic home must be set");
        }
        if (!this.weblogicSystemHome.isDirectory()) {
            throw new BuildException("weblogic home directory " + this.weblogicSystemHome.getPath() + " is not valid");
        }
        if (this.beaHome != null) {
            this.executeWLS6();
        } else {
            this.executeWLS();
        }
    }

    private void executeWLS6() {
        if (!this.beaHome.isDirectory()) {
            throw new BuildException("BEA home " + this.beaHome.getPath() + " is not valid");
        }
        File file = null;
        file = this.securityPolicy == null ? new File(this.weblogicSystemHome, DEFAULT_WL60_POLICY_FILE) : new File(this.weblogicSystemHome, this.securityPolicy);
        File file2 = new File(this.weblogicSystemHome, "config/" + this.weblogicDomainName + "/config.xml");
        if (!file2.exists()) {
            throw new BuildException("Server config file " + file2 + " not found.");
        }
        if (this.managementPassword == null) {
            throw new BuildException("You must supply a management password to start the server");
        }
        Java java = (Java)this.project.createTask("java");
        java.setTaskName(this.getTaskName());
        java.setFork(true);
        java.setDir(this.weblogicSystemHome);
        java.setClassname(this.weblogicMainClass);
        String string = this.additionalJvmArgs;
        string = string + " -Dweblogic.Domain=" + this.weblogicDomainName;
        string = string + " -Dweblogic.Name=" + this.weblogicSystemName;
        string = string + " -Dweblogic.system.home=" + this.weblogicSystemHome;
        string = string + " -Dbea.home=" + this.beaHome;
        string = string + " -Djava.security.policy==" + file;
        string = string + " -Dweblogic.management.username=" + this.managementUsername;
        string = string + " -Dweblogic.management.password=" + this.managementPassword;
        if (this.pkPassword != null) {
            string = string + " -Dweblogic.pkpassword=" + this.pkPassword;
        }
        java.createJvmarg().setLine(string);
        java.createArg().setLine(this.additionalArgs);
        if (this.classpath != null) {
            java.setClasspath(this.classpath);
        }
        if (java.executeJava() != 0) {
            throw new BuildException("Execution of weblogic server failed");
        }
    }

    private void executeWLS() {
        File file = null;
        file = this.weblogicPropertiesFile == null ? new File(this.weblogicSystemHome, DEFAULT_PROPERTIES_FILE) : new File(this.weblogicSystemHome, this.weblogicPropertiesFile);
        if (!file.exists()) {
            throw new BuildException("Properties file " + this.weblogicPropertiesFile + " not found in weblogic home " + this.weblogicSystemHome);
        }
        File file2 = null;
        file2 = this.securityPolicy == null ? new File(this.weblogicSystemHome, DEFAULT_WL51_POLICY_FILE) : new File(this.weblogicSystemHome, this.securityPolicy);
        if (!file2.exists()) {
            throw new BuildException("Security policy " + file2 + " was not found.");
        }
        Java java = (Java)this.project.createTask("java");
        java.setTaskName(this.getTaskName());
        java.setFork(true);
        java.setClassname(this.weblogicMainClass);
        String string = this.additionalJvmArgs;
        if (this.weblogicClasspath != null) {
            string = string + " -Dweblogic.class.path=" + this.weblogicClasspath;
        }
        string = string + " -Djava.security.manager -Djava.security.policy==" + file2;
        string = string + " -Dweblogic.system.home=" + this.weblogicSystemHome;
        string = string + " -Dweblogic.system.name=" + this.weblogicSystemName;
        string = string + " -Dweblogic.system.propertiesFile=" + this.weblogicPropertiesFile;
        java.createJvmarg().setLine(string);
        java.createArg().setLine(this.additionalArgs);
        if (this.classpath != null) {
            java.setClasspath(this.classpath);
        }
        if (java.executeJava() != 0) {
            throw new BuildException("Execution of weblogic server failed");
        }
    }

    public void setClasspath(Path path) {
        this.classpath = path;
    }

    public void setWlclasspath(Path path) {
        this.weblogicClasspath = path;
    }

    public void setPolicy(String string) {
        this.securityPolicy = string;
    }

    public void setHome(File file) {
        this.weblogicSystemHome = file;
    }

    public void setBEAHome(File file) {
        this.beaHome = file;
    }

    public void setName(String string) {
        this.weblogicSystemName = string;
    }

    public void setDomain(String string) {
        this.weblogicDomainName = string;
    }

    public void setProperties(String string) {
        this.weblogicPropertiesFile = string;
    }

    public void setJvmargs(String string) {
        this.additionalJvmArgs = string;
    }

    public void setUsername(String string) {
        this.managementUsername = string;
    }

    public void setPassword(String string) {
        this.managementPassword = string;
    }

    public void setPKPassword(String string) {
        this.pkPassword = string;
    }

    public void setArgs(String string) {
        this.additionalArgs = string;
    }

    public void setWeblogicMainClass(String string) {
        this.weblogicMainClass = string;
    }
}

