/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.Profile;
import org.hsqldb.jdbcDriver;

class SelfTest {
    SelfTest() {
    }

    static void delete(String string) {
        try {
            new File(string).delete();
        }
        catch (Exception exception) {}
    }

    public static void main(String[] stringArray) {
        String string;
        SelfTest.print("Usage: SelfTest [records [-m]] (-m means in-memory only)");
        int n = 500;
        if (stringArray.length >= 1) {
            n = Integer.parseInt(stringArray[0]);
        }
        boolean bl = true;
        boolean bl2 = false;
        if (stringArray.length >= 2 && (string = stringArray[1]).equals("-m")) {
            bl = false;
        }
        SelfTest.test(n, bl);
    }

    private static void print(String string) {
        System.out.println(string);
    }

    static void printStatus(String string, int n, int n2, long l) {
        System.out.print(String.valueOf(string) + ": " + n + "/" + n2 + " " + 100 * n / n2 + "% ");
        long l2 = System.currentTimeMillis();
        if (l2 > l) {
            System.out.print((long)(n * 1000) / (l2 - l));
        }
        System.out.print(" rows/s                \r");
    }

    static void test(int n, boolean bl) {
        try {
            DriverManager.registerDriver(new jdbcDriver());
            if (bl) {
                SelfTest.delete("test2.backup");
                SelfTest.delete("test2.properties");
                SelfTest.delete("test2.script");
                SelfTest.delete("test2.data");
                SelfTest.test("Persistent", "jdbc:hsqldb:test2", "sa", "", n, true);
            }
            SelfTest.test("In-Memory", "jdbc:hsqldb:.", "sa", "", n, false);
            Profile.listUnvisited();
        }
        catch (Exception exception) {
            SelfTest.print("SelfTest error: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    static void test(String string, String string2, String string3, String string4, int n, boolean bl) throws Exception {
        String string5;
        SelfTest.print(string);
        Statement statement = null;
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string2, string3, string4);
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            SelfTest.print("SelfTest init error: " + exception.getMessage());
        }
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader("SelfTest.txt"));
        String string6 = "";
        while ((string5 = lineNumberReader.readLine()) != null) {
            if (string5.startsWith(" ")) {
                string6 = String.valueOf(string6) + string5;
                continue;
            }
            SelfTest.test(statement, string6);
            string6 = string5;
        }
        boolean bl2 = false;
        try {
            string6 = "CREATE TABLE marotest (id int PRIMARY KEY, dat int);INSERT INTO marotest VALUES (1,0);INSERT INTO marotest VALUES (2,0);INSERT INTO marotest VALUES (2,0);";
            try {
                statement.execute(string6);
                string6 = "";
            }
            catch (Exception exception) {}
            if (string6.equals("")) {
                throw new Exception("Duplicate key gave no error on insert");
            }
            try {
                string6 = "UPDATE marotest SET id=1, dat=-1 WHERE dat=0";
                statement.execute(string6);
                string6 = "";
            }
            catch (Exception exception) {}
            if (string6.equals("")) {
                throw new Exception("Duplicate key gave no error on update");
            }
            int n2 = 0;
            string6 = "SELECT *, id as marotest_id FROM marotest";
            ResultSet resultSet = statement.executeQuery(string6);
            while (resultSet.next()) {
                resultSet.getFloat(1);
                resultSet.getString("id");
                resultSet.getInt("DaT");
                resultSet.getInt("marotest_id");
                if (resultSet.getShort("dat") != 0) {
                    throw new Exception("Bad update worked");
                }
                resultSet.getLong("DAT");
                resultSet.getString(2);
                resultSet.getObject("ID");
                resultSet.clearWarnings();
                try {
                    resultSet.getTimestamp("Timestamp?");
                    n2 = 99;
                }
                catch (Exception exception) {}
                ++n2;
            }
            resultSet.close();
            if (n2 != 2) {
                throw new Exception("Should have 2 but has " + n2 + " rows");
            }
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getColumns(null, "dbo", "MAROTEST", "%");
            while (resultSet.next()) {
                string6 = resultSet.getString(4).trim();
                int n3 = resultSet.getInt(5);
                string6 = String.valueOf(string6) + n3 + resultSet.getString("TYPE_NAME");
                n3 = resultSet.getInt(7);
                n3 = resultSet.getInt(9);
                n3 = resultSet.getInt(11);
                if ((string6 = string6.toUpperCase()).equals("ID4INTEGER") || string6.equals("DAT4INTEGER")) continue;
                throw new Exception("Wrong database meta data");
            }
            string6 = "DROP TABLE marotest";
            statement.execute(string6);
            string6 = "create table TabProfile(id int primary key,car char,won bit,licence varbinary,name char,sex char,chance double,birthday date)";
            statement.execute(string6);
            string6 = "insert into TabProfile values ( ?, ?, ?, ?,'\"John\" the bird''s best friend', 'M',?,?);";
            PreparedStatement preparedStatement = connection.prepareStatement(string6);
            preparedStatement.clearParameters();
            preparedStatement.setInt(1, 10);
            preparedStatement.setString(2, "Matchcartoon");
            preparedStatement.setBoolean(3, true);
            byte[] byArray = new byte[5];
            byArray[1] = 1;
            byArray[2] = -128;
            byArray[3] = 44;
            byArray[4] = 12;
            byte[] byArray2 = byArray;
            preparedStatement.setBytes(4, byArray2);
            preparedStatement.setDouble(5, 50.5);
            preparedStatement.setNull(6, 91);
            preparedStatement.executeUpdate();
            preparedStatement.clearParameters();
            preparedStatement.setInt(1, -2);
            preparedStatement.setString(2, "\"Birdie\"'s car ?");
            preparedStatement.setBoolean(3, false);
            byte[] byArray3 = new byte[]{10, 127};
            preparedStatement.setBytes(4, byArray3);
            preparedStatement.setDouble(5, -3.1415E-20);
            preparedStatement.setDate(6, new Date(100, 1, 29));
            preparedStatement.executeUpdate();
            string6 = "select * from TabProfile where id=-2";
            resultSet = statement.executeQuery(string6);
            resultSet.next();
            if (!resultSet.getString(2).equals("\"Birdie\"'s car ?")) {
                throw new Exception("Unicode error.");
            }
            resultSet.close();
            string6 = "drop table TabProfile";
            statement.execute(string6);
            string6 = "create table obj(id int,o object)";
            statement.execute(string6);
            string6 = "insert into obj values(?,?)";
            preparedStatement = connection.prepareStatement(string6);
            preparedStatement.setInt(1, 1);
            int[] nArray = new int[]{1, 2, 3};
            preparedStatement.setObject(2, nArray);
            preparedStatement.executeUpdate();
            preparedStatement.clearParameters();
            preparedStatement.setInt(1, 2);
            Rectangle rectangle = new Rectangle(10, 11, 12, 13);
            preparedStatement.setObject(2, rectangle);
            preparedStatement.executeUpdate();
            resultSet = statement.executeQuery("SELECT o FROM obj ORDER BY id DESC");
            resultSet.next();
            Rectangle rectangle2 = (Rectangle)resultSet.getObject(1);
            if (rectangle2.x != 10 || rectangle2.y != 11 || rectangle2.width != 12 || rectangle2.height != 13) {
                throw new Exception("Object data error: Rectangle");
            }
            resultSet.next();
            int[] nArray2 = (int[])resultSet.getObject(1);
            if (nArray2[0] != 1 || nArray2[1] != 2 || nArray2[2] != 3 || nArray2.length != 3) {
                throw new Exception("Object data error: int[]");
            }
            string6 = "drop table obj";
            statement.execute(string6);
            string6 = "CREATE CACHED TABLE Addr(ID INT PRIMARY KEY,First CHAR,Name CHAR,ZIP INT)";
            statement.execute(string6);
            string6 = "CREATE INDEX iName ON Addr(Name)";
            statement.execute(string6);
            string6 = "SET WRITE_DELAY TRUE";
            statement.execute(string6);
            long l = System.currentTimeMillis();
            int n4 = 0;
            while (n4 < n) {
                string6 = "INSERT INTO Addr VALUES(" + n4 + ",'Marcel" + n4 + "'," + "'Renggli" + (n - n4 - n4 % 31) + "'," + (3000 + n4 % 100) + ")";
                if (statement.executeUpdate(string6) != 1) {
                    throw new Exception("Insert failed");
                }
                if (n4 % 100 == 0) {
                    SelfTest.printStatus("insert   ", n4, n, l);
                }
                ++n4;
            }
            SelfTest.printStatus("insert   ", n, n, l);
            SelfTest.print("");
            string6 = "SELECT COUNT(*) FROM Addr";
            resultSet = statement.executeQuery(string6);
            resultSet.next();
            int n5 = resultSet.getInt(1);
            if (n5 != n) {
                throw new Exception("Count should be " + n + " but is " + n5);
            }
            if (bl) {
                connection.close();
                connection = DriverManager.getConnection(string2, string3, string4);
                statement = connection.createStatement();
            }
            l = System.currentTimeMillis();
            int n6 = 0;
            while (n6 < n) {
                string6 = "UPDATE Addr SET Name='Robert" + (n6 + n6 % 31) + "' WHERE ID=" + n6;
                if (statement.executeUpdate(string6) != 1) {
                    throw new Exception("Update failed");
                }
                if (n6 % 100 == 0) {
                    SelfTest.printStatus("updated  ", n6, n, l);
                }
                ++n6;
            }
            SelfTest.printStatus("update   ", n, n, l);
            SelfTest.print("");
            if (bl) {
                string6 = "SHUTDOWN IMMEDIATELY";
                statement.execute(string6);
                connection.close();
                connection = DriverManager.getConnection(string2, string3, string4);
                statement = connection.createStatement();
            }
            l = System.currentTimeMillis();
            int n7 = 0;
            while (n7 < n) {
                string6 = "DELETE FROM Addr WHERE ID=" + (n - 1 - n7);
                if (statement.executeUpdate(string6) != 1) {
                    throw new Exception("Delete failed");
                }
                if (n7 % 100 == 0) {
                    SelfTest.printStatus("deleting ", n7, n, l);
                }
                ++n7;
            }
            SelfTest.printStatus("delete   ", n, n, l);
            SelfTest.print("");
            statement.execute("DROP TABLE Addr");
        }
        catch (Exception exception) {
            SelfTest.print("");
            SelfTest.print("SelfTest error: " + exception);
            SelfTest.print("with SQL command: " + string6);
            exception.printStackTrace();
        }
        connection.close();
        SelfTest.print("Test finished");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void test(Statement statement, String string) throws Exception {
        int n;
        String string2 = "";
        char c = ' ';
        if (string.startsWith("/*")) {
            c = string.charAt(2);
            n = string.indexOf("*/");
            string2 = string.substring(3, n);
        }
        try {
            statement.execute(string);
            n = statement.getUpdateCount();
            int n2 = 0;
            switch (c) {
                case 'u': {
                    if (n == Integer.parseInt(string2)) return;
                    throw new Exception("Expected update count=" + string2 + " but update count was " + n + " / " + string);
                }
                case 'r': {
                    if (n != -1) {
                        throw new Exception("Expected ResultSet but update count was " + n + " / " + string);
                    }
                    ResultSet resultSet = statement.getResultSet();
                    resultSet.next();
                    String string3 = resultSet.getString(1);
                    if (resultSet.wasNull() || string3 == null) {
                        if (string2.equals("")) return;
                        throw new Exception("Expected " + string2 + " but got null / " + string);
                    }
                    if (string3.equals(string2)) return;
                    throw new Exception("Expected >" + string2 + "<" + " but got >" + string3 + "< / " + string);
                }
                case 'c': {
                    if (n != -1) {
                        throw new Exception("Expected ResultSet but update count was " + n + " / " + string);
                    }
                    ResultSet resultSet = statement.getResultSet();
                    while (resultSet.next()) {
                        ++n2;
                    }
                    if (n2 == Integer.parseInt(string2)) return;
                    throw new Exception("Expected " + string2 + " rows " + " but got " + n2 + " rows / " + string);
                }
                case 'e': {
                    throw new Exception("Expected error but got no error / " + string);
                }
                default: {
                    return;
                }
            }
        }
        catch (SQLException sQLException) {
            if (c == 101) return;
            throw new Exception("Expected " + c + "/" + string2 + " but got error " + sQLException.getMessage() + " / " + string);
        }
    }
}

