/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.Index;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class Constraint {
    static final int FOREIGN_KEY = 0;
    static final int MAIN = 1;
    static final int UNIQUE = 2;
    private int iType;
    private int iLen;
    private Table tMain;
    private int[] iColMain;
    private Index iMain;
    private Object[] oMain;
    private Table tRef;
    private int[] iColRef;
    private Index iRef;
    private Object[] oRef;

    Constraint(int n, Table table, Table table2, int[] nArray, int[] nArray2) throws SQLException {
        this.iType = n;
        this.tMain = table;
        this.tRef = table2;
        this.iColMain = nArray;
        this.iColRef = nArray2;
        this.iLen = nArray.length;
        this.oMain = this.tMain.getNewRow();
        this.oRef = this.tRef.getNewRow();
        this.iMain = this.tMain.getIndexForColumns(nArray);
        this.iRef = this.tRef.getIndexForColumns(nArray2);
    }

    Constraint(int n, Table table, int[] nArray) {
        this.iType = n;
        this.tMain = table;
        this.iColMain = nArray;
        this.iLen = nArray.length;
    }

    void checkDelete(Object[] objectArray) throws SQLException {
        if (this.iType == 0 || this.iType == 2) {
            return;
        }
        int n = 0;
        while (n < this.iLen) {
            Object object = objectArray[this.iColMain[n]];
            if (object == null) {
                return;
            }
            this.oRef[this.iColRef[n]] = object;
            ++n;
        }
        Trace.check(this.iRef.find(this.oRef) == null, 7);
    }

    void checkInsert(Object[] objectArray) throws SQLException {
        if (this.iType == 1 || this.iType == 2) {
            return;
        }
        int n = 0;
        while (n < this.iLen) {
            Object object = objectArray[this.iColRef[n]];
            if (object == null) {
                return;
            }
            this.oMain[this.iColMain[n]] = object;
            ++n;
        }
        Trace.check(this.iMain.find(this.oMain) != null, 7);
    }

    void checkUpdate(int[] nArray, Result result, Result result2) throws SQLException {
        block7: {
            block6: {
                if (this.iType == 2) {
                    return;
                }
                if (this.iType != 1) break block6;
                if (!this.isAffected(nArray, this.iColMain, this.iLen)) {
                    return;
                }
                Record record = result.rRoot;
                while (record != null) {
                    if (this.iMain.find(record.data) == null) {
                        this.checkDelete(record.data);
                    }
                    record = record.next;
                }
                break block7;
            }
            if (this.iType != 0) break block7;
            if (!this.isAffected(nArray, this.iColMain, this.iLen)) {
                return;
            }
            Record record = result2.rRoot;
            while (record != null) {
                this.checkInsert(record.data);
                record = record.next;
            }
        }
    }

    Table getMain() {
        return this.tMain;
    }

    int[] getMainColumns() {
        return this.iColMain;
    }

    Table getRef() {
        return this.tRef;
    }

    int[] getRefColumns() {
        return this.iColRef;
    }

    int getType() {
        return this.iType;
    }

    private boolean isAffected(int[] nArray, int[] nArray2, int n) {
        if (this.iType == 2) {
            return false;
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            int n4 = 0;
            while (n4 < n) {
                if (n3 == nArray2[n4]) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    void replaceTable(Table table, Table table2) throws SQLException {
        if (table == this.tMain) {
            this.tMain = table2;
        } else if (table == this.tRef) {
            this.tRef = table2;
        } else {
            Trace.assert(false, "could not replace");
        }
    }
}

