/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.pool;

import org.apache.avalon.Poolable;
import org.apache.excalibur.pool.AbstractPool;
import org.apache.excalibur.pool.ObjectFactory;
import org.apache.excalibur.pool.PoolController;
import org.apache.excalibur.pool.Resizable;

public class SoftResourceLimitingPool
extends AbstractPool
implements Resizable {
    protected final PoolController m_controller;

    public void init() {
        this.grow(this.m_min);
    }

    public synchronized void grow(int n) {
        int n2 = 0;
        while (n2 < n) {
            block3: {
                try {
                    this.m_ready.push(this.m_factory.newInstance());
                    ++this.m_currentCount;
                }
                catch (Exception exception) {
                    if (this.getLogger() == null) break block3;
                    this.getLogger().debug(this.m_factory.getCreatedClass().getName() + ": could not be instantiated.", (Throwable)exception);
                }
            }
            this.notify();
            ++n2;
        }
    }

    public synchronized void shrink(int n) {
        int n2 = 0;
        while (n2 < n) {
            block4: {
                if (this.m_ready.size() > this.m_min) {
                    try {
                        this.m_factory.decommission(this.m_ready.pop());
                        --this.m_currentCount;
                    }
                    catch (Exception exception) {
                        if (this.getLogger() == null) break block4;
                        this.getLogger().debug(this.m_factory.getCreatedClass().getName() + ": improperly decommissioned.", (Throwable)exception);
                    }
                }
            }
            ++n2;
        }
    }

    public Poolable get() throws Exception {
        if (this.m_ready.size() == 0) {
            this.grow(this.m_controller == null ? this.m_max - this.m_min : this.m_controller.grow());
        }
        return super.get();
    }

    public void put(Poolable poolable) {
        if (this.m_ready.size() > this.m_max) {
            this.shrink(this.m_controller == null ? this.m_ready.size() - (this.m_max + 1) : this.m_controller.shrink());
        }
        super.put(poolable);
    }

    public SoftResourceLimitingPool(ObjectFactory objectFactory, int n) throws Exception {
        super(objectFactory, n, n * 2);
        this.m_controller = null;
    }

    public SoftResourceLimitingPool(ObjectFactory objectFactory, int n, int n2) throws Exception {
        super(objectFactory, n, n2);
        this.m_controller = null;
    }

    public SoftResourceLimitingPool(ObjectFactory objectFactory, PoolController poolController, int n, int n2) throws Exception {
        super(objectFactory, n, n2);
        this.m_controller = poolController;
    }
}

