/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.pool;

import org.apache.avalon.Initializable;
import org.apache.avalon.Poolable;
import org.apache.avalon.ThreadSafe;
import org.apache.excalibur.pool.DefaultObjectFactory;
import org.apache.excalibur.pool.ObjectFactory;
import org.apache.excalibur.pool.PoolController;
import org.apache.excalibur.pool.SoftResourceLimitingPool;

public class HardResourceLimitingPool
extends SoftResourceLimitingPool
implements ThreadSafe,
Initializable {
    public static final int DEFAULT_POOL_SIZE = 8;

    public void init() {
        try {
            super.init();
        }
        catch (Exception exception) {
            this.getLogger().debug("Caught init exception", (Throwable)exception);
        }
    }

    public final synchronized Poolable get() throws Exception {
        while (this.m_ready.size() == 0 || this.m_currentCount > this.m_max) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return super.get();
    }

    public final synchronized void put(Poolable poolable) {
        super.put(poolable);
        this.notify();
    }

    public HardResourceLimitingPool(ObjectFactory objectFactory, PoolController poolController) throws Exception {
        super(objectFactory, poolController, 8, 8);
    }

    public HardResourceLimitingPool(ObjectFactory objectFactory) throws Exception {
        this(objectFactory, null);
    }

    public HardResourceLimitingPool(ObjectFactory objectFactory, int n, int n2) throws Exception {
        super(objectFactory, null, n, n2);
    }

    public HardResourceLimitingPool(ObjectFactory objectFactory, int n) throws Exception {
        this(objectFactory, n, n);
    }

    public HardResourceLimitingPool(Class clazz, int n, int n2) throws NoSuchMethodException, Exception {
        this(new DefaultObjectFactory(clazz), n, n2);
    }

    public HardResourceLimitingPool(Class clazz, int n) throws NoSuchMethodException, Exception {
        this(clazz, n, n);
    }
}

