/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.apache.batik.svggen.SVGGraphicObjectConverter;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGRectangle
extends SVGGraphicObjectConverter {
    public SVGRectangle(Document document) {
        super(document);
    }

    public Element toSVG(Rectangle2D rectangle2D) {
        return this.toSVG((RectangularShape)rectangle2D);
    }

    public Element toSVG(RoundRectangle2D roundRectangle2D) {
        Element element = this.toSVG((RectangularShape)roundRectangle2D);
        element.setAttributeNS(null, "rx", SVGGraphicObjectConverter.doubleString(roundRectangle2D.getArcWidth() / 2.0));
        element.setAttributeNS(null, "ry", SVGGraphicObjectConverter.doubleString(roundRectangle2D.getArcHeight() / 2.0));
        return element;
    }

    private Element toSVG(RectangularShape rectangularShape) {
        Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "rect");
        element.setAttributeNS(null, "x", SVGGraphicObjectConverter.doubleString(rectangularShape.getX()));
        element.setAttributeNS(null, "y", SVGGraphicObjectConverter.doubleString(rectangularShape.getY()));
        element.setAttributeNS(null, "width", SVGGraphicObjectConverter.doubleString(rectangularShape.getWidth()));
        element.setAttributeNS(null, "height", SVGGraphicObjectConverter.doubleString(rectangularShape.getHeight()));
        return element;
    }

    public static void main(String[] stringArray) throws Exception {
        Document document = TestUtil.getDocumentPrototype();
        SVGRectangle sVGRectangle = new SVGRectangle(document);
        Element[] elementArray = new Element[]{sVGRectangle.toSVG(new Rectangle(10, 20, 30, 40)), sVGRectangle.toSVG(new Rectangle2D.Double(100.0, 200.0, 300.0, 400.0)), sVGRectangle.toSVG(new Rectangle2D.Float(1000.0f, 2000.0f, 3000.0f, 4000.0f)), sVGRectangle.toSVG(new RoundRectangle2D.Double(15.0, 16.0, 17.0, 18.0, 30.0, 20.0)), sVGRectangle.toSVG(new RoundRectangle2D.Float(35.0f, 45.0f, 55.0f, 65.0f, 25.0f, 45.0f))};
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < elementArray.length) {
            element.appendChild(elementArray[n]);
            ++n;
        }
        TestUtil.trace(element, System.out);
    }
}

