/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Paint;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.GraphicContext;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGCustomPaint
extends AbstractSVGConverter {
    public static final String ERROR_EXTENSION_HANDLER_NULL = "extensionHandler should not be null";
    private ExtensionHandler extensionHandler;

    public SVGCustomPaint(Document document, ExtensionHandler extensionHandler) {
        super(document);
        if (extensionHandler == null) {
            throw new IllegalArgumentException(ERROR_EXTENSION_HANDLER_NULL);
        }
        this.extensionHandler = extensionHandler;
    }

    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return this.toSVG(graphicContext.getPaint());
    }

    public SVGPaintDescriptor toSVG(Paint paint) {
        SVGPaintDescriptor sVGPaintDescriptor = (SVGPaintDescriptor)this.descMap.get(paint);
        if (sVGPaintDescriptor == null && (sVGPaintDescriptor = this.extensionHandler.handlePaint(paint, this.domFactory)) != null) {
            Element element = sVGPaintDescriptor.getDef();
            if (element != null) {
                this.defSet.add(element);
            }
            this.descMap.put(paint, sVGPaintDescriptor);
        }
        return sVGPaintDescriptor;
    }
}

