/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.rhino.EventTargetWrapHandler;
import org.apache.batik.script.rhino.EventTargetWrapper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapHandler;
import org.mozilla.javascript.WrappedException;
import org.w3c.dom.events.EventTarget;

public class RhinoInterpreter
implements Interpreter {
    private Scriptable scope = null;
    private Context context = Context.enter();
    private static String[] TO_BE_IMPORTED = new String[]{"java.lang", "org.w3c.dom", "org.w3c.dom.css", "org.w3c.dom.events", "org.w3c.dom.smil", "org.w3c.dom.stylesheets", "org.w3c.dom.svg", "org.w3c.dom.views"};

    public RhinoInterpreter() {
        try {
            ImporterTopLevel importerTopLevel = new ImporterTopLevel();
            this.scope = this.context.initStandardObjects((ScriptableObject)importerTopLevel);
            Object[] objectArray = new NativeJavaPackage[TO_BE_IMPORTED.length];
            int n = 0;
            while (n < TO_BE_IMPORTED.length) {
                objectArray[n] = new NativeJavaPackage(TO_BE_IMPORTED[n]);
                ++n;
            }
            ImporterTopLevel.importPackage((Context)this.context, (Scriptable)this.scope, (Object[])objectArray, null);
            this.context.setWrapHandler((WrapHandler)new EventTargetWrapHandler(this));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    public Object evaluate(Reader reader) throws InterpreterException, IOException {
        Object object = null;
        Context context = Context.enter((Context)this.context);
        try {
            try {
                object = context.evaluateReader(this.scope, reader, "<SVG>", 1, null);
            }
            catch (JavaScriptException javaScriptException) {
                if (javaScriptException.getValue() instanceof Exception) {
                    Exception exception = (Exception)javaScriptException.getValue();
                    throw new InterpreterException(exception, exception.getMessage(), -1, -1);
                }
                throw new InterpreterException((Exception)((Object)javaScriptException), javaScriptException.getMessage(), -1, -1);
            }
            catch (WrappedException wrappedException) {
                throw new InterpreterException((Exception)wrappedException.getWrappedException(), wrappedException.getWrappedException().getMessage(), -1, -1);
            }
            catch (RuntimeException runtimeException) {
                throw new InterpreterException(runtimeException, runtimeException.getMessage(), -1, -1);
            }
            Object var8_4 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return object;
    }

    public void dispose() {
    }

    public void bindObject(String string, Object object) {
        Scriptable scriptable = Context.toObject((Object)object, (Scriptable)this.scope);
        this.scope.put(string, this.scope, (Object)scriptable);
    }

    void callHandler(Function function, Object object) throws JavaScriptException {
        Context context = Context.enter((Context)this.context);
        try {
            object = Context.toObject((Object)object, (Scriptable)this.scope);
            Object[] objectArray = new Object[]{object};
            function.call(context, this.scope, this.scope, objectArray);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    Scriptable buildEventTargetWrapper(EventTarget eventTarget) {
        return new EventTargetWrapper(this.scope, eventTarget, this);
    }

    public void setOut(Writer writer) {
    }

    public Locale getLocale() {
        return null;
    }

    public void setLocale(Locale locale) {
    }

    public String formatMessage(String string, Object[] objectArray) {
        return null;
    }
}

