/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.filter;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractTiledRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;

public class GraphicsNodeRed8Bit
extends AbstractTiledRed
implements TileGenerator {
    private GraphicsNode node;
    private AffineTransform node2dev;
    private RenderingHints hints;
    private GraphicsNodeRenderContext gnrc;
    private boolean usePrimitivePaint;

    public GraphicsNodeRed8Bit(GraphicsNode graphicsNode, AffineTransform affineTransform, GraphicsNodeRenderContext graphicsNodeRenderContext, boolean bl, RenderingHints renderingHints) {
        int n;
        int n2;
        Cloneable cloneable;
        Rectangle2D rectangle2D;
        this.node = graphicsNode;
        this.node2dev = affineTransform;
        this.hints = renderingHints;
        this.gnrc = graphicsNodeRenderContext;
        this.usePrimitivePaint = bl;
        AffineTransform affineTransform2 = affineTransform;
        if (bl) {
            rectangle2D = graphicsNode.getPrimitiveBounds(graphicsNodeRenderContext);
        } else {
            rectangle2D = graphicsNode.getPrimitiveBounds(graphicsNodeRenderContext);
            cloneable = graphicsNode.getTransform();
            if (cloneable != null) {
                affineTransform2 = (AffineTransform)affineTransform2.clone();
                affineTransform2.concatenate((AffineTransform)cloneable);
            }
        }
        cloneable = affineTransform2.createTransformedShape(rectangle2D).getBounds();
        ColorModel colorModel = GraphicsUtil.sRGB_Unpre;
        int n3 = ((Rectangle)cloneable).x & 0xFFFFFF00;
        int n4 = ((Rectangle)cloneable).x + ((Rectangle)cloneable).width - n3;
        if (n4 > 256) {
            n4 = 256;
        }
        if ((n2 = ((Rectangle)cloneable).y + ((Rectangle)cloneable).height - (n = ((Rectangle)cloneable).y & 0xFFFFFF00)) > 256) {
            n2 = 256;
        }
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(n4, n2);
        this.init((CachableRed)null, (Rectangle)cloneable, colorModel, sampleModel, n3, n, null);
    }

    public void genRect(WritableRaster writableRaster) {
        BufferedImage bufferedImage = new BufferedImage(this.cm, writableRaster.createWritableTranslatedChild(0, 0), this.cm.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = GraphicsUtil.createGraphics(bufferedImage, this.hints);
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, writableRaster.getWidth(), writableRaster.getHeight());
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.translate(-writableRaster.getMinX(), -writableRaster.getMinY());
        graphics2D.transform(this.node2dev);
        try {
            block5: {
                try {
                    if (this.usePrimitivePaint) {
                        this.node.primitivePaint(graphics2D, this.gnrc);
                        break block5;
                    }
                    this.node.paint(graphics2D, this.gnrc);
                }
                catch (InterruptedException interruptedException) {
                    Object var6_5 = null;
                    graphics2D.dispose();
                }
            }
            Object var6_4 = null;
            graphics2D.dispose();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            graphics2D.dispose();
            throw throwable;
        }
    }
}

