/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.List;
import java.util.Map;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileCache;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileStore;

public abstract class AbstractTiledRed
extends AbstractRed
implements TileGenerator {
    private TileStore tiles;

    protected AbstractTiledRed() {
    }

    protected AbstractTiledRed(Rectangle rectangle, Map map) {
        super(rectangle, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Map map) {
        super(cachableRed, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, Map map) {
        super(cachableRed, rectangle, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, Map map) {
        super(cachableRed, rectangle, colorModel, sampleModel, map);
    }

    protected AbstractTiledRed(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        super(cachableRed, rectangle, colorModel, sampleModel, n, n2, map);
    }

    protected void init(CachableRed cachableRed, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        super.init(cachableRed, rectangle, colorModel, sampleModel, n, n2, map);
        this.tiles = this.createTileStore();
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, Map map) {
        super(list, rectangle, map);
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, Map map) {
        super(list, rectangle, colorModel, sampleModel, map);
    }

    protected AbstractTiledRed(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        super(list, rectangle, colorModel, sampleModel, n, n2, map);
    }

    protected void init(List list, Rectangle rectangle, ColorModel colorModel, SampleModel sampleModel, int n, int n2, Map map) {
        super.init(list, rectangle, colorModel, sampleModel, n, n2, map);
        this.tiles = this.createTileStore();
    }

    protected TileStore createTileStore() {
        return TileCache.getTileGrid(this, this);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.copyToRasterByBlocks(writableRaster);
        return writableRaster;
    }

    public Raster getTile(int n, int n2) {
        return this.tiles.getTile(n, n2);
    }

    public Raster genTile(int n, int n2) {
        WritableRaster writableRaster = this.makeTile(n, n2);
        this.genRect(writableRaster);
        return writableRaster;
    }

    public abstract void genRect(WritableRaster var1);

    public void setTile(int n, int n2, Raster raster) {
        this.tiles.setTile(n, n2, raster);
    }

    public void copyToRasterByBlocks(WritableRaster writableRaster) {
        Object object;
        Object object2;
        int n;
        int n2;
        boolean[] blArray;
        int n3;
        boolean bl = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        int n4 = this.getXTile(writableRaster.getMinX());
        int n5 = this.getYTile(writableRaster.getMinY());
        int n6 = this.getXTile(writableRaster.getMinX() + writableRaster.getWidth() - 1);
        int n7 = this.getYTile(writableRaster.getMinY() + writableRaster.getHeight() - 1);
        if (n4 < this.minTileX) {
            n4 = this.minTileX;
        }
        if (n5 < this.minTileY) {
            n5 = this.minTileY;
        }
        if (n6 >= this.minTileX + this.numXTiles) {
            n6 = this.minTileX + this.numXTiles - 1;
        }
        if (n7 >= this.minTileY + this.numYTiles) {
            n7 = this.minTileY + this.numYTiles - 1;
        }
        int n8 = n4;
        int n9 = n6;
        int n10 = n5;
        int n11 = n7;
        int n12 = n4 * this.tileWidth + this.tileGridXOff;
        if (n12 < writableRaster.getMinX()) {
            ++n8;
        }
        if ((n3 = n5 * this.tileHeight + this.tileGridYOff) < writableRaster.getMinY()) {
            ++n10;
        }
        if ((n12 = (n6 + 1) * this.tileWidth + this.tileGridXOff - 1) >= writableRaster.getMinX() + writableRaster.getWidth()) {
            --n9;
        }
        if ((n3 = (n7 + 1) * this.tileHeight + this.tileGridYOff - 1) >= writableRaster.getMinY() + writableRaster.getHeight()) {
            --n11;
        }
        int n13 = n9 - n8 + 1;
        int n14 = n11 - n10 + 1;
        if (n13 > 0 && n14 > 0) {
            Object object3;
            blArray = new boolean[n13 * n14];
            n2 = 0;
            while (n2 < n14) {
                n = 0;
                while (n < n13) {
                    object3 = this.tiles.getTileNoCompute(n + n8, n2 + n10);
                    if (object3 == null) {
                        blArray[n + n2 * n13] = false;
                    } else {
                        blArray[n + n2 * n13] = true;
                        if (bl) {
                            GraphicsUtil.copyData_INT_PACK((Raster)object3, writableRaster);
                        } else {
                            GraphicsUtil.copyData_FALLBACK((Raster)object3, writableRaster);
                        }
                    }
                    ++n;
                }
                ++n2;
            }
            object3 = new TileBlock(n8, n10, n13, n14, blArray);
            object2 = ((TileBlock)object3).getBestSplit();
            int n15 = 0;
            while (n15 < ((TileBlock[])object2).length) {
                object = object2[n15];
                int n16 = ((TileBlock)object).getXLoc() * this.tileWidth + this.tileGridXOff;
                int n17 = ((TileBlock)object).getYLoc() * this.tileHeight + this.tileGridYOff;
                WritableRaster writableRaster2 = writableRaster.createWritableChild(n16, n17, ((TileBlock)object).getWidth() * this.tileWidth, ((TileBlock)object).getHeight() * this.tileHeight, n16, n17, null);
                this.genRect(writableRaster2);
                ++n15;
            }
        }
        blArray = new boolean[2 * (n6 - n4 + 1) + 2 * (n7 - n5 + 1)];
        n2 = 0;
        n = n5;
        while (n <= n7) {
            int n18 = n4;
            while (n18 <= n6) {
                if (n < n10 || n > n11 || n18 < n8 || n18 > n9) {
                    object2 = this.tiles.getTileNoCompute(n18, n);
                    if (object2 == null) {
                        blArray[n2++] = false;
                    } else {
                        blArray[n2++] = true;
                        if (bl) {
                            GraphicsUtil.copyData_INT_PACK((Raster)object2, writableRaster);
                        } else {
                            GraphicsUtil.copyData_FALLBACK((Raster)object2, writableRaster);
                        }
                    }
                }
                ++n18;
            }
            ++n;
        }
        n2 = 0;
        int n19 = n5;
        while (n19 <= n7) {
            int n20 = n4;
            while (n20 <= n6) {
                if (!(n19 >= n10 && n19 <= n11 && n20 >= n8 && n20 <= n9 || blArray[n2++])) {
                    Raster raster = this.getTile(n20, n19);
                    if (bl) {
                        GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
                    }
                }
                ++n20;
            }
            ++n19;
        }
        int n21 = 0;
        while (n21 < n14) {
            n3 = n21 + n10;
            int n22 = 0;
            while (n22 < n13) {
                n12 = n22 + n8;
                object = this.tiles.getTileNoCompute(n12, n3);
                if (object == null) {
                    WritableRaster writableRaster3 = this.makeTile(n12, n3);
                    if (bl) {
                        GraphicsUtil.copyData_INT_PACK(writableRaster, writableRaster3);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(writableRaster, writableRaster3);
                    }
                    this.tiles.setTile(n12, n3, writableRaster3);
                }
                ++n22;
            }
            ++n21;
        }
    }

    public void copyToRaster(WritableRaster writableRaster) {
        int n = this.getXTile(writableRaster.getMinX());
        int n2 = this.getYTile(writableRaster.getMinY());
        int n3 = this.getXTile(writableRaster.getMinX() + writableRaster.getWidth() - 1);
        int n4 = this.getYTile(writableRaster.getMinY() + writableRaster.getHeight() - 1);
        if (n < this.minTileX) {
            n = this.minTileX;
        }
        if (n2 < this.minTileY) {
            n2 = this.minTileY;
        }
        if (n3 >= this.minTileX + this.numXTiles) {
            n3 = this.minTileX + this.numXTiles - 1;
        }
        if (n4 >= this.minTileY + this.numYTiles) {
            n4 = this.minTileY + this.numYTiles - 1;
        }
        boolean bl = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        int n5 = n3 - n + 1;
        boolean[] blArray = new boolean[n5 * (n4 - n2 + 1)];
        int n6 = n2;
        while (n6 <= n4) {
            int n7 = n;
            while (n7 <= n3) {
                Raster raster = this.tiles.getTileNoCompute(n7, n6);
                if (raster != null) {
                    blArray[n7 - n + (n6 - n2) * n5] = true;
                    if (bl) {
                        GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
                    }
                }
                ++n7;
            }
            ++n6;
        }
        int n8 = n2;
        while (n8 <= n4) {
            int n9 = n;
            while (n9 <= n3) {
                if (!blArray[n9 - n + (n8 - n2) * n5]) {
                    Raster raster = this.getTile(n9, n8);
                    if (bl) {
                        GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                    } else {
                        GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
                    }
                }
                ++n9;
            }
            ++n8;
        }
    }

    public class TileBlock {
        int xloc;
        int yloc;
        int w;
        int h;
        int benefit;
        boolean[] occupied;

        TileBlock(int n, int n2, int n3, int n4, boolean[] blArray) {
            this.xloc = n;
            this.yloc = n2;
            this.w = n3;
            this.h = n4;
            this.occupied = blArray;
            if (blArray.length != n3 * n4) {
                throw new IllegalArgumentException("Occupied array must be equal to widthxheight");
            }
            int n5 = 0;
            while (n5 < blArray.length) {
                if (!blArray[n5]) {
                    ++this.benefit;
                }
                ++n5;
            }
        }

        int getXLoc() {
            return this.xloc;
        }

        int getYLoc() {
            return this.yloc;
        }

        int getWidth() {
            return this.w;
        }

        int getHeight() {
            return this.h;
        }

        int getBenefit() {
            return this.benefit;
        }

        int getWork() {
            return this.w * this.h + 1;
        }

        int getWork(TileBlock[] tileBlockArray) {
            int n = 0;
            int n2 = 0;
            while (n2 < tileBlockArray.length) {
                n += tileBlockArray[n2].getWork();
                ++n2;
            }
            return n;
        }

        TileBlock[] getBestSplit() {
            TileBlock[] tileBlockArray = new TileBlock[]{this};
            if (this.benefit == this.w * this.h) {
                return tileBlockArray;
            }
            int n = this.getWork();
            int n2 = 0;
            while (n2 < this.h) {
                boolean bl = false;
                int n3 = 0;
                while (n3 < this.w) {
                    if (!this.occupied[n3 + n2 * this.w]) {
                        bl = false;
                    } else if (!bl) {
                        TileBlock[] tileBlockArray2 = this.getBestSplitAt(n3 + this.xloc, n2 + this.yloc);
                        int n4 = this.getWork(tileBlockArray2);
                        if (n4 < n) {
                            tileBlockArray = tileBlockArray2;
                            n = n4;
                        }
                        bl = true;
                    }
                    ++n3;
                }
                ++n2;
            }
            return tileBlockArray;
        }

        TileBlock[] getBestSplitAt(int n, int n2) {
            TileBlock[] tileBlockArray;
            TileBlock[] tileBlockArray2 = this.splitAtH(n, n2);
            TileBlock[][] tileBlockArrayArray = new TileBlock[tileBlockArray2.length][];
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < tileBlockArray2.length) {
                tileBlockArrayArray[n5] = tileBlockArray2[n5].getBestSplit();
                n3 += tileBlockArrayArray[n5].length;
                n4 += this.getWork(tileBlockArrayArray[n5]);
                ++n5;
            }
            if (n4 > this.benefit + 2) {
                tileBlockArray = this.splitAtV(n, n2);
                TileBlock[][] tileBlockArrayArray2 = new TileBlock[tileBlockArray.length][];
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                while (n8 < tileBlockArray.length) {
                    tileBlockArrayArray2[n8] = tileBlockArray[n8].getBestSplit();
                    n6 += tileBlockArrayArray2[n8].length;
                    n7 += this.getWork(tileBlockArrayArray2[n8]);
                    ++n8;
                }
                if (n7 < n4) {
                    tileBlockArray2 = tileBlockArray;
                    tileBlockArrayArray = tileBlockArrayArray2;
                    n3 = n6;
                }
            }
            tileBlockArray = new TileBlock[n3];
            n3 = 0;
            int n9 = 0;
            while (n9 < tileBlockArray2.length) {
                System.arraycopy(tileBlockArrayArray[n9], 0, tileBlockArray, n3, tileBlockArrayArray[n9].length);
                n3 += tileBlockArrayArray[n9].length;
                ++n9;
            }
            return tileBlockArray;
        }

        TileBlock[] splitAtH(int n, int n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            n2 -= this.yloc;
            if ((n -= this.xloc) < 0 || n >= this.w) {
                throw new IllegalArgumentException("X out of range: " + n + this.xloc);
            }
            if (n2 < 0 || n2 >= this.h) {
                throw new IllegalArgumentException("Y out of range: " + n2 + this.yloc);
            }
            int n7 = 0;
            TileBlock tileBlock = null;
            if (n2 != 0) {
                boolean bl = false;
                n6 = 0;
                n5 = 0;
                n4 = 0;
                while (n4 < n2) {
                    n3 = 1;
                    int n8 = 0;
                    while (n8 < this.w) {
                        n3 = n3 != 0 && this.occupied[n8 + n4 * this.w] ? 1 : 0;
                        ++n8;
                    }
                    if (n3 == 0) {
                        n5 = n4;
                    } else if (n6 == n4) {
                        ++n6;
                    }
                    ++n4;
                }
                if (n5 >= n6) {
                    n3 = n5 - n6 + 1;
                    boolean[] blArray = new boolean[this.w * n3];
                    System.arraycopy(this.occupied, n6 * this.w, blArray, 0, this.w * n3);
                    tileBlock = new TileBlock(this.xloc, n6 + this.yloc, this.w, n3, blArray);
                    ++n7;
                }
            }
            TileBlock tileBlock2 = null;
            if (n2 != this.h - 1) {
                n6 = 0;
                n5 = n2 + 1;
                n4 = n2 + 1;
                n3 = n2 + 1;
                while (n3 < this.h) {
                    boolean bl = true;
                    int n9 = 0;
                    while (n9 < this.w) {
                        bl = bl && this.occupied[n9 + n3 * this.w];
                        ++n9;
                    }
                    if (!bl) {
                        n4 = n3;
                    } else if (n5 == n3) {
                        ++n5;
                    }
                    ++n3;
                }
                if (n4 >= n5) {
                    int n10 = n4 - n5 + 1;
                    boolean[] blArray = new boolean[this.w * n10];
                    System.arraycopy(this.occupied, n5 * this.w, blArray, 0, this.w * n10);
                    tileBlock2 = new TileBlock(this.xloc, n5 + this.yloc, this.w, n10, blArray);
                    ++n7;
                }
            }
            TileBlock tileBlock3 = null;
            if (n != 0) {
                n5 = n2 * this.w;
                n4 = 0;
                n3 = 0;
                int n11 = 0;
                while (n11 < n) {
                    if (!this.occupied[n11 + n5]) {
                        n3 = n11;
                    } else if (n4 == n11) {
                        ++n4;
                    }
                    ++n11;
                }
                if (n3 >= n4) {
                    int n12 = n3 - n4 + 1;
                    boolean[] blArray = new boolean[n12];
                    System.arraycopy(this.occupied, n5 + n4, blArray, 0, n12);
                    tileBlock3 = new TileBlock(n4, this.yloc + n2, n12, 1, blArray);
                    ++n7;
                }
            }
            TileBlock tileBlock4 = null;
            if (n != this.w - 1) {
                n4 = n2 * this.w;
                n3 = n + 1;
                int n13 = n + 1;
                int n14 = n + 1;
                while (n14 < this.w) {
                    if (!this.occupied[n14 + n4]) {
                        n13 = n14;
                    } else if (n3 == n14) {
                        ++n3;
                    }
                    ++n14;
                }
                if (n13 >= n3) {
                    int n15 = n13 - n3 + 1;
                    boolean[] blArray = new boolean[n15];
                    System.arraycopy(this.occupied, n4 + n3, blArray, 0, n15);
                    tileBlock4 = new TileBlock(n3, this.yloc + n2, n15, 1, blArray);
                    ++n7;
                }
            }
            TileBlock[] tileBlockArray = new TileBlock[n7];
            n3 = 0;
            if (tileBlock != null) {
                tileBlockArray[n3++] = tileBlock;
            }
            if (tileBlock2 != null) {
                tileBlockArray[n3++] = tileBlock2;
            }
            if (tileBlock3 != null) {
                tileBlockArray[n3++] = tileBlock3;
            }
            if (tileBlock4 != null) {
                tileBlockArray[n3++] = tileBlock4;
            }
            return tileBlockArray;
        }

        TileBlock[] splitAtV(int n, int n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            n2 -= this.yloc;
            if ((n -= this.xloc) < 0 || n >= this.w) {
                throw new IllegalArgumentException("X out of range: " + n + this.xloc);
            }
            if (n2 < 0 || n2 >= this.h) {
                throw new IllegalArgumentException("Y out of range: " + n2 + this.yloc);
            }
            int n11 = 0;
            TileBlock tileBlock = null;
            if (n > 0) {
                boolean bl = false;
                n10 = 0;
                n9 = 0;
                n8 = 0;
                while (n8 < n) {
                    n7 = 1;
                    int n12 = 0;
                    while (n12 < this.h) {
                        n7 = n7 != 0 && this.occupied[n8 + n12 * this.w] ? 1 : 0;
                        ++n12;
                    }
                    if (n7 == 0) {
                        n9 = n8;
                    } else if (n10 == n8) {
                        ++n10;
                    }
                    ++n8;
                }
                if (n9 >= n10) {
                    n7 = n9 - n10 + 1;
                    boolean[] blArray = new boolean[this.h * n7];
                    n6 = 0;
                    n5 = 0;
                    while (n5 < this.h) {
                        n4 = n10;
                        while (n4 <= n9) {
                            blArray[n6++] = this.occupied[n5 * this.w + n4];
                            ++n4;
                        }
                        ++n5;
                    }
                    tileBlock = new TileBlock(n10 + this.xloc, this.yloc, n7, this.h, blArray);
                    ++n11;
                }
            }
            TileBlock tileBlock2 = null;
            if (n < this.w - 1) {
                n10 = 0;
                n9 = n + 1;
                n8 = n + 1;
                n7 = n + 1;
                while (n7 < this.w) {
                    boolean bl = true;
                    n6 = 0;
                    while (n6 < this.h) {
                        bl = bl && this.occupied[n7 + n6 * this.w];
                        ++n6;
                    }
                    if (!bl) {
                        n8 = n7;
                    } else if (n9 == n7) {
                        ++n9;
                    }
                    ++n7;
                }
                if (n8 >= n9) {
                    int n13 = n8 - n9 + 1;
                    boolean[] blArray = new boolean[this.h * n13];
                    n5 = 0;
                    n4 = 0;
                    while (n4 < this.h) {
                        n3 = n9;
                        while (n3 <= n8) {
                            blArray[n5++] = this.occupied[n4 * this.w + n3];
                            ++n3;
                        }
                        ++n4;
                    }
                    tileBlock2 = new TileBlock(n9 + this.xloc, this.yloc, n13, this.h, blArray);
                    ++n11;
                }
            }
            TileBlock tileBlock3 = null;
            if (n2 > 0) {
                n9 = 0;
                n8 = 0;
                n7 = 0;
                while (n7 < n2) {
                    if (!this.occupied[n7 * this.w + n]) {
                        n8 = n7;
                    } else if (n9 == n7) {
                        ++n9;
                    }
                    ++n7;
                }
                if (n8 >= n9) {
                    int n14 = n8 - n9 + 1;
                    boolean[] blArray = new boolean[n14];
                    n5 = 0;
                    n4 = n9;
                    while (n4 <= n8) {
                        blArray[n5++] = this.occupied[n4 * this.w + n];
                        ++n4;
                    }
                    tileBlock3 = new TileBlock(n + this.xloc, this.yloc, 1, n14, blArray);
                    ++n11;
                }
            }
            TileBlock tileBlock4 = null;
            if (n2 < this.h - 1) {
                n8 = n2 + 1;
                n7 = n2 + 1;
                int n15 = n2 + 1;
                while (n15 < this.h) {
                    if (!this.occupied[n15 * this.w + n]) {
                        n7 = n15;
                    } else if (n8 == n15) {
                        ++n8;
                    }
                    ++n15;
                }
                if (n7 >= n8) {
                    int n16 = n7 - n8 + 1;
                    boolean[] blArray = new boolean[n16];
                    n4 = 0;
                    n3 = n8;
                    while (n3 <= n7) {
                        blArray[n4++] = this.occupied[n3 * this.w + n];
                        ++n3;
                    }
                    tileBlock4 = new TileBlock(n + this.xloc, this.yloc, 1, n16, blArray);
                    ++n11;
                }
            }
            TileBlock[] tileBlockArray = new TileBlock[n11];
            n7 = 0;
            if (tileBlock != null) {
                tileBlockArray[n7++] = tileBlock;
            }
            if (tileBlock2 != null) {
                tileBlockArray[n7++] = tileBlock2;
            }
            if (tileBlock3 != null) {
                tileBlockArray[n7++] = tileBlock3;
            }
            if (tileBlock4 != null) {
                tileBlockArray[n7++] = tileBlock4;
            }
            return tileBlockArray;
        }
    }
}

