/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.TurbulencePatternGenerator;
import org.apache.batik.ext.awt.image.renderable.TurbulenceRable;
import org.apache.batik.ext.awt.image.rendered.BufferedImageCachableRed;

public class TurbulenceRable8Bit
extends AbstractRable
implements TurbulenceRable {
    private static final Paint CLEAR_PAINT = new Color(0, 0, 0, 0);
    int seed = 0;
    int numOctaves = 1;
    double baseFreqX = 0.0;
    double baseFreqY = 0.0;
    boolean stitched = false;
    boolean fractalNoise = false;
    Rectangle2D region;

    public TurbulenceRable8Bit(Rectangle2D rectangle2D) {
        this.region = rectangle2D;
    }

    public TurbulenceRable8Bit(Rectangle2D rectangle2D, int n, int n2, double d, double d2, boolean bl, boolean bl2) {
        this.seed = n;
        this.numOctaves = n2;
        this.baseFreqX = d;
        this.baseFreqY = d2;
        this.stitched = bl;
        this.fractalNoise = bl2;
        this.region = rectangle2D;
    }

    public Rectangle2D getTurbulenceRegion() {
        return (Rectangle2D)this.region.clone();
    }

    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.region.clone();
    }

    public int getSeed() {
        return this.seed;
    }

    public int getNumOctaves() {
        return this.numOctaves;
    }

    public double getBaseFrequencyX() {
        return this.baseFreqX;
    }

    public double getBaseFrequencyY() {
        return this.baseFreqY;
    }

    public boolean isStitched() {
        return this.stitched;
    }

    public boolean isFractalNoise() {
        return this.fractalNoise;
    }

    public void setTurbulenceRegion(Rectangle2D rectangle2D) {
        this.touch();
        this.region = this.region;
    }

    public void setSeed(int n) {
        this.touch();
        this.seed = n;
    }

    public void setNumOctaves(int n) {
        this.touch();
        this.numOctaves = n;
    }

    public void setBaseFrequencyX(double d) {
        this.touch();
        this.baseFreqX = d;
    }

    public void setBaseFrequencyY(double d) {
        this.touch();
        this.baseFreqY = d;
    }

    public void setStitched(boolean bl) {
        this.touch();
        this.stitched = bl;
    }

    public void setFractalNoise(boolean bl) {
        this.touch();
        this.fractalNoise = bl;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Cloneable cloneable;
        Rectangle2D rectangle2D;
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            rectangle2D = this.getBounds2D();
        } else {
            cloneable = this.getBounds2D();
            rectangle2D = shape.getBounds2D();
            if (!rectangle2D.intersects((Rectangle2D)cloneable)) {
                return null;
            }
            Rectangle2D.intersect(rectangle2D, (Rectangle2D)cloneable, rectangle2D);
        }
        cloneable = renderContext.getTransform();
        Rectangle rectangle = ((AffineTransform)cloneable).createTransformedShape(rectangle2D).getBounds();
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return null;
        }
        ColorModel colorModel = GraphicsUtil.Linear_sRGB_Unpre;
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(rectangle.width, rectangle.height);
        WritableRaster writableRaster2 = writableRaster.createWritableTranslatedChild(rectangle.x, rectangle.y);
        TurbulencePatternGenerator turbulencePatternGenerator = new TurbulencePatternGenerator(this.baseFreqX, this.baseFreqY, this.numOctaves, this.seed, this.stitched, this.fractalNoise, (Rectangle2D)this.region.clone(), new boolean[]{true, true, true, true});
        AffineTransform affineTransform = new AffineTransform();
        try {
            affineTransform = ((AffineTransform)cloneable).createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        turbulencePatternGenerator.generatePattern(writableRaster2, affineTransform);
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        return new BufferedImageCachableRed(bufferedImage, rectangle.x, rectangle.y);
    }
}

