/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import org.apache.batik.ext.awt.image.renderable.TransferFunction;

public class DiscreteTransfer
implements TransferFunction {
    public byte[] lutData;
    public int[] tableValues;
    private int n;

    public DiscreteTransfer(int[] nArray) {
        this.tableValues = nArray;
        this.n = nArray.length;
    }

    private void buildLutData() {
        this.lutData = new byte[256];
        int n = 0;
        while (n <= 255) {
            int n2 = (int)Math.floor((float)(n * this.n) / 255.0f);
            if (n2 == this.n) {
                n2 = this.n - 1;
            }
            this.lutData[n] = (byte)(this.tableValues[n2] & 0xFF);
            ++n;
        }
    }

    public byte[] getLookupTable() {
        this.buildLutData();
        return this.lutData;
    }
}

