/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.ComponentTransferFunction;
import org.apache.batik.ext.awt.image.renderable.ComponentTransferOp;
import org.apache.batik.ext.awt.image.renderable.ComponentTransferRable;
import org.apache.batik.ext.awt.image.renderable.DiscreteTransfer;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.GammaTransfer;
import org.apache.batik.ext.awt.image.renderable.IdentityTransfer;
import org.apache.batik.ext.awt.image.renderable.LinearTransfer;
import org.apache.batik.ext.awt.image.renderable.TableTransfer;
import org.apache.batik.ext.awt.image.renderable.TransferFunction;
import org.apache.batik.ext.awt.image.rendered.BufferedImageCachableRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class ComponentTransferRable8Bit
extends AbstractRable
implements ComponentTransferRable {
    public static final int ALPHA = 0;
    public static final int RED = 1;
    public static final int GREEN = 2;
    public static final int BLUE = 3;
    private ComponentTransferFunction[] functions = new ComponentTransferFunction[4];
    private TransferFunction[] txfFunc = new TransferFunction[4];

    public ComponentTransferRable8Bit(Filter filter, ComponentTransferFunction componentTransferFunction, ComponentTransferFunction componentTransferFunction2, ComponentTransferFunction componentTransferFunction3, ComponentTransferFunction componentTransferFunction4) {
        super(filter, null);
        this.setAlphaFunction(componentTransferFunction);
        this.setRedFunction(componentTransferFunction2);
        this.setGreenFunction(componentTransferFunction3);
        this.setBlueFunction(componentTransferFunction4);
    }

    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    public ComponentTransferFunction getAlphaFunction() {
        return this.functions[0];
    }

    public void setAlphaFunction(ComponentTransferFunction componentTransferFunction) {
        this.functions[0] = componentTransferFunction;
        this.txfFunc[0] = null;
    }

    public ComponentTransferFunction getRedFunction() {
        return this.functions[1];
    }

    public void setRedFunction(ComponentTransferFunction componentTransferFunction) {
        this.functions[1] = componentTransferFunction;
        this.txfFunc[1] = null;
    }

    public ComponentTransferFunction getGreenFunction() {
        return this.functions[2];
    }

    public void setGreenFunction(ComponentTransferFunction componentTransferFunction) {
        this.functions[2] = componentTransferFunction;
        this.txfFunc[2] = null;
    }

    public ComponentTransferFunction getBlueFunction() {
        return this.functions[3];
    }

    public void setBlueFunction(ComponentTransferFunction componentTransferFunction) {
        this.functions[3] = componentTransferFunction;
        this.txfFunc[3] = null;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        RenderedImage renderedImage = this.getSource().createRendering(renderContext);
        if (renderedImage == null) {
            return null;
        }
        CachableRed cachableRed = GraphicsUtil.wrap(renderedImage);
        cachableRed = GraphicsUtil.convertToLsRGB(cachableRed);
        int n = cachableRed.getMinX();
        int n2 = cachableRed.getMinY();
        TransferFunction[] transferFunctionArray = this.getTransferFunctions();
        ColorModel colorModel = cachableRed.getColorModel();
        Raster raster = cachableRed.getData();
        WritableRaster writableRaster = GraphicsUtil.makeRasterWritable(raster, 0, 0);
        colorModel = GraphicsUtil.coerceData(writableRaster, colorModel, false);
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        RenderingHints renderingHints = renderContext.getRenderingHints();
        ComponentTransferOp componentTransferOp = new ComponentTransferOp(transferFunctionArray, renderingHints);
        BufferedImage bufferedImage2 = componentTransferOp.filter(bufferedImage, bufferedImage);
        return new BufferedImageCachableRed(bufferedImage2, n, n2);
    }

    private TransferFunction[] getTransferFunctions() {
        TransferFunction[] transferFunctionArray = new TransferFunction[4];
        System.arraycopy(this.txfFunc, 0, transferFunctionArray, 0, 4);
        ComponentTransferFunction[] componentTransferFunctionArray = new ComponentTransferFunction[4];
        System.arraycopy(this.functions, 0, componentTransferFunctionArray, 0, 4);
        int n = 0;
        while (n < 4) {
            if (transferFunctionArray[n] == null) {
                transferFunctionArray[n] = ComponentTransferRable8Bit.getTransferFunction(componentTransferFunctionArray[n]);
                ComponentTransferFunction[] componentTransferFunctionArray2 = this.functions;
                synchronized (componentTransferFunctionArray2) {
                    if (this.functions[n] == componentTransferFunctionArray[n]) {
                        this.txfFunc[n] = transferFunctionArray[n];
                    }
                }
            }
            ++n;
        }
        return transferFunctionArray;
    }

    private static TransferFunction getTransferFunction(ComponentTransferFunction componentTransferFunction) {
        TransferFunction transferFunction = null;
        if (componentTransferFunction == null) {
            transferFunction = new IdentityTransfer();
        } else {
            switch (componentTransferFunction.getType()) {
                case 0: {
                    transferFunction = new IdentityTransfer();
                    break;
                }
                case 1: {
                    transferFunction = new TableTransfer(ComponentTransferRable8Bit.tableFloatToInt(componentTransferFunction.getTableValues()));
                    break;
                }
                case 2: {
                    transferFunction = new DiscreteTransfer(ComponentTransferRable8Bit.tableFloatToInt(componentTransferFunction.getTableValues()));
                    break;
                }
                case 3: {
                    transferFunction = new LinearTransfer(componentTransferFunction.getSlope(), componentTransferFunction.getIntercept());
                    break;
                }
                case 4: {
                    transferFunction = new GammaTransfer(componentTransferFunction.getAmplitude(), componentTransferFunction.getExponent(), componentTransferFunction.getOffset());
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        return transferFunction;
    }

    private static int[] tableFloatToInt(float[] fArray) {
        int[] nArray = new int[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            nArray[n] = (int)(fArray[n] * 255.0f);
            ++n;
        }
        return nArray;
    }
}

