/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.value.AbstractImmutablePrimitiveValue;
import org.apache.batik.css.value.ImmutableValue;
import org.w3c.dom.DOMException;

public class ImmutableFloat
extends AbstractImmutablePrimitiveValue {
    protected static final String[] UNITS = new String[]{"", "%", "em", "es", "px", "cm", "mm", "in", "pt", "pc", "deg", "rad", "grad", "ms", "s", "Hz", "kHz", ""};
    protected float floatValue;
    protected short unitType;

    public ImmutableFloat(short s, float f) {
        this.unitType = s;
        this.floatValue = f;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ImmutableFloat)) {
            return false;
        }
        ImmutableFloat immutableFloat = (ImmutableFloat)object;
        return this.floatValue == immutableFloat.getFloatValue(this.unitType);
    }

    public ImmutableValue createReadOnlyCopy() {
        return this;
    }

    public short getPrimitiveType() {
        return this.unitType;
    }

    public String getCssText() {
        return this.floatValue + ImmutableFloat.getUnitRepresentation(this.unitType);
    }

    public float getFloatValue(short s) throws DOMException {
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 18: {
                if (this.unitType != s) break;
                return this.floatValue;
            }
            case 6: {
                return this.toCentimeters();
            }
            case 7: {
                return this.toMillimeters();
            }
            case 8: {
                return this.toInches();
            }
            case 9: {
                return this.toPoints();
            }
            case 10: {
                return this.toPicas();
            }
            case 11: {
                return this.toDegrees();
            }
            case 12: {
                return this.toRadians();
            }
            case 13: {
                return this.toGradians();
            }
            case 14: {
                return this.toMilliseconds();
            }
            case 15: {
                return this.toSeconds();
            }
            case 16: {
                return this.toHertz();
            }
            case 17: {
                return this.tokHertz();
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.primitive.unit", new Object[]{new Integer(s)});
    }

    protected static String getUnitRepresentation(short s) throws DOMException {
        if (s < 1 && s > 18) {
            throw CSSDOMExceptionFactory.createDOMException((short)15, "out.of.range.unit.type", new Object[]{new Integer(s)});
        }
        return UNITS[s - 1];
    }

    protected float toCentimeters() {
        switch (this.unitType) {
            case 6: {
                return this.floatValue;
            }
            case 7: {
                return this.floatValue / 10.0f;
            }
            case 8: {
                return (float)((double)this.floatValue * 2.54);
            }
            case 9: {
                return (float)((double)this.floatValue * 2.54 / 72.0);
            }
            case 10: {
                return (float)((double)this.floatValue * 2.54 / 6.0);
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.convertion", new Object[]{new Integer(this.unitType)});
    }

    protected float toInches() {
        switch (this.unitType) {
            case 6: {
                return (float)((double)this.floatValue / 2.54);
            }
            case 7: {
                return (float)((double)this.floatValue / 25.4);
            }
            case 8: {
                return this.floatValue;
            }
            case 9: {
                return this.floatValue / 72.0f;
            }
            case 10: {
                return this.floatValue / 6.0f;
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.convertion", new Object[]{new Integer(this.unitType)});
    }

    protected float toMillimeters() {
        switch (this.unitType) {
            case 6: {
                return this.floatValue * 10.0f;
            }
            case 7: {
                return this.floatValue;
            }
            case 8: {
                return (float)((double)this.floatValue * 25.4);
            }
            case 9: {
                return (float)((double)this.floatValue * 25.4 / 72.0);
            }
            case 10: {
                return (float)((double)this.floatValue * 25.4 / 6.0);
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.convertion", new Object[]{new Integer(this.unitType)});
    }

    protected float toPoints() {
        switch (this.unitType) {
            case 6: {
                return (float)((double)(this.floatValue * 72.0f) / 2.54);
            }
            case 7: {
                return (float)((double)(this.floatValue * 72.0f) / 25.4);
            }
            case 8: {
                return this.floatValue * 72.0f;
            }
            case 9: {
                return this.floatValue;
            }
            case 10: {
                return this.floatValue * 12.0f;
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.convertion", new Object[]{new Integer(this.unitType)});
    }

    protected float toPicas() {
        switch (this.unitType) {
            case 6: {
                return (float)((double)(this.floatValue * 6.0f) / 2.54);
            }
            case 7: {
                return (float)((double)(this.floatValue * 6.0f) / 25.4);
            }
            case 8: {
                return this.floatValue * 6.0f;
            }
            case 9: {
                return this.floatValue / 12.0f;
            }
            case 10: {
                return this.floatValue;
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.convertion", new Object[]{new Integer(this.unitType)});
    }

    protected float toDegrees() {
        switch (this.unitType) {
            case 11: {
                return this.floatValue;
            }
            case 12: {
                return (float)((double)(this.floatValue * 180.0f) / Math.PI);
            }
            case 13: {
                return this.floatValue * 9.0f / 5.0f;
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.convertion", new Object[]{new Integer(this.unitType)});
    }

    protected float toRadians() {
        switch (this.unitType) {
            case 11: {
                return this.floatValue * 5.0f / 9.0f;
            }
            case 12: {
                return this.floatValue;
            }
            case 13: {
                return (float)((double)(this.floatValue * 100.0f) / Math.PI);
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.convertion", new Object[]{new Integer(this.unitType)});
    }

    protected float toGradians() {
        switch (this.unitType) {
            case 11: {
                return (float)((double)this.floatValue * Math.PI / 180.0);
            }
            case 12: {
                return (float)((double)this.floatValue * Math.PI / 100.0);
            }
            case 13: {
                return this.floatValue;
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.convertion", new Object[]{new Integer(this.unitType)});
    }

    protected float toMilliseconds() {
        switch (this.unitType) {
            case 14: {
                return this.floatValue;
            }
            case 15: {
                return this.floatValue * 1000.0f;
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.convertion", new Object[]{new Integer(this.unitType)});
    }

    protected float toSeconds() {
        switch (this.unitType) {
            case 14: {
                return this.floatValue / 1000.0f;
            }
            case 15: {
                return this.floatValue;
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.convertion", new Object[]{new Integer(this.unitType)});
    }

    protected float toHertz() {
        switch (this.unitType) {
            case 16: {
                return this.floatValue;
            }
            case 17: {
                return this.floatValue / 1000.0f;
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.convertion", new Object[]{new Integer(this.unitType)});
    }

    protected float tokHertz() {
        switch (this.unitType) {
            case 16: {
                return this.floatValue * 1000.0f;
            }
            case 17: {
                return this.floatValue;
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.convertion", new Object[]{new Integer(this.unitType)});
    }
}

