/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.svg;

import org.apache.batik.css.CSSOMReadOnlyStyleDeclaration;
import org.apache.batik.css.CSSOMReadOnlyValue;
import org.apache.batik.css.svg.SVGCSSContext;
import org.apache.batik.css.svg.SVGValueConstants;
import org.apache.batik.css.value.ImmutableFloat;
import org.apache.batik.css.value.RelativeValueResolver;
import org.w3c.dom.Element;
import org.w3c.dom.css.ViewCSS;

public class StrokeWidthResolver
implements RelativeValueResolver {
    protected SVGCSSContext context;

    public StrokeWidthResolver(SVGCSSContext sVGCSSContext) {
        this.context = sVGCSSContext;
    }

    public boolean isInheritedProperty() {
        return true;
    }

    public String getPropertyName() {
        return "stroke-width";
    }

    public CSSOMReadOnlyValue getDefaultValue() {
        return new CSSOMReadOnlyValue(SVGValueConstants.NUMBER_1);
    }

    public void resolveValue(Element element, String string, ViewCSS viewCSS, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration, CSSOMReadOnlyValue cSSOMReadOnlyValue, String string2, int n) {
        if (cSSOMReadOnlyValue.getPrimitiveType() == 2) {
            double d = this.context.getViewportWidth();
            double d2 = this.context.getViewportHeight();
            double d3 = Math.sqrt(d * d + d2 * d2);
            double d4 = cSSOMReadOnlyValue.getFloatValue((short)2);
            float f = (float)(d4 * d3 / 100.0);
            ImmutableFloat immutableFloat = new ImmutableFloat(1, f);
            cSSOMReadOnlyStyleDeclaration.setPropertyCSSValue(this.getPropertyName(), new CSSOMReadOnlyValue(immutableFloat), string2, n);
        }
    }
}

