/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Composite;
import java.awt.Cursor;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeEventSupport;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.HiddenChildElementSupport;
import org.apache.batik.ext.awt.image.renderable.Clip;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.filter.Mask;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGElement;

public class SVGAElementBridge
implements GraphicsNodeBridge,
SVGConstants {
    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        DefaultUnitProcessorContext defaultUnitProcessorContext;
        Rectangle2D rectangle2D;
        Object object;
        CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
        String string = element.getAttributeNS(null, "transform");
        if (string.length() > 0) {
            object = SVGUtilities.convertAffineTransform(string);
            compositeGraphicsNode.setTransform((AffineTransform)object);
        }
        if ((rectangle2D = CSSUtilities.convertEnableBackground((SVGElement)element, (CSSStyleDeclaration)(object = CSSUtilities.getComputedStyle(element)), defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, (CSSStyleDeclaration)object))) != null) {
            compositeGraphicsNode.setBackgroundEnable(rectangle2D);
        }
        return compositeGraphicsNode;
    }

    public void buildGraphicsNode(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element) {
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("opacity");
        Composite composite = CSSUtilities.convertOpacityToComposite(cSSPrimitiveValue);
        graphicsNode.setComposite(composite);
        Filter filter = CSSUtilities.convertFilter(element, graphicsNode, bridgeContext);
        graphicsNode.setFilter(filter);
        Mask mask = CSSUtilities.convertMask(element, graphicsNode, bridgeContext);
        graphicsNode.setMask(mask);
        Clip clip = CSSUtilities.convertClipPath(element, graphicsNode, bridgeContext);
        graphicsNode.setClip(clip);
        EventTarget eventTarget = (EventTarget)((Object)element);
        eventTarget.addEventListener("click", new AnchorListener(bridgeContext.getUserAgent()), false);
        eventTarget.addEventListener("mouseover", new CursorMouseOverListener(bridgeContext.getUserAgent()), false);
        eventTarget.addEventListener("mouseout", new CursorMouseOutListener(bridgeContext.getUserAgent()), false);
        BridgeEventSupport.addDOMListener(bridgeContext, (SVGElement)element);
        bridgeContext.bind(element, graphicsNode);
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }

    public boolean isContainer() {
        return true;
    }

    protected static class CursorMouseOutListener
    implements EventListener {
        protected UserAgent userAgent;

        public CursorMouseOutListener(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        public void handleEvent(Event event) {
            SVGAElement sVGAElement = null;
            Element element = (Element)((Object)event.getTarget());
            while (element != null) {
                if (element instanceof SVGAElement) {
                    sVGAElement = (SVGAElement)element;
                    break;
                }
                element = HiddenChildElementSupport.getParentElement(element);
            }
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.userAgent.setSVGCursor(cursor);
            this.userAgent.displayMessage("");
        }
    }

    protected static class CursorMouseOverListener
    implements EventListener {
        protected UserAgent userAgent;

        public CursorMouseOverListener(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        public void handleEvent(Event event) {
            SVGAElement sVGAElement = null;
            Element element = (Element)((Object)event.getTarget());
            while (element != null) {
                if (element instanceof SVGAElement) {
                    sVGAElement = (SVGAElement)element;
                    break;
                }
                element = HiddenChildElementSupport.getParentElement(element);
            }
            Cursor cursor = Cursor.getPredefinedCursor(12);
            this.userAgent.setSVGCursor(cursor);
            if (sVGAElement != null) {
                this.userAgent.displayMessage(sVGAElement.getHref().getBaseVal());
            }
        }
    }

    protected static class AnchorListener
    implements EventListener {
        protected UserAgent userAgent;

        public AnchorListener(UserAgent userAgent) {
            this.userAgent = userAgent;
        }

        public void handleEvent(Event event) {
            SVGAElement sVGAElement = null;
            Element element = (Element)((Object)event.getTarget());
            while (element != null) {
                if (element instanceof SVGAElement) {
                    sVGAElement = (SVGAElement)element;
                    break;
                }
                element = HiddenChildElementSupport.getParentElement(element);
            }
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.userAgent.setSVGCursor(cursor);
            this.userAgent.openLink(sVGAElement);
        }
    }
}

