/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MutationEvent;

public class BridgeDOMInsertedRemovedListener
implements EventListener {
    private static final String DOM_NODE_INSERTED_TYPE = "DOMNodeInserted";
    private static final String DOM_NODE_REMOVED_TYPE = "DOMNodeRemoved";
    private BridgeContext context;

    public BridgeDOMInsertedRemovedListener(BridgeContext bridgeContext) {
        this.context = bridgeContext;
    }

    public void handleEvent(Event event) {
        GraphicsNode graphicsNode;
        MutationEvent mutationEvent = (MutationEvent)event;
        Node node = (Node)((Object)mutationEvent.getTarget());
        Element element = (Element)mutationEvent.getRelatedNode();
        if (node.getNodeType() == 1 && (graphicsNode = this.context.getGraphicsNode(element)) != null) {
            if (mutationEvent.getType().equals(DOM_NODE_INSERTED_TYPE)) {
                GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)this.context.getBridge((Element)node);
                if (graphicsNodeBridge != null) {
                    GraphicsNode graphicsNode2 = graphicsNodeBridge.createGraphicsNode(this.context, (Element)node);
                    ((CompositeGraphicsNode)graphicsNode).getChildren().add(graphicsNode2);
                }
            } else {
                GraphicsNode graphicsNode3 = this.context.getGraphicsNode((Element)node);
                ((CompositeGraphicsNode)graphicsNode).getChildren().remove(graphicsNode3);
                this.context.unbind((Element)node);
            }
        }
    }
}

