/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db.pool;

import java.util.Hashtable;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.db.map.DatabaseMap;
import org.apache.turbine.util.db.pool.ConnectionPool;
import org.apache.turbine.util.db.pool.DB;
import org.apache.turbine.util.db.pool.DBConnection;

public class DBBroker {
    private static DBBroker instance = null;
    private static Hashtable pools = null;
    private static Hashtable dbMaps = null;
    public static final String DEFAULT = "default";
    static /* synthetic */ Class class$org$apache$turbine$util$db$pool$DBBroker;

    private DBBroker() {
        pools = new Hashtable();
        dbMaps = new Hashtable();
    }

    public void addDatabaseMap(String name) {
        dbMaps.put(name, new DatabaseMap(name));
    }

    public void addDatabaseMap(DatabaseMap map) {
        dbMaps.put(map.getName(), map);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public DBConnection getConnection() throws Exception {
        return this.getConnection(TurbineResources.getString("database.default.driver", ""), TurbineResources.getString("database.default.url", ""), TurbineResources.getString("database.default.username", ""), TurbineResources.getString("database.default.password", ""));
    }

    public DBConnection getConnection(String name) throws Exception {
        return this.getConnection(TurbineResources.getString("database." + name + ".driver", ""), TurbineResources.getString("database." + name + ".url", ""), TurbineResources.getString("database." + name + ".username", ""), TurbineResources.getString("database." + name + ".password", ""));
    }

    public DBConnection getConnection(String driver, String url, String username, String password) throws Exception {
        ConnectionPool pool;
        if (pools.containsKey(url = url.trim())) {
            pool = (ConnectionPool)pools.get(url);
        } else {
            pool = new ConnectionPool();
            pools.put(url, pool);
        }
        return pool.getConnection(driver, url, username, password);
    }

    public DB getDB() throws Exception {
        return this.getDB(DEFAULT);
    }

    public DB getDB(String name) throws Exception {
        String url = TurbineResources.getString("database." + name + ".url", "").trim();
        ConnectionPool cp = (ConnectionPool)pools.get(url);
        if (cp == null) {
            DBConnection dbcon = this.getConnection(name);
            this.releaseConnection(dbcon);
            cp = (ConnectionPool)pools.get(url);
        }
        return cp.getDB();
    }

    public DatabaseMap getDatabaseMap() throws Exception {
        return this.getDatabaseMap(DEFAULT);
    }

    public DatabaseMap getDatabaseMap(String name) throws Exception {
        if (name == null) {
            throw new Exception("DatabaseMap name was null!");
        }
        if (dbMaps.containsKey(name)) {
            return (DatabaseMap)dbMaps.get(name);
        }
        DatabaseMap dbMap = new DatabaseMap(name);
        dbMaps.put(name, dbMap);
        return dbMap;
    }

    public static DBBroker getInstance() {
        if (instance == null) {
            Class clazz = class$org$apache$turbine$util$db$pool$DBBroker != null ? class$org$apache$turbine$util$db$pool$DBBroker : (class$org$apache$turbine$util$db$pool$DBBroker = DBBroker.class$("org.apache.turbine.util.db.pool.DBBroker"));
            synchronized (clazz) {
                if (instance == null) {
                    instance = new DBBroker();
                }
            }
        }
        return instance;
    }

    public void releaseConnection(DBConnection connection) throws Exception {
        String url;
        if (connection != null && (url = connection.getUrl()) != null && pools.containsKey(url)) {
            ConnectionPool pool = (ConnectionPool)pools.get(url);
            pool.releaseConnection(connection);
        }
    }
}

