/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db.map;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.turbine.util.db.IDBroker;
import org.apache.turbine.util.db.map.TableMap;

public class DatabaseMap {
    private String name;
    private Hashtable tables;
    private TableMap idTable = null;
    private IDBroker idBroker = null;

    public DatabaseMap(String name) {
        this.name = name;
        this.tables = new Hashtable();
    }

    public DatabaseMap(String name, int numberOfTables) {
        this.name = name;
        this.tables = new Hashtable((int)(1.25 * (double)numberOfTables) + 1);
    }

    public void addTable(String tableName) {
        TableMap tmap = new TableMap(tableName, this);
        this.tables.put(tableName, tmap);
    }

    public void addTable(String tableName, int numberOfColumns) {
        TableMap tmap = new TableMap(tableName, numberOfColumns, this);
        this.tables.put(tableName, tmap);
    }

    public void addTable(TableMap map) {
        this.tables.put(map.getName(), map);
    }

    public boolean containsTable(String name) {
        if (name.indexOf(46) > 0) {
            name = name.substring(0, name.indexOf(46));
        }
        return this.tables.containsKey(name);
    }

    public boolean containsTable(TableMap table) {
        return this.containsTable(table.getName());
    }

    public IDBroker getIDBroker() {
        return this.idBroker;
    }

    public TableMap getIdTable() {
        return this.idTable;
    }

    public String getName() {
        return this.name;
    }

    public TableMap getTable(String name) {
        return (TableMap)this.tables.get(name);
    }

    public TableMap[] getTables() {
        TableMap[] dbTables = new TableMap[this.tables.size()];
        Enumeration e = this.tables.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            dbTables[i++] = (TableMap)e.nextElement();
        }
        return dbTables;
    }

    public void setIdTable(String tableName) {
        TableMap tmap = new TableMap(tableName, this);
        this.setIdTable(tmap);
    }

    public void setIdTable(TableMap idTable) {
        this.idTable = idTable;
        this.addTable(idTable);
        this.idBroker = new IDBroker(idTable);
    }
}

