/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterTreeConstants;
import bsh.NameSpace;
import bsh.Node;
import bsh.Token;

class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    Token firstToken;
    Token lastToken;

    public SimpleNode(int n) {
        this.id = n;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return InterpreterTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(string + " ");
                }
                ++n;
            }
        }
    }

    public void prune() {
        this.jjtSetParent(null);
    }

    public Object eval(NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        throw new EvalError("Unimplemented or inappropriate for " + this.getClass().getName());
    }
}

