/*
 * File:        overloadtest.c
 * Copyright:   (c) 2001 The Regents of the University of California
 * Revision:    @(#) $Revision: 4434 $
 * Date:        $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
 * Description: Overload Test C client
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "Overload.h"
#include "synch.h"

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

static void declare_part( synch_RegOut tracker, int * part_no )
{
  synch_RegOut_startPart(tracker, ++(*part_no));
}

static void end_part(synch_RegOut tracker, int part_no, 
                     enum synch_ResultType__enum result)
{
  synch_RegOut_endPart(tracker, part_no, result);
}

#define CHECK(FUNC,COMMENT)                 \
  declare_part(tracker, &part_no);                   \
  synch_RegOut_writeComment(tracker, COMMENT); \
  result = (FUNC) ? synch_ResultType_PASS : synch_ResultType_FAIL;  \
  end_part(tracker, part_no, result);


int main(int argc, char**argv)
{ 
  enum synch_ResultType__enum result       = synch_ResultType_PASS; 
  int part_no      = 0;
  synch_RegOut tracker = synch_RegOut__create();

  double d1        = 1.0;
  float  f1        = 1.0F;
  int    i1        = 1;
  double did       = 2.0;
  double difd      = 3.0;
  const char*  ev  = "AnException";
  char *msg;
  char*        s1  = "test string";
  char*        sret;

  struct sidl_dcomplex dc = { 1.1, 1.1 };
  struct sidl_dcomplex dcret;
  struct sidl_fcomplex fc = { 1.1F, 1.1F };
  struct sidl_fcomplex fcret;

  Overload_Test        t  = Overload_Test__create ();
  Overload_AnException ae = Overload_AnException__create ();
  Overload_AClass      ac = Overload_AClass__create();
  Overload_BClass      bc = Overload_BClass__create();

  synch_RegOut_setExpectations(tracker, 19);
  CHECK(Overload_Test_getValue(t) == 1, 
        "checking empty argument to known value");

  CHECK(Overload_Test_getValueBool(t, TRUE) == TRUE, "checking bool");
  CHECK(Overload_Test_getValueDouble(t, d1) == d1, "checking double");
  dcret = Overload_Test_getValueDcomplex(t, dc);
  CHECK(dcret.real == dc.real && dcret.imaginary == dc.imaginary, 
        "checking dcomplex");
  CHECK(Overload_Test_getValueFloat(t, f1) == f1, "checking float");
  fcret = Overload_Test_getValueFcomplex(t, fc);
  CHECK(fcret.real == fc.real && fcret.imaginary == fc.imaginary, 
        "checking fcomplex");
  CHECK(Overload_Test_getValueInt(t, i1) == i1, "checking int");
  sret = Overload_Test_getValueString(t, s1);
  CHECK(sret && !strcmp(sret, s1), "checking string");
  if (sret) free ((void*)sret);

  CHECK(Overload_Test_getValueDoubleInt(t, d1, i1) == did, 
        "checking double int");
  CHECK(Overload_Test_getValueIntDouble(t, i1, d1) == did, 
        "checking int double");

  CHECK(Overload_Test_getValueDoubleIntFloat(t, d1, i1, f1) == difd, 
       "checking double int float");
  CHECK(Overload_Test_getValueIntDoubleFloat(t, i1, d1, f1) == difd, 
        "checking int double float");

  CHECK(Overload_Test_getValueDoubleFloatInt(t, d1, f1, i1) == difd, 
       "checking double float int");
  CHECK(Overload_Test_getValueIntFloatDouble(t, i1, f1, d1) == difd, 
        "checking int float double");

  CHECK(Overload_Test_getValueFloatDoubleInt(t, f1, d1, i1) == difd, 
       "checking float double int");
  CHECK(Overload_Test_getValueFloatIntDouble(t, f1, i1, d1) == difd, 
        "checking float int double");

  msg = Overload_Test_getValueException(t, ae);
  CHECK(msg && !strcmp(msg, ev), 
        "checking exception to known value");
  if (msg) free((void*)msg);

  CHECK(Overload_Test_getValueAClass(t, ac) == 2, 
        "checking AClass value to known value");

  CHECK(Overload_Test_getValueBClass(t, bc) == 2, 
        "checking BClass value to known value");


  Overload_BClass_deleteRef (bc);
  Overload_AClass_deleteRef (ac);
  Overload_AnException_deleteRef (ae);
  Overload_Test_deleteRef (t);
  synch_RegOut_close(tracker);
  synch_RegOut_deleteRef(tracker);
  return 0;
}
