// 
// File:          gov_cca_TypeMap.hh
// Symbol:        gov.cca.TypeMap-v0.6.3
// Symbol Type:   interface
// Babel Version: 0.10.2
// Description:   Client-side glue code for gov.cca.TypeMap
// 
// WARNING: Automatically generated; changes will be lost
// 
// babel-version = 0.10.2
// 

#ifndef included_gov_cca_TypeMap_hh
#define included_gov_cca_TypeMap_hh

// declare class before #includes
// (this alleviates circular #include guard problems)[BUG#393]
namespace gov { 
  namespace cca { 

    class TypeMap;
  } // end namespace cca
} // end namespace gov

// Some compilers need to define array template before the specializations
#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
namespace sidl {
  template<>
  class array< ::gov::cca::TypeMap >;
}

#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
#ifndef included_gov_cca_TypeMap_IOR_h
#include "gov_cca_TypeMap_IOR.h"
#endif
// 
// Includes for all method dependencies.
// 
#ifndef included_gov_cca_Type_hh
#include "gov_cca_Type.hh"
#endif
#ifndef included_gov_cca_TypeMismatchException_hh
#include "gov_cca_TypeMismatchException.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif

namespace gov { 
  namespace cca { 

    /**
     * Symbol "gov.cca.TypeMap" (version 0.6.3)
     * 
     *  A CCA map.  Maps a string key to a particular value. Types are
     *  strictly enforced.  For example, values places into the map
     *  using putInt can be retrieved only using getInt.  Calls to
     *  getLong, getString, getIntArray and other get methods will
     *  fail (i.e. return the default value). 
     */
    class TypeMap : public ::sidl::StubBase {

      //////////////////////////////////////////////////
      // 
      // User Defined Methods
      // 

    public:

      /**
       * <p>
       * Add one to the intrinsic reference count in the underlying object.
       * Object in <code>sidl</code> have an intrinsic reference count.
       * Objects continue to exist as long as the reference count is
       * positive. Clients should call this method whenever they
       * create another ongoing reference to an object or interface.
       * </p>
       * <p>
       * This does not have a return value because there is no language
       * independent type that can refer to an interface or a
       * class.
       * </p>
       */
      inline void
      addRef() throw () 
      {

        if ( !d_weak_reference ) {
          /*pack args to dispatch to ior*/
          (*(d_self->d_epv->f_addRef))(d_self->d_object );
          /*dispatch to ior*/
          /*unpack results and cleanup*/
        }
      }



      /**
       * Decrease by one the intrinsic reference count in the underlying
       * object, and delete the object if the reference is non-positive.
       * Objects in <code>sidl</code> have an intrinsic reference count.
       * Clients should call this method whenever they remove a
       * reference to an object or interface.
       */
      inline void
      deleteRef() throw () 
      {

        if ( !d_weak_reference ) {
          /*pack args to dispatch to ior*/
          (*(d_self->d_epv->f_deleteRef))(d_self->d_object );
          /*dispatch to ior*/
          /*unpack results and cleanup*/
          d_self = 0;
        }
      }



      /**
       * Return true if and only if <code>obj</code> refers to the same
       * object as this object.
       */
      bool
      isSame (
        /* in */ ::sidl::BaseInterface iobj
      )
      throw () 
      ;



      /**
       * Check whether the object can support the specified interface or
       * class.  If the <code>sidl</code> type name in <code>name</code>
       * is supported, then a reference to that object is returned with the
       * reference count incremented.  The callee will be responsible for
       * calling <code>deleteRef</code> on the returned object.  If
       * the specified type is not supported, then a null reference is
       * returned.
       */
      ::sidl::BaseInterface
      queryInt (
        /* in */ const ::std::string& name
      )
      throw () 
      ;



      /**
       * Return whether this object is an instance of the specified type.
       * The string name must be the <code>sidl</code> type name.  This
       * routine will return <code>true</code> if and only if a cast to
       * the string type name would succeed.
       */
      bool
      isType (
        /* in */ const ::std::string& name
      )
      throw () 
      ;



      /**
       * Return the meta-data about the class implementing this interface.
       */
      ::sidl::ClassInfo
      getClassInfo() throw () 
      ;


      /**
       * Create an exact copy of this Map 
       */
      ::gov::cca::TypeMap
      cloneTypeMap() throw () 
      ;


      /**
       * Create a new Map with no key/value associations. 
       */
      ::gov::cca::TypeMap
      cloneEmpty() throw () 
      ;

      /**
       * User-defined non-static method.
       */
      int32_t
      getInt (
        /* in */ const ::std::string& key,
        /* in */ int32_t dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      int64_t
      getLong (
        /* in */ const ::std::string& key,
        /* in */ int64_t dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      float
      getFloat (
        /* in */ const ::std::string& key,
        /* in */ float dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      double
      getDouble (
        /* in */ const ::std::string& key,
        /* in */ double dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      ::std::complex<float>
      getFcomplex (
        /* in */ const ::std::string& key,
        /* in */ const ::std::complex<float>& dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      ::std::complex<double>
      getDcomplex (
        /* in */ const ::std::string& key,
        /* in */ const ::std::complex<double>& dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      ::std::string
      getString (
        /* in */ const ::std::string& key,
        /* in */ const ::std::string& dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      bool
      getBool (
        /* in */ const ::std::string& key,
        /* in */ bool dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      ::sidl::array<int32_t>
      getIntArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array<int32_t> dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      ::sidl::array<int64_t>
      getLongArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array<int64_t> dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      ::sidl::array<float>
      getFloatArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array<float> dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      ::sidl::array<double>
      getDoubleArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array<double> dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      ::sidl::array< ::sidl::fcomplex>
      getFcomplexArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array< ::sidl::fcomplex> dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      ::sidl::array< ::sidl::dcomplex>
      getDcomplexArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array< ::sidl::dcomplex> dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      ::sidl::array< ::std::string>
      getStringArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array< ::std::string> dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );


      /**
       * User-defined non-static method.
       */
      ::sidl::array<bool>
      getBoolArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array<bool> dflt
      )
      throw ( 
        ::gov::cca::TypeMismatchException
      );



      /**
       * Assign a key and value. Any value previously assigned
       * to the same key will be overwritten.  
       */
      void
      putInt (
        /* in */ const ::std::string& key,
        /* in */ int32_t value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putLong (
        /* in */ const ::std::string& key,
        /* in */ int64_t value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putFloat (
        /* in */ const ::std::string& key,
        /* in */ float value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putDouble (
        /* in */ const ::std::string& key,
        /* in */ double value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putFcomplex (
        /* in */ const ::std::string& key,
        /* in */ const ::std::complex<float>& value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putDcomplex (
        /* in */ const ::std::string& key,
        /* in */ const ::std::complex<double>& value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putString (
        /* in */ const ::std::string& key,
        /* in */ const ::std::string& value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putBool (
        /* in */ const ::std::string& key,
        /* in */ bool value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putIntArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array<int32_t> value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putLongArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array<int64_t> value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putFloatArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array<float> value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putDoubleArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array<double> value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putFcomplexArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array< ::sidl::fcomplex> value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putDcomplexArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array< ::sidl::dcomplex> value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putStringArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array< ::std::string> value
      )
      throw () 
      ;


      /**
       * User-defined non-static method.
       */
      void
      putBoolArray (
        /* in */ const ::std::string& key,
        /* in */ ::sidl::array<bool> value
      )
      throw () 
      ;



      /**
       * Make the key and associated value disappear from the object. 
       */
      void
      remove (
        /* in */ const ::std::string& key
      )
      throw () 
      ;



      /**
       *  Get all the names associated with a particular type
       *  without exposing the data implementation details.  The keys
       *  will be returned in an arbitrary order. If type specified is
       *  None (no specification) all keys of all types are returned.
       */
      ::sidl::array< ::std::string>
      getAllKeys (
        /* in */ ::gov::cca::Type t
      )
      throw () 
      ;



      /**
       * Return true if the key exists in this map 
       */
      bool
      hasKey (
        /* in */ const ::std::string& key
      )
      throw () 
      ;



      /**
       * Return the type of the value associated with this key 
       */
      ::gov::cca::Type
      typeOf (
        /* in */ const ::std::string& key
      )
      throw () 
      ;



      //////////////////////////////////////////////////
      // 
      // End User Defined Methods
      // (everything else in this file is specific to
      //  Babel's C++ bindings)
      // 

    public:
      typedef struct gov_cca_TypeMap__object ior_t;
      typedef struct gov_cca_TypeMap__external ext_t;
      typedef struct gov_cca_TypeMap__sepv sepv_t;

      // default constructor
      TypeMap() : d_self(0), d_weak_reference(false) { }

      // default destructor
      virtual ~TypeMap ();

      // copy constructor
      TypeMap ( const TypeMap& original );

      // assignment operator
      TypeMap& operator= ( const TypeMap& rhs );

      // conversion from ior to C++ class
      TypeMap ( TypeMap::ior_t* ior );

      // Alternate constructor: does not call addRef()
      // (sets d_weak_reference=isWeak)
      // For internal use by Impls (fixes bug#275)
      TypeMap ( TypeMap::ior_t* ior, bool isWeak );

      // conversion from a StubBase
      TypeMap ( const ::sidl::StubBase& base );

      ior_t* _get_ior() { return d_self; }

      const ior_t* _get_ior() const { return d_self; }

      void _set_ior( ior_t* ptr ) { d_self = ptr; }

      bool _is_nil() const { return (d_self==0); }

      bool _not_nil() const { return (d_self!=0); }

      bool operator !() const { return (d_self==0); }

    protected:
      virtual void* _cast(const char* type) const;

    private:
      // Pointer to sidl's IOR type (one per instance)
      ior_t * d_self;

      // Weak references (used by Impl's only) don't add/deleteRef()
      bool d_weak_reference;

      // Pointer to external (DLL loadable) symbols (shared among instances)
      static const ext_t * s_ext;

    public:
      static const ext_t * _get_ext() throw ( ::sidl::NullIORException );

    }; // end class TypeMap
  } // end namespace cca
} // end namespace gov

namespace sidl {
  // traits specialization
  template<>
  struct array_traits< ::gov::cca::TypeMap > {
    typedef array< ::gov::cca::TypeMap > cxx_array_t;
    typedef ::gov::cca::TypeMap cxx_item_t;
    typedef struct gov_cca_TypeMap__array ior_array_t;
    typedef sidl_interface__array ior_array_internal_t;
    typedef struct gov_cca_TypeMap__object ior_item_t;
    typedef  cxx_item_t value_type;
    typedef  value_type reference;
    typedef  value_type* pointer;
    typedef  const value_type const_reference;
    typedef  const value_type* const_pointer;
    typedef  array_iter< array_traits< ::gov::cca::TypeMap > > iterator;
    typedef  const_array_iter< array_traits< ::gov::cca::TypeMap > > 
      const_iterator;
  };

  // array specialization
  template<>
  class array< ::gov::cca::TypeMap >: public interface_array< array_traits< 
    ::gov::cca::TypeMap > > {
  public:
    typedef interface_array< array_traits< ::gov::cca::TypeMap > > Base;
    typedef array_traits< ::gov::cca::TypeMap >::cxx_array_t          
      cxx_array_t;
    typedef array_traits< ::gov::cca::TypeMap >::cxx_item_t           
      cxx_item_t;
    typedef array_traits< ::gov::cca::TypeMap >::ior_array_t          
      ior_array_t;
    typedef array_traits< ::gov::cca::TypeMap >::ior_array_internal_t 
      ior_array_internal_t;
    typedef array_traits< ::gov::cca::TypeMap >::ior_item_t           
      ior_item_t;

    /**
     * conversion from ior to C++ class
     * (constructor/casting operator)
     */
    array( struct gov_cca_TypeMap__array* src = 0) : Base(src) {}

    /**
     * copy constructor
     */
    array( const array< ::gov::cca::TypeMap >&src) : Base(src) {}

    /**
     * assignment
     */
    array< ::gov::cca::TypeMap >&
    operator =( const array< ::gov::cca::TypeMap >&rhs ) { 
      if (d_array != rhs._get_baseior()) {
        if (d_array) deleteRef();
        d_array = const_cast<sidl__array *>(rhs._get_baseior());
        if (d_array) addRef();
      }
      return *this;
    }

  };
}

#endif
