/*
 * File:          gov_cca_CCAExceptionType_IOR.h
 * Symbol:        gov.cca.CCAExceptionType-v0.6.3
 * Symbol Type:   enumeration
 * Babel Version: 0.10.2
 * Description:   Intermediate Object Representation for gov.cca.CCAExceptionType
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#ifndef included_gov_cca_CCAExceptionType_IOR_h
#define included_gov_cca_CCAExceptionType_IOR_h

#ifndef included_sidlType_h
#include "sidlType.h"
#endif
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Symbol "gov.cca.CCAExceptionType" (version 0.6.3)
 * 
 * Mapping of standard exceptional event types
 * occuring in the Services interface to integers. 
 */


/* Opaque forward declaration of array struct */
struct gov_cca_CCAExceptionType__array;

enum gov_cca_CCAExceptionType__enum {
  /**
   *  Someone caught a non-CCAException that was declared
   *  at an interface that claims it throws ONLY CCAException. 
   */
  gov_cca_CCAExceptionType_Unexpected          = -1,

  /**
   * A CCAException that is carrying a non-standard message. 
   */
  gov_cca_CCAExceptionType_Nonstandard         = 1,

  /**
   * Action attempted on a port name that is neither registered
   * nor added. 
   */
  gov_cca_CCAExceptionType_PortNotDefined      = 2,

  /**
   * Adding/registering an already added/registered Port was
   *  attempted. 
   */
  gov_cca_CCAExceptionType_PortAlreadyDefined  = 3,

  /**
   * Attempt to getPort, getPortNonblocking, or releasePort
   * with a port named that is not connected. 
   */
  gov_cca_CCAExceptionType_PortNotConnected    = 4,

  /**
   * Redundant attempt to release a Port. 
   */
  gov_cca_CCAExceptionType_PortNotInUse        = 5,

  /**
   * Attempt to unregister a Port that is still being used. 
   */
  gov_cca_CCAExceptionType_UsesPortNotReleased = 6,

  /**
   * Port name given to createPortInfo is bogus. 
   */
  gov_cca_CCAExceptionType_BadPortName         = 7,

  /**
   * Port class/type given to createPortInfo is bogus. 
   */
  gov_cca_CCAExceptionType_BadPortType         = 8,

  /**
   * Port properties given to createPortInfo is bogus.
   * Note: null is NOT a bogus input, but a fairly common one. 
   */
  gov_cca_CCAExceptionType_BadProperties       = 9,

  /**
   * PortInfo given in port add/register call is bogus or null. 
   */
  gov_cca_CCAExceptionType_BadPortInfo         = 10,

  /**
   * Services implementation failed to allocate memory. 
   */
  gov_cca_CCAExceptionType_OutOfMemory         = 11,

  /**
   * Port (or function within it) died on a remote error. 
   */
  gov_cca_CCAExceptionType_NetworkError        = 12

};

#ifdef __cplusplus
}
#endif
#endif
