/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.AssertionException;
import gov.llnl.babel.symbols.AssertionExpression;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import java.util.ArrayList;

public class UnaryExpression
extends AssertionExpression {
    private int d_op = 0;
    private AssertionExpression d_expression = null;
    public static final int NOOP = 0;
    public static final int COMPLEMENT = 1;
    public static final int IS = 2;
    public static final int MINUS = 3;
    public static final int NOT = 4;
    public static final int PLUS = 5;
    private static final int MIN_OP_VALUE = 1;
    private static final int MAX_OP_VALUE = 5;
    private static final String[] s_symbol = new String[]{"", "~", "is", "-", "not", "+"};

    public UnaryExpression(int op, AssertionExpression expr) throws AssertionException {
        super(false);
        if (op <= 1 || op > 5) {
            throw new AssertionException("UnaryExpression", "Operator value \"" + op + "\" invalid, must be in " + 1 + "..." + 5 + ".");
        }
        if (expr == null) {
            throw new AssertionException("UnaryExpression", "Cannot instantiate if the expr is null.");
        }
        this.d_op = op;
        this.d_expression = expr;
    }

    public int getOp() {
        return this.d_op;
    }

    public String getOpSymbol() {
        return s_symbol[this.d_op];
    }

    public AssertionExpression getExpression() {
        return this.d_expression;
    }

    private boolean isPure() {
        String litname;
        String classname = this.d_expression.getClass().getName();
        return classname.equals(litname = "gov.llnl.babel.symbols.IdentifierLiteral") && this.d_expression.hasPure();
    }

    public boolean hasPure() {
        return this.d_op == 2 && this.isPure();
    }

    public boolean hasResult() {
        return this.d_expression.hasResult();
    }

    public boolean hasMethodCall() {
        return this.d_expression.hasMethodCall();
    }

    public boolean hasReservedMethod(int type) {
        return this.d_expression.hasReservedMethod(type);
    }

    public boolean hasUnreservedMethod(boolean any) {
        return this.d_expression.hasUnreservedMethod(any);
    }

    public boolean requiresExtendableContext() {
        return this.d_expression.requiresExtendableContext();
    }

    public boolean requiresMethodContext() {
        return this.d_expression.requiresMethodContext();
    }

    private String getIncompatibleMessage(String desc) {
        return "The expression must return " + desc + " value to apply the unary " + this.getOpSymbol() + " operation.";
    }

    private void setNumericType() throws AssertionException {
        if (this.d_expression.returnIsInteger()) {
            this.setReturnToInteger();
        } else if (this.d_expression.returnIsLong()) {
            this.setReturnToLong();
        } else if (this.d_expression.returnIsFloat()) {
            this.setReturnToFloat();
        } else if (this.d_expression.returnIsDouble()) {
            this.setReturnToDouble();
        } else if (this.d_expression.returnIsFComplex()) {
            this.setReturnToFComplex();
        } else if (this.d_expression.returnIsDComplex()) {
            this.setReturnToDComplex();
        } else {
            throw new AssertionException(this.getIncompatibleMessage("a numeric"));
        }
    }

    protected void validateSemantics(Extendable ext, Method m) throws AssertionException {
        this.d_expression.validateExpression(ext, m);
        switch (this.d_op) {
            case 1: {
                if (this.d_expression.returnIsInteger() || this.d_expression.returnIsLong()) {
                    this.setReturnType(this.d_expression.getReturnTypeValue());
                    break;
                }
                throw new AssertionException(this.getExceptionPrefix(ext, m), this.getIncompatibleMessage("an integer or long"));
            }
            case 2: {
                if (this.isPure()) {
                    this.setReturnToBoolean();
                    break;
                }
                throw new AssertionException(this.getExceptionPrefix(ext, m), this.getIncompatibleMessage("a \"pure\" identifier"));
            }
            case 3: {
                this.setNumericType();
                break;
            }
            case 4: {
                if (this.d_expression.returnIsBoolean()) {
                    this.setReturnToBoolean();
                    break;
                }
                throw new AssertionException(this.getExceptionPrefix(ext, m), this.getIncompatibleMessage("a boolean"));
            }
            case 5: {
                this.setNumericType();
                break;
            }
            default: {
                throw new AssertionException(this.getExceptionPrefix(ext, m), "Invalid or unrecognized unary operator value \"" + this.d_op + "\" with " + "subexpression return type \"" + this.d_expression.getReturnTypeName() + "\".");
            }
        }
    }

    public ArrayList getArrayIterMacros(String epvVar, int[] startInd) {
        return this.d_expression.getArrayIterMacros(epvVar, startInd);
    }

    public int getNumArrayIterMacrosByType(char type) {
        return this.d_expression.getNumArrayIterMacrosByType(type);
    }

    public String cExpression(String epvVar, int[] startInd) {
        String expr = null;
        switch (this.d_op) {
            case 1: {
                expr = this.getOpSymbol() + this.d_expression.cExpression(epvVar, startInd);
                break;
            }
            case 2: {
                expr = "";
                break;
            }
            case 3: {
                expr = this.getOpSymbol() + this.d_expression.cExpression(epvVar, startInd);
                break;
            }
            case 4: {
                expr = "!" + this.d_expression.cExpression(epvVar, startInd);
                break;
            }
            case 5: {
                expr = this.getOpSymbol() + this.d_expression.cExpression(epvVar, startInd);
            }
        }
        return expr;
    }

    public String toString() {
        String expr = this.getOpSymbol() + " " + this.d_expression;
        return this.hasParens() ? "(" + expr + ")" : expr;
    }
}

