/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.ucxx;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.LevelComparator;
import gov.llnl.babel.backend.ucxx.Cxx;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class CxxStubSource {
    private Extendable d_ext = null;
    private LanguageWriterForCxx d_writer = null;
    private String d_self = null;

    public CxxStubSource(Extendable ext) {
        this.d_ext = ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void generateCode() throws CodeGenerationException {
        String filename = Cxx.generateFilename(this.d_ext.getSymbolID(), 3, 2);
        this.d_self = this.d_ext.isInterface() ? "loc_self->d_object" : "loc_self";
        try {
            this.d_writer = Cxx.createSource(this.d_ext, 3, "STUBSRCS");
            this.d_writer.println();
            this.writeIncludes();
            this.writeUserDefinedMethods();
            this.writeConstructors();
            this.writeCastingOperators();
            if (!this.d_ext.isInterface()) {
                this.writeDynamicImplStuff();
            }
            Object var3_2 = null;
            if (this.d_writer == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.d_writer == null) throw throwable;
            this.d_writer.close();
            this.d_writer = null;
            throw throwable;
        }
        this.d_writer.close();
        this.d_writer = null;
    }

    private void writeIncludes() throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.generateInclude(Cxx.generateFilename(this.d_ext.getSymbolID(), 3, 1), true);
        this.d_writer.generateInclude(Cxx.generateFilename("sidl.BaseInterface", 3, 1), true);
        this.d_writer.generateInclude(Cxx.generateFilename("sidl.BaseClass", 3, 1), true);
        if (this.d_ext.hasExceptionThrowingMethod(true)) {
            this.d_writer.generateInclude(Cxx.generateFilename("sidl.BaseException", 3, 1), true);
        }
        this.d_writer.generateInclude("sidl_String.h", false);
        if (!BabelConfiguration.isSIDLBaseClass(id)) {
            this.d_writer.generateInclude("babel_config.h", false);
            this.d_writer.printlnUnformatted("#ifdef SIDL_DYNAMIC_LIBRARY");
            this.d_writer.printlnUnformatted("#include <stdio.h>");
            this.d_writer.printlnUnformatted("#include <stdlib.h>");
            this.d_writer.generateInclude("sidl_Loader.hh", false);
            this.d_writer.generateInclude("sidl_DLL.hh", false);
            this.d_writer.printlnUnformatted("#endif");
        }
        Cxx.generateSourceIncludes(this.d_writer, this.d_ext);
        this.d_writer.println();
    }

    private void writeConstructors() {
        SymbolID id = this.d_ext.getSymbolID();
        String extName = IOR.getExternalName(id);
        String fullName = Cxx.getObjectName(id);
        String fullNameWithoutLeadingColons = Cxx.getSymbolNameWithoutLeadingColons(id, "");
        String name = id.getShortName();
        String ior_ptr = "void*";
        if (!this.d_ext.isAbstract()) {
            this.d_writer.writeCommentLine("static constructor");
            this.d_writer.println(fullName);
            this.d_writer.println(fullNameWithoutLeadingColons + "::_create() {");
            this.d_writer.tab();
            this.d_writer.println(Cxx.getObjectName(id) + " self( (*_get_ext()->createObject)(), false );");
            this.d_writer.println("return self;");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
        this.d_writer.writeCommentLine("copy constructor");
        this.d_writer.println(fullNameWithoutLeadingColons + "::" + name + " ( const " + fullName + "& original ) {");
        this.d_writer.tab();
        this.d_writer.println("d_self = original._cast(\"" + id.getFullName() + "\");");
        this.d_writer.println("d_weak_reference = original.d_weak_reference;");
        this.d_writer.println("if (d_self != 0 ) {");
        this.d_writer.tab();
        this.d_writer.println("addRef();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeCommentLine("assignment operator");
        this.d_writer.println(fullName + "&");
        this.d_writer.println(fullNameWithoutLeadingColons + "::operator=( const " + fullName + "& rhs ) {");
        this.d_writer.tab();
        this.d_writer.println("if ( d_self != rhs.d_self ) {");
        this.d_writer.tab();
        this.d_writer.println("if ( d_self != 0 ) {");
        this.d_writer.tab();
        this.d_writer.println("deleteRef();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("d_self = rhs._cast(\"" + id.getFullName() + "\");");
        this.d_writer.println("d_weak_reference = rhs.d_weak_reference;");
        this.d_writer.println("if ( d_self != 0 ) {");
        this.d_writer.tab();
        this.d_writer.println("addRef();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("return *this;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeCastingOperators() {
        SymbolID id = this.d_ext.getSymbolID();
        String extName = IOR.getExternalName(id);
        String fullName = Cxx.getObjectName(id);
        String fullNameWithoutLeadingColons = Cxx.getSymbolNameWithoutLeadingColons(id, "");
        String name = id.getShortName();
        this.d_writer.writeCommentLine("conversion from ior to C++ class");
        this.d_writer.println(fullNameWithoutLeadingColons + "::" + name + " ( " + fullName + "::ior_t* ior ) ");
        this.d_writer.println("   : StubBase(" + Cxx.reinterpretCast("void*", "ior") + ") { }");
        this.d_writer.println();
        this.d_writer.writeCommentLine("Alternate constructor: does not call addRef()");
        this.d_writer.writeCommentLine("(sets d_weak_reference=isWeak)");
        this.d_writer.writeCommentLine("For internal use by Impls (fixes bug#275)");
        this.d_writer.println(fullNameWithoutLeadingColons + "::" + name + " ( " + fullName + "::ior_t* ior, bool isWeak ) : ");
        this.d_writer.println("StubBase(" + Cxx.reinterpretCast("void*", "ior") + ", isWeak){ ");
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeCommentLine("protected method that implements casting");
        this.d_writer.println("void* " + fullNameWithoutLeadingColons + "::_cast(const char* type) const");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("ior_t* loc_self = " + Cxx.reinterpretCast("ior_t*", "this->d_self") + ";");
        this.d_writer.println("void* ptr = 0;");
        this.d_writer.println("if ( loc_self != 0 ) {");
        this.d_writer.tab();
        this.d_writer.print("ptr = ");
        if (this.d_ext.isInterface()) {
            this.d_writer.print(Cxx.reinterpretCast("void*", "(*loc_self->d_epv->f__cast)(loc_self->d_object, type)"));
        } else {
            this.d_writer.print(Cxx.reinterpretCast("void*", "(*loc_self->d_epv->f__cast)(loc_self, type)"));
        }
        this.d_writer.println(";");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("return ptr;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeDynamicImplStuff() throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        String extName = IOR.getExternalName(id);
        String fullName = Cxx.getObjectName(id);
        String fullNameWithoutLeadingColons = Cxx.getSymbolNameWithoutLeadingColons(id, "");
        this.d_writer.writeCommentLine("Static data type");
        this.d_writer.println("const " + fullName + "::ext_t * " + fullNameWithoutLeadingColons + "::s_ext = 0;");
        this.d_writer.println();
        this.d_writer.writeCommentLine("private static method to get static data type");
        this.d_writer.println("const " + fullName + "::ext_t *");
        this.d_writer.println(fullNameWithoutLeadingColons + "::_get_ext()");
        this.d_writer.println("  throw ( " + Cxx.prependGlobalUCxx() + "::sidl::NullIORException)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("if (! s_ext ) {");
        this.d_writer.tab();
        if (BabelConfiguration.isSIDLBaseClass(id)) {
            this.d_writer.println("s_ext = " + IOR.getExternalFunc(id) + "();");
        } else {
            this.d_writer.printlnUnformatted("#ifdef SIDL_STATIC_LIBRARY");
            this.d_writer.println("s_ext = " + IOR.getExternalFunc(id) + "();");
            this.d_writer.printlnUnformatted("#else");
            this.d_writer.println("" + Cxx.prependGlobalUCxx() + "::sidl::DLL dll = " + Cxx.prependGlobalUCxx() + "::sidl::DLL::_create();");
            this.d_writer.println("const ext_t *(*dll_f)(void);");
            this.d_writer.writeCommentLine("check global namespace for symbol first");
            this.d_writer.println("if (dll._not_nil() && dll.loadLibrary(\"main:\", TRUE, FALSE)) {");
            this.d_writer.tab();
            this.d_writer.println("dll_f =");
            this.d_writer.tab();
            this.d_writer.print("(const ext_t *(*)(void)) ");
            this.d_writer.println("dll.lookupSymbol(");
            this.d_writer.tab();
            this.d_writer.println("\"" + IOR.getExternalFunc(id) + "\");");
            this.d_writer.backTab();
            this.d_writer.backTab();
            this.d_writer.println("s_ext = (dll_f ? (*dll_f)() : NULL);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (!s_ext) {");
            this.d_writer.tab();
            this.d_writer.println("dll = " + Cxx.prependGlobalUCxx() + "::sidl::Loader::findLibrary(\"" + id.getFullName() + "\",");
            this.d_writer.tab();
            this.d_writer.println("\"ior/impl\", " + Cxx.prependGlobalUCxx() + "::sidl::Scope_SCLSCOPE,");
            this.d_writer.println("" + Cxx.prependGlobalUCxx() + "::sidl::Resolve_SCLRESOLVE);");
            this.d_writer.backTab();
            this.d_writer.println("if (dll._not_nil()) {");
            this.d_writer.tab();
            this.d_writer.println("dll_f =");
            this.d_writer.tab();
            this.d_writer.print("(const ext_t *(*)(void)) ");
            this.d_writer.println("dll.lookupSymbol(");
            this.d_writer.tab();
            this.d_writer.println("\"" + IOR.getExternalFunc(id) + "\");");
            this.d_writer.backTab();
            this.d_writer.backTab();
            this.d_writer.println("s_ext = (dll_f ? (*dll_f)() : NULL);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (!s_ext) {");
            this.d_writer.tab();
            this.d_writer.disableLineBreak();
            this.d_writer.println("throw " + Cxx.prependGlobalUCxx() + "::sidl::NullIORException( ::std::string (");
            this.d_writer.tab();
            this.d_writer.println("\"cannot find implementation for " + id.getFullName() + "; please set SIDL_DLL_PATH\"");
            this.d_writer.backTab();
            this.d_writer.println("));");
            this.d_writer.enableLineBreak();
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.printlnUnformatted("#endif");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("return s_ext;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeUserDefinedMethods() throws CodeGenerationException {
        Method method;
        this.d_writer.beginBoldComment();
        this.d_writer.println("User Defined Methods");
        this.d_writer.endBoldComment();
        Iterator m = null;
        m = this.d_ext.getStaticMethods(true).iterator();
        while (m.hasNext()) {
            method = (Method)m.next();
            if (Cxx.inlineStub(method)) continue;
            this.generateMethodDispatch(method, "user defined static method", true);
            this.d_writer.println();
            if (!method.hasRarray()) continue;
            this.generateMethodDispatch(method, "user defined static method", false);
            this.d_writer.println();
        }
        m = this.d_ext.getNonstaticMethods(true).iterator();
        while (m.hasNext()) {
            method = (Method)m.next();
            if (Cxx.inlineStub(method)) continue;
            this.generateMethodDispatch(method, "user defined non-static method.", true);
            this.d_writer.println();
            if (!method.hasRarray()) continue;
            this.generateMethodDispatch(method, "user defined non-static method", false);
            this.d_writer.println();
        }
        this.d_writer.beginBoldComment();
        this.d_writer.println("End User Defined Methods");
        this.d_writer.println("(everything else in this file is specific to");
        this.d_writer.println(" Babel's C++ bindings)");
        this.d_writer.endBoldComment();
    }

    private void generateMethodDispatch(Method m, String altcomment, boolean rarrays) throws CodeGenerationException {
        if (m == null) {
            return;
        }
        ArrayList vArgs = m.getArgumentList();
        int nargs = vArgs.size();
        String extra_close_paren = "";
        String shortMethodName = m.getShortMethodName();
        String longMethodName = m.getLongMethodName();
        String className = this.d_ext.getSymbolID().getShortName();
        Comment comment = m.getComment();
        BabelConfiguration s_babel_config = BabelConfiguration.getInstance();
        Type return_type = m.getReturnType();
        SymbolID id = return_type.getSymbolID();
        this.d_writer.writeComment(comment, altcomment);
        if (shortMethodName.equals(className)) {
            shortMethodName = "f_" + shortMethodName;
            System.out.println("WARNING: gov.llnl.babel.backend.UCxx.CxxStubSource: sidl / C++ conflict!");
            System.out.println("         methodName == className is not allowed in C++");
            System.out.println("         (this is restricted to constructors in C++)");
            System.out.println("         changing to " + className + "::" + shortMethodName + "()");
        }
        this.d_writer.println(Cxx.generateFunctionDeclaration(m, this.d_ext, this.d_self, rarrays));
        this.d_writer.println();
        this.d_writer.println("{");
        this.d_writer.tab();
        if (!m.isStatic() && s_babel_config.makeCxxCheckNullIOR()) {
            this.d_writer.println("if ( d_self == 0 ) {");
            this.d_writer.tab();
            this.d_writer.println("throw " + Cxx.prependGlobalUCxx() + "::sidl::NullIORException( ::std::string (");
            this.d_writer.tab();
            this.d_writer.disableLineBreak();
            this.d_writer.println("\"Null IOR Pointer in \\\"" + Cxx.getMethodStubName(this.d_ext.getSymbolID(), shortMethodName) + "()\\\"\"");
            this.d_writer.enableLineBreak();
            this.d_writer.backTab();
            this.d_writer.println("));");
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.println(Cxx.generateInitialization(m, this.d_ext, this.d_self));
        if (!m.isStatic() && (shortMethodName.equals("addRef") || shortMethodName.equals("deleteRef"))) {
            this.d_writer.println("if ( !d_weak_reference ) {");
            this.d_writer.tab();
        }
        this.d_writer.println(Cxx.generatePreIORCall(m, this.d_ext, this.d_self, false, rarrays));
        this.d_writer.println(Cxx.generateIORCall(m, this.d_ext, this.d_self, false, rarrays));
        if (m.getThrows().size() > 0) {
            this.d_writer.println("if (_exception != 0 ) {");
            this.d_writer.tab();
            this.d_writer.println("void * _p = 0;");
            Object[] exceptions = m.getThrows().toArray();
            Arrays.sort(exceptions, new LevelComparator(SymbolTable.getInstance()));
            for (int i = 0; i < exceptions.length; ++i) {
                SymbolID exid = (SymbolID)exceptions[i];
                this.d_writer.println("if ( (_p=(*(_exception->d_epv->f__cast))(_exception, \"" + exid.getFullName() + "\")) != 0 ) {");
                this.d_writer.tab();
                this.d_writer.println(IOR.getObjectName(exid) + " * _realtype = " + Cxx.reinterpretCast(IOR.getObjectName(exid) + "*", "_p") + ";");
                this.d_writer.writeCommentLine("Note: alternate constructor does not increment refcount.");
                this.d_writer.println("throw " + Cxx.getObjectName(exid) + "( _realtype, false );");
                this.d_writer.backTab();
                this.d_writer.println("}");
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.println(Cxx.generatePostIORCall(m, this.d_ext, this.d_self, rarrays));
        if (!m.isStatic() && (shortMethodName.equals("addRef") || shortMethodName.equals("deleteRef"))) {
            if (shortMethodName.equals("deleteRef")) {
                this.d_writer.println("d_self = 0;");
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        if (return_type.getType() != 0) {
            this.d_writer.println("return _result;");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }
}

