/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.ucxx;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.ucxx.Cxx;
import gov.llnl.babel.backend.ucxx.CxxStubHeader;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import java.io.IOException;
import java.util.Iterator;

public class CxxImplHeader {
    private Extendable d_ext = null;
    private LanguageWriterForCxx d_writer = null;
    private CodeSplicer d_splicer = null;

    public CxxImplHeader(Extendable ext) {
        this.d_ext = ext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void generateCode() throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        int type = this.d_ext.getSymbolType();
        String filename = Cxx.generateFilename(id, 1, 1);
        try {
            block4: {
                try {
                    this.d_splicer = FileManager.getInstance().getCodeSplicer(id, type, filename);
                    this.d_writer = Cxx.createHeader(this.d_ext, 1, "IMPLHDRS");
                    this.d_splicer.setLineRedirector(this.d_writer);
                    this.d_writer.println();
                    this.d_writer.openHeaderGuard(filename);
                    Cxx.generateDependencyIncludes(this.d_writer, this.d_ext, false);
                    this.spliceIncludes();
                    Cxx.nestImplPackagesInNamespaces(this.d_writer, this.d_ext);
                    this.writeClassBeginning();
                    this.writeSIDLDefinedMethods();
                    this.writeClassEnd();
                    Cxx.unnestImplPackagesInNamespaces(this.d_writer, this.d_ext);
                    this.writeMiscStuff();
                    this.d_writer.closeHeaderGuard();
                    if (!this.d_splicer.hasUnusedSymbolEdits()) break block4;
                    this.d_writer.println();
                    this.d_writer.printlnUnformatted("#error File has unused splicer blocks.");
                    this.d_writer.beginBlockComment(true);
                    this.d_writer.println("================= BEGIN UNREFERENCED METHOD(S) ================");
                    this.d_writer.println("The following code segment(s) belong to unreferenced method(s).");
                    this.d_writer.println("This can result from a method rename/removal in the sidl file.");
                    this.d_writer.println("Move or remove the code in order to compile cleanly.");
                    this.d_writer.println("================== END UNREFERENCED METHOD(S) =================");
                    this.d_splicer.outputUnusedSymbolEdits(this.d_writer.getPrintWriter());
                    this.d_writer.writeCommentLine("================== END UNREFERENCED METHOD(S) =================");
                }
                catch (IOException ex) {
                    throw new CodeGenerationException("IOException : " + ex.getMessage());
                }
            }
            Object var6_4 = null;
            if (this.d_writer == null) return;
            this.d_writer.close();
            this.d_writer = null;
            return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.d_writer == null) throw throwable;
            this.d_writer.close();
            this.d_writer = null;
            throw throwable;
        }
    }

    private void spliceIncludes() {
        this.d_writer.println();
        String includes = this.d_ext.getSymbolID().getFullName() + "." + "_includes";
        this.d_splicer.splice(includes, this.d_writer, "includes or arbitrary code");
        this.d_writer.println();
    }

    private void writeClassBeginning() throws CodeGenerationException {
        String name = this.d_ext.getSymbolID().getShortName();
        SymbolID id = this.d_ext.getSymbolID();
        String splicer_symbol_impl = this.d_ext.getSymbolID().getFullName() + "._implementation";
        String splicer_symbol_inherit = this.d_ext.getSymbolID().getFullName() + "._inherits";
        this.d_writer.writeComment(this.d_ext, true);
        this.d_writer.println("class " + name + "_impl : public virtual " + Cxx.getSymbolName(this.d_ext.getSymbolID()) + " ");
        this.d_splicer.splice(splicer_symbol_inherit, this.d_writer, "optional inheritance here");
        this.d_writer.println("{");
        this.writeSuperClass();
        this.d_writer.println();
        this.d_writer.writeCommentLine("All data marked protected will be accessable by ");
        this.d_writer.writeCommentLine("descendant Impl classes");
        this.d_writer.println("protected:");
        this.d_writer.tab();
        this.d_writer.println();
        this.d_splicer.splice(splicer_symbol_impl, this.d_writer, "additional details");
        this.d_writer.println();
        this.d_writer.backTab();
        this.d_writer.println("public:");
        this.d_writer.tab();
        this.d_writer.writeCommentLine("default constructor, shouldn't be used (required)");
        this.d_writer.println(name + "_impl() : StubBase(0,true) { } ");
        this.d_writer.println();
        this.d_writer.tab();
        this.d_writer.writeCommentLine("sidl constructor (required)");
        this.d_writer.writeCommentLine("Note: alternate Skel constructor doesn't call addref()");
        this.d_writer.writeCommentLine("(fixes bug #275)");
        if (this.hasOverwrittenClassMethods()) {
            this.d_writer.println(name + "_impl( " + IOR.getObjectName(id) + " * s ) : StubBase(s,true), super(s, " + id.getShortName() + "::_get_ext()) { _ctor(); }");
        } else {
            this.d_writer.println(name + "_impl( " + IOR.getObjectName(id) + " * s ) : StubBase(s,true) { _ctor(); }");
        }
        this.d_writer.println();
        this.d_writer.writeCommentLine("user defined construction");
        this.d_writer.println("void _ctor();");
        this.d_writer.println();
        this.d_writer.writeCommentLine("virtual destructor (required)");
        this.d_writer.println("virtual ~" + name + "_impl() { _dtor(); }");
        this.d_writer.println();
        this.d_writer.writeCommentLine("user defined destruction");
        this.d_writer.println("void _dtor();");
        this.d_writer.println();
        this.d_writer.writeCommentLine("static class initializer");
        this.d_writer.println("static void _load();");
        this.d_writer.println();
    }

    private boolean hasOverwrittenClassMethods() throws CodeGenerationException {
        if (!this.d_ext.isInterface()) {
            try {
                Class cls = (Class)this.d_ext;
                if (cls.hasOverwrittenMethods()) {
                    return true;
                }
            }
            catch (Exception ex) {
                throw new CodeGenerationException("Attempted to cast non Class to Class");
            }
        }
        return false;
    }

    private void writeClassEnd() {
        String name = this.d_ext.getSymbolID().getShortName();
        this.d_writer.backTab();
        this.d_writer.print("};  ");
        this.d_writer.writeCommentLine("end class " + name + "_impl");
        this.d_writer.println();
    }

    private void writeMiscStuff() {
        String splicer_symbol = this.d_ext.getSymbolID().getFullName() + "._misc";
        this.d_splicer.splice(splicer_symbol, this.d_writer, "miscellaneous things");
        this.d_writer.println();
    }

    private void writeSuperClass() throws CodeGenerationException {
        if (!this.d_ext.isInterface()) {
            try {
                Class cls = (Class)this.d_ext;
                if (cls.hasOverwrittenMethods()) {
                    CxxStubHeader.generateSupers(cls, this.d_writer);
                    this.d_writer.println();
                    this.d_writer.println("private:");
                    this.d_writer.writeCommentLine("Use this to dispatch to super functions.");
                    this.d_writer.println("Super super;");
                    this.d_writer.println();
                }
            }
            catch (Exception ex) {
                throw new CodeGenerationException("Attempted to cast non Class to Class");
            }
        }
    }

    private void writeSIDLDefinedMethods() throws CodeGenerationException {
        Method method;
        this.d_writer.backTab();
        this.d_writer.println("public:");
        this.d_writer.tab();
        Iterator m = null;
        m = this.d_ext.getStaticMethods(false).iterator();
        while (m.hasNext()) {
            method = (Method)m.next();
            Cxx.generateMethodSignature(this.d_writer, method, "user defined static method", 1, true);
        }
        this.d_writer.println();
        m = this.d_ext.getNonstaticMethods(false).iterator();
        while (m.hasNext()) {
            method = (Method)m.next();
            if (method.isAbstract()) continue;
            Cxx.generateMethodSignature(this.d_writer, method, "user defined non-static method.", 1, true);
        }
    }
}

