/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.jdk;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.jdk.Java;
import gov.llnl.babel.backend.writers.LanguageWriterForJava;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.SymbolUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClientJava {
    private static final int INTERFACE = 0;
    private static final int WRAPPER = 1;
    private static final int CLASS = 2;
    private static final int MAX_DIM = 7;
    private LanguageWriterForJava d_writer;

    public static void generateCode(Symbol symbol, LanguageWriterForJava writer) throws CodeGenerationException {
        ClientJava source = new ClientJava(writer);
        source.generateCode(symbol);
    }

    public ClientJava(LanguageWriterForJava writer) {
        this.d_writer = writer;
    }

    public void generateCode(Symbol symbol) throws CodeGenerationException {
        if (symbol == null) {
            throw new CodeGenerationException("Unexpected null symbol object");
        }
        switch (symbol.getSymbolType()) {
            case 12: {
                this.generateExtendable((Extendable)symbol);
                break;
            }
            case 11: {
                this.generateEnumeration((Enumeration)symbol);
                break;
            }
            case 13: {
                this.generateExtendable((Extendable)symbol);
                break;
            }
            case 14: {
                break;
            }
            default: {
                throw new CodeGenerationException("Unsupported symbol type");
            }
        }
    }

    private void generateEnumeration(Enumeration enm) {
        SymbolID id = enm.getSymbolID();
        String file = Java.getClientJavaFile(id);
        this.d_writer.writeBanner(enm, file, false, "Client-side glue code for " + id.getFullName());
        this.writeJavaPackage(id);
        this.d_writer.writeComment(enm, true);
        this.d_writer.println("public interface " + Java.getJavaSymbolName(id) + " {");
        this.d_writer.tab();
        int maxlength = Utilities.getWidth(enm.getEnumerators());
        Iterator e = enm.getIterator();
        while (e.hasNext()) {
            String name = (String)e.next();
            Comment cmt = enm.getEnumeratorComment(name);
            this.d_writer.writeComment(cmt, true);
            this.d_writer.print("public final static int ");
            this.d_writer.printAligned(name, maxlength);
            this.d_writer.print(" = ");
            this.d_writer.print(String.valueOf(enm.getEnumeratorValue(name)));
            this.d_writer.println(";");
            if (cmt == null) continue;
            this.d_writer.println();
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void generateExtendable(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        String file = Java.getClientJavaFile(id);
        this.d_writer.writeBanner(ext, file, false, "Client-side glue code for " + id.getFullName());
        this.writeJavaPackage(id);
        this.d_writer.writeComment(ext, true);
        if (ext.isInterface()) {
            this.d_writer.println("public interface " + Java.getJavaSymbolName(id) + " extends");
            this.d_writer.tab();
            this.d_writer.print(Java.getJavaBaseInterface());
            Collection parents = ext.getParentInterfaces(false);
            if (parents == null || parents.isEmpty()) {
                this.d_writer.println();
            } else {
                this.d_writer.println(",");
                Iterator p = parents.iterator();
                while (p.hasNext()) {
                    Interface i = (Interface)p.next();
                    this.d_writer.print(Java.getFullJavaSymbolName(i.getSymbolID()));
                    if (p.hasNext()) {
                        this.d_writer.print(",");
                    }
                    this.d_writer.println();
                }
            }
            this.d_writer.backTab();
            this.d_writer.println("{");
            this.d_writer.tab();
            List local_methods = (List)ext.getMethods(false);
            Iterator m = local_methods.iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                this.generateMethod(method, 0, false);
                this.d_writer.println();
            }
            this.writeWrapperClass(ext);
            this.writeHolderClass(id);
            this.writeObjectArray(ext);
            this.d_writer.backTab();
            this.d_writer.println("}");
        } else {
            Class cls = (Class)ext;
            this.d_writer.print("public ");
            if (ext.isAbstract()) {
                // empty if block
            }
            this.d_writer.println("class " + Java.getJavaSymbolName(id) + " extends");
            this.d_writer.tab();
            Class c = cls.getParentClass();
            if (c == null) {
                this.d_writer.println(Java.getJavaBaseClass() + " implements");
            } else {
                this.d_writer.println(Java.getFullJavaSymbolName(c.getSymbolID()) + " implements");
            }
            Collection parents = ext.getParentInterfaces(true);
            Iterator p = parents.iterator();
            while (p.hasNext()) {
                Interface i = (Interface)p.next();
                this.d_writer.print(Java.getFullJavaSymbolName(i.getSymbolID()));
                if (p.hasNext()) {
                    this.d_writer.print(",");
                }
                this.d_writer.println();
            }
            this.d_writer.backTab();
            this.d_writer.println("{");
            this.d_writer.tab();
            this.writeRegisterFunction(id);
            if (!cls.isAbstract()) {
                this.d_writer.writeComment("Default constructor for the class.", true);
                this.d_writer.println("public " + Java.getJavaSymbolName(id) + "() {");
                this.d_writer.tab();
                this.d_writer.println("super(_create_ior());");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.println();
                this.d_writer.writeComment("Private method to create IOR reference.", true);
                this.d_writer.println("private static native long _create_ior();");
                this.d_writer.println();
            } else {
                this.d_writer.writeComment("Default constructor for the class.", true);
                this.d_writer.println("private " + Java.getJavaSymbolName(id) + "() {");
                this.d_writer.tab();
                this.d_writer.println("super(_create_ior());");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.println();
                this.d_writer.writeComment("Private method to create IOR reference.", true);
                this.d_writer.println("private static native long _create_ior();");
                this.d_writer.println();
            }
            this.d_writer.writeComment("Public constructor for an existing IOR.", true);
            this.d_writer.println("public " + Java.getJavaSymbolName(id) + "(long ior) {");
            this.d_writer.tab();
            this.d_writer.println("super(ior);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            List local_methods = null;
            local_methods = ext.isAbstract() ? (List)ext.getAbstractAndLocalMethods() : (List)ext.getMethods(false);
            Iterator m = local_methods.iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                this.generateMethod(method, 2, false);
                this.d_writer.println();
            }
            Collection overwritten = cls.getOverwrittenClassMethods();
            Iterator m2 = overwritten.iterator();
            while (m2.hasNext()) {
                Method method = (Method)m2.next();
                this.generateMethod(method, 2, true);
                this.d_writer.println();
            }
            this.writeCastMethod(ext);
            if (ext.isAbstract()) {
                this.writeWrapperClass(ext);
            }
            this.writeHolderClass(id);
            this.writeObjectArray(ext);
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
    }

    private void writeJavaPackage(SymbolID id) {
        String pkg = SymbolUtilities.getParentPackage(id.getFullName());
        this.d_writer.println("package " + pkg + ";");
        this.d_writer.println();
    }

    private void writeRegisterFunction(SymbolID id) {
        this.d_writer.writeComment("Register the JNI native routines.", false);
        this.d_writer.println("static {");
        this.d_writer.tab();
        this.d_writer.println(Java.getJavaBaseClass() + "._registerNatives(\"" + id.getFullName() + "\");");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeCastMethod(Extendable ext) {
        SymbolID id = ext.getSymbolID();
        String name = Java.getFullJavaSymbolName(id);
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("");
        this.d_writer.println("Cast this object to the specified sidl name.  If the cast is invalid,");
        this.d_writer.println("then return null.  If the cast is successful, then the returned object");
        this.d_writer.println("can be cast to the proper Java type using a standard Java cast.");
        this.d_writer.println("");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("public static " + BabelConfiguration.getBaseInterface() + " _cast(" + Java.getJavaBaseClass() + " obj) {");
        this.d_writer.tab();
        this.d_writer.println(BabelConfiguration.getBaseInterface() + " cast = null;");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("");
        this.d_writer.println("Cast this object to the specified type.  If the cast is valid, then");
        this.d_writer.println("search for the matching Java type.");
        this.d_writer.println("");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("long ior = obj._cast_ior(\"" + name + "\");");
        this.d_writer.println("if (ior != 0) {");
        this.d_writer.tab();
        this.d_writer.println("Class java_class = null;");
        if (ext.isInterface()) {
            this.d_writer.println("try {");
            this.d_writer.tab();
            this.d_writer.println("java_class = Class.forName(\"" + name + "$Wrapper\");");
            this.d_writer.println("} catch (Exception ex) {");
            this.d_writer.tab();
            this.d_writer.println("ex.printStackTrace(System.err);     ");
            this.d_writer.backTab();
            this.d_writer.println("}");
        } else {
            this.d_writer.println("try {");
            this.d_writer.tab();
            this.d_writer.println("java_class = Class.forName(\"" + name + "\");");
            this.d_writer.println("} catch (Exception ex) {");
            this.d_writer.tab();
            this.d_writer.println("ex.printStackTrace(System.err);     ");
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.println("");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("* If we found the class, then create a new instance using the sidl IOR.");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("if (java_class != null) {");
        this.d_writer.println("Class[]  sigs = new Class[]  { java.lang.Long.TYPE     };");
        this.d_writer.println("Object[] args = new Object[] { new java.lang.Long(ior) };");
        this.d_writer.println("try {");
        this.d_writer.tab();
        this.d_writer.println("java.lang.reflect.Constructor ctor = java_class.getConstructor(sigs);");
        this.d_writer.println("cast = (" + BabelConfiguration.getBaseInterface() + ") ctor.newInstance(args);");
        this.d_writer.println("cast.addRef();");
        this.d_writer.println("} catch (Exception ex) {");
        this.d_writer.tab();
        this.d_writer.println("ex.printStackTrace(System.err);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("return (" + BabelConfiguration.getBaseInterface() + ") cast;");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("");
    }

    private void writeHolderClass(SymbolID id) {
        String holder = Java.getHolderName();
        String holdee = Java.getFullJavaSymbolName(id).replace('$', '.');
        this.d_writer.writeComment("Holder class for inout and out arguments.", true);
        this.d_writer.println("public static class " + holder + " {");
        this.d_writer.tab();
        this.d_writer.println("private " + holdee + " d_obj;");
        this.d_writer.println();
        this.d_writer.writeComment("Create a holder with a null holdee object.", true);
        this.d_writer.println("public " + holder + "() {");
        this.d_writer.tab();
        this.d_writer.println("d_obj = null;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeComment("Create a holder with the specified object.", true);
        this.d_writer.println("public " + holder + "(" + holdee + " obj) {");
        this.d_writer.tab();
        this.d_writer.println("d_obj = obj;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeComment("Set the value of the holdee object.", true);
        this.d_writer.println("public void set(" + holdee + " obj) {");
        this.d_writer.tab();
        this.d_writer.println("d_obj = obj;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeComment("Get the value of the holdee object.", true);
        this.d_writer.println("public " + holdee + " get() {");
        this.d_writer.tab();
        this.d_writer.println("return d_obj;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    void writeWrapperClass(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        String file = Java.getClientJavaFile(id);
        this.d_writer.writeComment("Inner wrapper class that implements interface and abstract class methods.", true);
        if (ext.isInterface()) {
            this.d_writer.println("public static class " + Java.getInterfaceWrapper());
            this.d_writer.tab();
            this.d_writer.println("extends " + Java.getJavaBaseClass());
            this.d_writer.println("implements " + Java.getFullJavaSymbolName(id));
        } else if (ext.isAbstract()) {
            this.d_writer.println("public static class " + Java.getInterfaceWrapper());
            this.d_writer.tab();
            this.d_writer.println("extends " + Java.getFullJavaSymbolName(id));
        } else {
            throw new CodeGenerationException("Class is not interface or abstract, should not generate wrapper class!");
        }
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.writeRegisterFunction(id);
        this.d_writer.writeComment("Class constructor for the wrapper class.", true);
        this.d_writer.println("public " + Java.getInterfaceWrapper() + "(long ior) {");
        this.d_writer.tab();
        this.d_writer.println("super(ior);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        List all_methods = (List)ext.getMethods(true);
        Iterator m = all_methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            if (!ext.isInterface() || !method.isAbstract()) continue;
            this.generateMethod(method, 1, false);
            if (!m.hasNext()) continue;
            this.d_writer.println();
        }
        this.writeCastMethod(ext);
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void generateMethod(Method method, int mode, boolean isSuper) {
        this.d_writer.writeComment(method, true);
        if (isSuper) {
            this.d_writer.print("protected native ");
        } else {
            this.d_writer.print("public ");
            if (mode == 0) {
                this.d_writer.print("abstract ");
            } else if (method.isAbstract()) {
                this.d_writer.print("native ");
            } else if (method.isFinal()) {
                this.d_writer.print("final ");
            } else if (method.isStatic()) {
                this.d_writer.print("static ");
            }
            if (!method.isAbstract()) {
                this.d_writer.print("native ");
            }
        }
        if (isSuper) {
            this.d_writer.print(Java.getJavaReturnType(method.getReturnType()) + " super_" + method.getShortMethodName() + "(");
        } else {
            this.d_writer.print(Java.getJavaReturnType(method.getReturnType()) + " " + method.getShortMethodName() + "(");
        }
        ArrayList args = method.getArgumentList();
        Set thrws = method.getThrows();
        if (args.isEmpty() && thrws.isEmpty()) {
            this.d_writer.println(");");
        } else {
            if (!args.isEmpty()) {
                this.d_writer.println();
                this.d_writer.tab();
                Iterator a = args.iterator();
                while (a.hasNext()) {
                    Argument arg = (Argument)a.next();
                    this.d_writer.print(Java.getJavaFormalArgument(arg));
                    if (!a.hasNext()) continue;
                    this.d_writer.println(",");
                }
            }
            if (thrws.isEmpty()) {
                this.d_writer.println(");");
            } else {
                this.d_writer.println(") throws");
                if (args.isEmpty()) {
                    this.d_writer.tab();
                }
                Iterator t = thrws.iterator();
                while (t.hasNext()) {
                    SymbolID tid = (SymbolID)t.next();
                    this.d_writer.print(Java.getFullJavaSymbolName(tid));
                    if (!SymbolUtilities.isBaseException(tid) && SymbolTable.getInstance().lookupSymbol(tid).isInterface()) {
                        this.d_writer.print(".Wrapper");
                    }
                    this.d_writer.println(t.hasNext() ? "," : ";");
                }
            }
            this.d_writer.backTab();
        }
    }

    private void writeObjectArray(Extendable ext) {
        SymbolID id = ext.getSymbolID();
        String elemType = Java.getFullJavaSymbolName(id);
        this.d_writer.writeComment("Array Class for implementation of Object arrays", true);
        if (elemType.compareTo(BabelConfiguration.getBaseInterface()) == 0) {
            this.writeBaseInterfaceArray(ext);
        } else {
            this.writeOtherClassArray(ext);
        }
    }

    private void writeBaseInterfaceArray(Extendable ext) {
        SymbolID id = ext.getSymbolID();
        String elemType = Java.getFullJavaSymbolName(id);
        this.d_writer.println("public static class Array extends " + Java.getJavaBaseArray() + " {");
        this.d_writer.tab();
        this.d_writer.println();
        this.writeRegisterFunction(id);
        this.d_writer.writeComment("Construct an empty basic array object.", true);
        this.d_writer.println("public Array() {");
        this.d_writer.tab();
        this.d_writer.println("super();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeComment("Create an array using an IOR pointer", true);
        this.d_writer.println("public Array(long array, boolean owner) {");
        this.d_writer.tab();
        this.d_writer.println("super(array, owner);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.writeComment("Create an array with the specified dimension, upper and lower bounds", true);
        this.d_writer.println("public Array(int dim, int[] lower, int[] upper, boolean isRow) {");
        this.d_writer.tab();
        this.d_writer.println("super();");
        this.d_writer.println("reallocate(dim, lower, upper, isRow);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.writeComment("Native routine to get the value at the specified indices", true);
        this.d_writer.println("public native " + elemType + ".Wrapper _get(int i, int j, int k, int l, int m, int n, int o);");
        this.d_writer.writeComment("Native routine to set the value at the specified indices", true);
        this.d_writer.println("public native void _set(int i, int j, int k, int l, int m, int n, int o, " + elemType + " value);");
        this.d_writer.println("");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("Slice returns an array that is <= the orignial array.  It shares");
        this.d_writer.println("data with the orginal array.  ");
        this.d_writer.println("dimen gives the number of dimensions in the result array");
        this.d_writer.println("numElem array gives the number of elements in each dimension");
        this.d_writer.println("srcStart gives the array index to start the result array at");
        this.d_writer.println("srcStride gives the stride of the result array's elements over");
        this.d_writer.println("the original array's elements.");
        this.d_writer.println("See the Babel user's manual for more information.");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("public native Array _slice(int dimen, int[] numElem, int[] srcStart,\t\t\t\t\tint[] srcStride, int[] newStart);  \t");
        this.d_writer.println("");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("Method Copy copies the elements of 'this' to an already existing ");
        this.d_writer.println("array of the same size.  NOT LIKE clone()!!");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("public native void _copy(Array dest);");
        this.d_writer.writeComment("Native routine to reallocate the array data. Bad things happen if bad bounds are passed", true);
        this.d_writer.println("public native void _reallocate(int dim, int[] lower, int[] upper, boolean isRow);");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("");
        this.d_writer.println("Automatically casts this array to an array of the correct dimension. ");
        this.d_writer.println("(You might want to deallocate the original array.  ");
        this.d_writer.println("Argument dimen determines what dimension array to cast this");
        this.d_writer.println("array to.  ");
        this.d_writer.println("");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("");
        this.d_writer.println("public Array _dcast() {");
        this.d_writer.tab();
        this.d_writer.println("try{ ");
        this.d_writer.tab();
        this.d_writer.println("int dimen = _dim();");
        this.d_writer.println("sidl.BaseInterface.Array ret = null;");
        this.d_writer.println("switch (dimen) {");
        this.d_writer.tab();
        this.d_writer.println("case 1:");
        this.d_writer.println("ret = (Array) new sidl.BaseInterface.Array1(get_ior_pointer(), true);");
        this.d_writer.println("_addRef();");
        this.d_writer.println("return ret;");
        this.d_writer.println("case 2:");
        this.d_writer.println("ret = (Array) new sidl.BaseInterface.Array2(get_ior_pointer(), true); ");
        this.d_writer.println("_addRef();");
        this.d_writer.println("return ret;");
        this.d_writer.println("case 3:");
        this.d_writer.println("ret = (Array) new sidl.BaseInterface.Array3(get_ior_pointer(), true);");
        this.d_writer.println("set_owner(false);");
        this.d_writer.println("_addRef();");
        this.d_writer.println("return ret;");
        this.d_writer.println("case 4:");
        this.d_writer.println("ret = (Array) new sidl.BaseInterface.Array4(get_ior_pointer(), true);");
        this.d_writer.println("_addRef();");
        this.d_writer.println("return ret;");
        this.d_writer.println("case 5:");
        this.d_writer.println("ret = (Array) new sidl.BaseInterface.Array5(get_ior_pointer(), true);");
        this.d_writer.println("_addRef();");
        this.d_writer.println("return ret;");
        this.d_writer.println("case 6:");
        this.d_writer.println("ret = (Array) new sidl.BaseInterface.Array6(get_ior_pointer(), true);");
        this.d_writer.println("_addRef();");
        this.d_writer.println("return ret;");
        this.d_writer.println("case 7:");
        this.d_writer.println("ret = (Array) new sidl.BaseInterface.Array7(get_ior_pointer(), true);");
        this.d_writer.println("_addRef();");
        this.d_writer.println("return ret;");
        this.d_writer.println("default:");
        this.d_writer.println("return null;");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("} catch (Exception ex) {");
        this.d_writer.tab();
        this.d_writer.println("return null;\t");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("");
        this.d_writer.println("} ");
        this.d_writer.backTab();
        this.d_writer.writeComment("Native routine to reallocate the array, and copy a java array of objects into it.", true);
        this.d_writer.println("public native void _fromArray(Object[] orray, int dim, int[] lower, boolean isRow);");
        SymbolID aSymbol = new SymbolID(elemType + "$Array", id.getVersion());
        this.writeHolderClass(aSymbol);
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.writeBaseNumberedObjectArrays(ext);
    }

    private void writeOtherClassArray(Extendable ext) {
        SymbolID id = ext.getSymbolID();
        String elemType = Java.getFullJavaSymbolName(id);
        this.d_writer.println("public static class Array extends " + Java.getJavaBaseArray() + " {");
        this.d_writer.println("private " + BabelConfiguration.getBaseInterface() + ".Array a;");
        this.d_writer.tab();
        this.d_writer.println();
        this.d_writer.writeComment("Construct an empty basic array object.", true);
        this.d_writer.println("public Array() {");
        this.d_writer.tab();
        this.d_writer.println("super();");
        this.d_writer.println("a = new " + BabelConfiguration.getBaseInterface() + ".Array();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeComment("Create an array using an IOR pointer", true);
        this.d_writer.println("protected Array(long array, boolean owner) {");
        this.d_writer.tab();
        this.d_writer.println("super(array, owner);");
        this.d_writer.println("a = new " + BabelConfiguration.getBaseInterface() + ".Array(array, owner);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.writeComment("Create an array with the specified dimension, upper and lower bounds", true);
        this.d_writer.println("public Array(int dim, int[] lower, int[] upper, boolean isRow) {");
        this.d_writer.tab();
        this.d_writer.println("a = new " + BabelConfiguration.getBaseInterface() + ".Array(dim,lower,upper, isRow);");
        this.d_writer.println("d_array = a.get_ior_pointer();");
        this.d_writer.println("d_owner = true;");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.writeComment("Create an array using an BaseInterface Array", true);
        this.d_writer.println("protected Array(" + BabelConfiguration.getBaseInterface() + ".Array core) {");
        this.d_writer.tab();
        this.d_writer.println("a = core;");
        this.d_writer.println("d_array = a.get_ior_pointer();");
        this.d_writer.println("d_owner = true;");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.writeComment("Return this array's internal BaseInterface Array", true);
        this.d_writer.println("protected " + BabelConfiguration.getBaseInterface() + ".Array " + "getBaseInterfaceArray() {");
        this.d_writer.tab();
        this.d_writer.println("return a;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeComment("Call to base interface routine to get the dimension of this array", true);
        this.d_writer.println("public int _dim() {");
        this.d_writer.tab();
        this.d_writer.println("return a._dim();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeComment("Routine to get lower bound at the specified dimension", true);
        this.d_writer.println("public int _lower(int dim) {");
        this.d_writer.tab();
        this.d_writer.println("return a._lower(dim);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeComment("~Native~ routine to get upper bound at the specified dimension", true);
        this.d_writer.println("public int _upper(int dim) {");
        this.d_writer.tab();
        this.d_writer.println("return a._upper(dim);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeComment("Native routine to get stride at the specified dimension", true);
        this.d_writer.println("public int _stride(int dim) { ");
        this.d_writer.tab();
        this.d_writer.println("return a._stride(dim);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeComment("Routine gets the length of the array at the specified dimension", true);
        this.d_writer.println("public int _length(int dim) {");
        this.d_writer.tab();
        this.d_writer.println("return a._length(dim);");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.writeComment("Native routine returns true is array is columnorder", true);
        this.d_writer.println("public boolean _isColumnOrder() {");
        this.d_writer.tab();
        this.d_writer.println("return a._isColumnOrder();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeComment("Native routine returns true is array is row order", true);
        this.d_writer.println("public boolean _isRowOrder() {");
        this.d_writer.tab();
        this.d_writer.println("return a._isRowOrder();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeComment("Routine to get the value at the specified indices", true);
        if (ext.isInterface()) {
            this.d_writer.println("public " + elemType + ".Wrapper _get(int i, int j, int k, int l, int m, int n, int o) {");
            this.d_writer.tab();
            this.d_writer.println(elemType + ".Wrapper ret = null;");
            this.d_writer.println(BabelConfiguration.getBaseInterface() + ".Wrapper preCast = null;");
            this.d_writer.println("preCast = a._get(i,j,k,l,m,n,o);");
            this.d_writer.println("if(preCast != null) {");
            this.d_writer.tab();
            this.d_writer.println("ret = (" + elemType + ".Wrapper) preCast._cast2(\"" + elemType + "\");");
            this.d_writer.backTab();
            this.d_writer.println("} else {");
            this.d_writer.tab();
            this.d_writer.println("return null;");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("return (" + elemType + ".Wrapper) ret;");
            this.d_writer.backTab();
            this.d_writer.println("}");
        } else {
            this.d_writer.println("public " + elemType + " _get(int i, int j, int k, int l, int m, int n, int o) {");
            this.d_writer.tab();
            this.d_writer.println(elemType + " ret = null;");
            this.d_writer.println(BabelConfiguration.getBaseInterface() + ".Wrapper preCast = null;");
            this.d_writer.println("preCast = a._get(i,j,k,l,m,n,o);");
            this.d_writer.println("if(preCast != null) {");
            this.d_writer.tab();
            this.d_writer.println("ret = (" + elemType + ") preCast._cast2(\"" + elemType + "\");");
            this.d_writer.backTab();
            this.d_writer.println("} else {");
            this.d_writer.tab();
            this.d_writer.println("return null;");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("return (" + elemType + ") ret;");
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.writeComment("Routine to set the value at the specified indices", true);
        this.d_writer.println("public void _set(int i, int j, int k, int l, int m, int n, int o, " + elemType + " value) {");
        this.d_writer.tab();
        this.d_writer.println("a._set(i,j,k,l,m,n,o,value);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeComment("Routine to deallocate the array.", true);
        this.d_writer.println("public void _destroy() {");
        this.d_writer.tab();
        this.d_writer.println("if(d_owner) {");
        this.d_writer.tab();
        this.d_writer.println("d_array = 0;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("a._destroy();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.beginBlockComment(true);
        this.d_writer.println("addRef adds a reference to the IOR representation of the");
        this.d_writer.println("array, it does nothing for the Java object.");
        this.d_writer.endBlockComment(true);
        this.d_writer.println("public void _addRef() {");
        this.d_writer.tab();
        this.d_writer.println("a._addRef();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("");
        this.d_writer.writeComment("Routine to call deleteRef on the array.", true);
        this.d_writer.println("public void _deallocate() {");
        this.d_writer.tab();
        this.d_writer.println("a._deallocate();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeComment("Routine to return an array based on this one, but slice according to your instructions", true);
        this.d_writer.println("public " + elemType + ".Array _slice(int dimen, int[] numElem, " + "int[] srcStart, int[] srcStride, int[] newStart) {");
        this.d_writer.tab();
        this.d_writer.println(BabelConfiguration.getBaseInterface() + ".Array preCast = null;");
        this.d_writer.println("preCast = (" + BabelConfiguration.getBaseInterface() + ".Array) " + "a._slice(dimen,numElem,srcStart,srcStride,newStart);");
        this.d_writer.println("return new " + elemType + ".Array(preCast);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeComment("Copies borrowed arrays, addRefs otherwise.", true);
        this.d_writer.println("public gov.llnl.sidl.BaseArray _smartCopy() {");
        this.d_writer.tab();
        this.d_writer.println(BabelConfiguration.getBaseInterface() + ".Array preCast = null;");
        this.d_writer.println("preCast = (" + BabelConfiguration.getBaseInterface() + ".Array) a._smartCopy();");
        this.d_writer.println("return (gov.llnl.sidl.BaseArray) new " + elemType + ".Array(preCast);");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeComment("Copies borrowed arrays, addRefs otherwise.", true);
        this.d_writer.println("public void _copy(" + elemType + ".Array dest) {");
        this.d_writer.tab();
        this.d_writer.println("a._copy(dest.getBaseInterfaceArray());");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.writeComment("Native routine to reallocate the array data. Bad things happen if bad bounds are passed", true);
        this.d_writer.println("public void _reallocate(int dim, int[] lower, int[] upper, boolean isRow) {");
        this.d_writer.tab();
        this.d_writer.println("a._reallocate(dim,lower,upper, isRow);");
        this.d_writer.println("d_array = a.get_ior_pointer();");
        this.d_writer.println("d_owner = true;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("public Array _dcast() {");
        this.d_writer.tab();
        this.d_writer.println("try{ ");
        this.d_writer.tab();
        this.d_writer.println("int dimen = _dim();");
        this.d_writer.println(elemType + ".Array ret = null;");
        this.d_writer.println("switch (dimen) {");
        this.d_writer.tab();
        this.d_writer.println("case 1:");
        this.d_writer.println("ret = (Array) new " + elemType + ".Array1(getBaseInterfaceArray());");
        this.d_writer.println("_addRef();");
        this.d_writer.println("return ret;");
        this.d_writer.println("case 2:");
        this.d_writer.println("ret = (Array) new " + elemType + ".Array2(getBaseInterfaceArray());");
        this.d_writer.println("_addRef();");
        this.d_writer.println("return ret;");
        this.d_writer.println("case 3:");
        this.d_writer.println("ret = (Array) new " + elemType + ".Array3(getBaseInterfaceArray());");
        this.d_writer.println("_addRef();");
        this.d_writer.println("return ret;");
        this.d_writer.println("case 4:");
        this.d_writer.println("ret = (Array) new " + elemType + ".Array4(getBaseInterfaceArray());");
        this.d_writer.println("_addRef();");
        this.d_writer.println("return ret;");
        this.d_writer.println("case 5:");
        this.d_writer.println("ret = (Array) new " + elemType + ".Array5(getBaseInterfaceArray());");
        this.d_writer.println("_addRef();");
        this.d_writer.println("return ret;");
        this.d_writer.println("case 6:");
        this.d_writer.println("ret = (Array) new " + elemType + ".Array6(getBaseInterfaceArray());");
        this.d_writer.println("_addRef();");
        this.d_writer.println("return ret;");
        this.d_writer.println("case 7:");
        this.d_writer.println("ret = (Array) new " + elemType + ".Array7(getBaseInterfaceArray());");
        this.d_writer.println("_addRef();");
        this.d_writer.println("return ret;");
        this.d_writer.println("default:");
        this.d_writer.println("return null;");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("} catch (Exception ex) {");
        this.d_writer.tab();
        this.d_writer.println("return null;\t");
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("");
        this.d_writer.println("} ");
        this.d_writer.backTab();
        this.d_writer.writeComment("Native routine to reallocate the array, and copy a java array of objects into it.", true);
        this.d_writer.println("protected void _fromArray(Object[] orray, int dim, int[] lower, boolean isRow) {");
        this.d_writer.tab();
        this.d_writer.println("a._fromArray(orray, dim, lower, isRow);");
        this.d_writer.println("d_array = a.get_ior_pointer();");
        this.d_writer.println("d_owner = true;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        SymbolID aSymbol = new SymbolID(elemType + "$Array", id.getVersion());
        this.writeHolderClass(aSymbol);
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.writeNormalNumberedObjectArrays(ext);
    }

    private void writeNormalNumberedObjectArrays(Extendable ext) {
        SymbolID id = ext.getSymbolID();
        for (int dim = 1; dim <= 7; ++dim) {
            int i;
            String elemType = Java.getFullJavaSymbolName(id);
            this.d_writer.writeComment("The implementation of " + elemType + " " + dim + " arrays.", true);
            this.d_writer.println("public static class Array" + dim + " extends Array {");
            this.d_writer.tab();
            this.d_writer.println();
            this.d_writer.writeComment("Construct an empty " + dim + " dimensional array object.", true);
            this.d_writer.println("public Array" + dim + "() {");
            this.d_writer.tab();
            this.d_writer.println("super();");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.beginBlockComment(true);
            this.d_writer.println("");
            this.d_writer.println("Create a " + dim + " dimensional array using the specified java array.");
            this.d_writer.println("The lower bounds of the constructed array will start at zero.");
            this.d_writer.println("An array index out of range exception will be thrown if the ");
            this.d_writer.println("bounds are invalid.");
            this.d_writer.endBlockComment(true);
            this.d_writer.print("public Array" + dim + "(" + elemType);
            for (i = 0; i < dim; ++i) {
                this.d_writer.print("[]");
            }
            this.d_writer.println(" array, boolean isRow) {");
            this.d_writer.tab();
            this.d_writer.println("super();");
            this.d_writer.println("fromArray(array, isRow);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.writeComment("Create an array using an IOR pointer", true);
            this.d_writer.println("protected Array" + dim + "(long array, boolean owner) {");
            this.d_writer.tab();
            this.d_writer.println("super(array, owner);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.writeComment("Create a " + dim + " dimensional array with the specified, upper and lower bounds", true);
            this.d_writer.print("public Array" + dim + "(");
            this.printArgs("int", "l", dim);
            this.d_writer.print(",");
            this.printArgs("int", "u", dim);
            this.d_writer.println(", boolean isRow) {");
            this.d_writer.tab();
            this.d_writer.print("super(" + dim + ", new int[] {");
            this.printArgs("", "l", dim);
            this.d_writer.print("}");
            this.d_writer.print(", new int[] {");
            this.printArgs("", "u", dim);
            this.d_writer.print("}");
            this.d_writer.println(", isRow);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.writeComment("Create a " + dim + " dimensional array with the specified, upper bounds.  Lower bounds are all 0", true);
            this.d_writer.print("public Array" + dim + "(");
            this.printArgs("int", "s", dim);
            this.d_writer.println(", boolean isRow)  {");
            this.d_writer.tab();
            this.d_writer.print("super(" + dim + ", new int[] {");
            for (i = 0; i < dim; ++i) {
                this.d_writer.print(" 0");
                if (i == dim - 1) {
                    this.d_writer.print("}");
                    continue;
                }
                this.d_writer.print(",");
            }
            this.d_writer.print(", new int[] {");
            for (i = 0; i < dim; ++i) {
                this.d_writer.print(" s" + i + "-1");
                if (i == dim - 1) continue;
                this.d_writer.print(",");
            }
            this.d_writer.print("}");
            this.d_writer.println(", isRow);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.writeComment("Create an array using an BaseInterface Array", true);
            this.d_writer.println("protected Array" + dim + "(" + BabelConfiguration.getBaseInterface() + ".Array core) {");
            this.d_writer.tab();
            this.d_writer.println("super(core);");
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.writeComment("Get the element at the specified array w/o bounds checking (Is not written for 7 dimensions, as this functionality is inherited from Array", true);
            if (dim != 7) {
                if (ext.isInterface()) {
                    this.d_writer.print("public " + elemType + ".Wrapper _get(");
                    this.printArgs("int", "j", dim);
                    this.d_writer.println(") {");
                    this.d_writer.tab();
                    this.d_writer.print("return (" + elemType + ".Wrapper)_get(");
                    this.printArgsEndInZeros("", "j", dim, 7);
                    this.d_writer.println(");");
                    this.d_writer.backTab();
                    this.d_writer.println("}");
                    this.d_writer.println();
                } else {
                    this.d_writer.print("public " + elemType + " _get(");
                    this.printArgs("int", "j", dim);
                    this.d_writer.println(") {");
                    this.d_writer.tab();
                    this.d_writer.print("return (" + elemType + ")_get(");
                    this.printArgsEndInZeros("", "j", dim, 7);
                    this.d_writer.println(");");
                    this.d_writer.backTab();
                    this.d_writer.println("}");
                    this.d_writer.println();
                }
            }
            this.d_writer.writeComment("Get the element at the specified array with bounds checking", true);
            if (ext.isInterface()) {
                this.d_writer.print("public " + elemType + ".Wrapper get(");
                this.printArgs("int", "j", dim);
                this.d_writer.println(") {");
                this.d_writer.tab();
                this.d_writer.print("checkBounds(");
                this.printArgs("", "j", dim);
                this.d_writer.println(");");
                this.d_writer.println(elemType + ".Wrapper ret = null;");
                this.d_writer.print("ret = (" + elemType + ".Wrapper) _get(");
                this.printArgsEndInZeros("", "j", dim, 7);
                this.d_writer.println(");");
                this.d_writer.println("return ret;");
                this.d_writer.println();
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.println();
            } else {
                this.d_writer.print("public " + elemType + " get(");
                this.printArgs("int", "j", dim);
                this.d_writer.println(") {");
                this.d_writer.tab();
                this.d_writer.print("checkBounds(");
                this.printArgs("", "j", dim);
                this.d_writer.println(");");
                this.d_writer.println(elemType + " ret = null;");
                this.d_writer.print("ret = (" + elemType + ") _get(");
                this.printArgsEndInZeros("", "j", dim, 7);
                this.d_writer.println(");");
                this.d_writer.println("return ret;");
                this.d_writer.println();
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.println();
            }
            if (dim == 1) {
                this.d_writer.writeComment("Get the length of the array", true);
                this.d_writer.println("public int length() {");
                this.d_writer.tab();
                this.d_writer.println("return super._length(0);");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.println();
            } else {
                this.d_writer.writeComment("Get the length of the array in the specified dimension", true);
                this.d_writer.println("public int length(int dim) {");
                this.d_writer.tab();
                this.d_writer.println("return super._length(dim);");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.println();
            }
            this.d_writer.writeComment("Make a copy of a borrowed array, addref otherwise", true);
            this.d_writer.println("public " + elemType + ".Array" + dim + " smartCopy() {");
            this.d_writer.tab();
            this.d_writer.println(elemType + ".Array" + dim + " ret = null;");
            this.d_writer.println(elemType + ".Array preCast = null;");
            this.d_writer.println("preCast = (" + elemType + ".Array) _smartCopy();");
            this.d_writer.println("return new " + elemType + ".Array" + dim + "(preCast.getBaseInterfaceArray());");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.writeComment("Copy elements of this array into a passed in array of exactly the smae size", true);
            this.d_writer.println("public void copy(" + elemType + ".Array" + dim + " dest) {");
            this.d_writer.tab();
            this.d_writer.println("_copy((" + elemType + ".Array) dest);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.writeComment("Reallocate the " + dim + " dimensional array with the specified, upper and lower bounds", true);
            this.d_writer.print("public void reallocate(");
            this.printArgs("int", "l", dim);
            this.d_writer.print(",");
            this.printArgs("int", "u", dim);
            this.d_writer.println(", boolean isRow)  {");
            this.d_writer.tab();
            this.d_writer.print("reallocate(" + dim + ", new int[] {");
            this.printArgs("", "l", dim);
            this.d_writer.print("}");
            this.d_writer.print(", new int[] {");
            this.printArgs("", "u", dim);
            this.d_writer.print("}");
            this.d_writer.println(", isRow);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.writeComment("Set the element at the specified array w/o bounds checking", true);
            this.d_writer.print("public void _set(");
            this.printArgs("int", "j", dim);
            this.d_writer.print(",");
            this.d_writer.println(elemType + " value) {");
            this.d_writer.tab();
            this.d_writer.print("_set(");
            this.printArgsEndInZeros("", "j", dim, 7);
            this.d_writer.println(", value);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.writeComment("Set the element at the specified array with bounds checking", true);
            this.d_writer.print("public void set(");
            this.printArgs("int", "j", dim);
            this.d_writer.print(",");
            this.d_writer.println(elemType + " value) {");
            this.d_writer.tab();
            this.d_writer.print("checkBounds(");
            this.printArgs("", "j", dim);
            this.d_writer.println(");");
            this.d_writer.print("_set(");
            this.printArgsEndInZeros("", "j", dim, 7);
            this.d_writer.println(", value);");
            this.d_writer.println();
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.writeComment("Set the element at the specified array with bounds checking", true);
            this.d_writer.print("public void fromArray( ");
            this.d_writer.print(elemType);
            for (i = 0; i < dim; ++i) {
                this.d_writer.print("[]");
            }
            this.d_writer.println(" orray , boolean inRow) {");
            this.d_writer.tab();
            this.d_writer.println("int[] lower = new int[7];");
            for (i = 0; i < dim; ++i) {
                this.d_writer.print("lower[" + i + "] = orray");
                for (int j = 1; j < i; ++j) {
                    this.d_writer.print("[0]");
                }
                this.d_writer.println(".length-1;");
            }
            this.d_writer.println("_fromArray(orray, " + dim + ", lower, inRow);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.writeToFromArrayFunctions(id, dim);
            SymbolID aSymbol = new SymbolID(elemType + "$Array" + dim, id.getVersion());
            this.writeHolderClass(aSymbol);
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
    }

    void printArgs(String type, String var, int dim) {
        for (int i = 0; i < dim; ++i) {
            this.d_writer.print(" " + type + " " + var + i);
            if (i == dim - 1) continue;
            this.d_writer.print(",");
        }
    }

    void printArgsEndInZeros(String type, String var, int dim, int max) {
        int i;
        for (i = 0; i < dim; ++i) {
            this.d_writer.print(" " + type + " " + var + i);
            if (i == dim - 1 && dim == max) continue;
            this.d_writer.print(",");
        }
        for (i = dim; i < max; ++i) {
            this.d_writer.print(" 0");
            if (i == max - 1) continue;
            this.d_writer.print(",");
        }
    }

    private void writeBaseNumberedObjectArrays(Extendable ext) {
        SymbolID id = ext.getSymbolID();
        String elemType = Java.getFullJavaSymbolName(id);
        for (int dim = 1; dim <= 7; ++dim) {
            int i;
            this.d_writer.writeComment("The implementation of " + elemType + " " + dim + " arrays.", true);
            this.d_writer.println("public static class Array" + dim + " extends Array {");
            this.d_writer.tab();
            this.d_writer.println();
            this.d_writer.writeComment("Construct an empty " + dim + " dimensional array object.", true);
            this.d_writer.println("public Array" + dim + "() {");
            this.d_writer.tab();
            this.d_writer.println("super();");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.writeComment("Create an array using an IOR pointer", true);
            this.d_writer.println("protected Array" + dim + "(long array, boolean owner) {");
            this.d_writer.tab();
            this.d_writer.println("super(array, owner);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.writeComment("Create a " + dim + " dimensional array with the specified, upper and lower bounds", true);
            this.d_writer.print("public Array" + dim + "(");
            this.printArgs("int", "l", dim);
            this.d_writer.print(",");
            this.printArgs("int", "u", dim);
            this.d_writer.println(", boolean isRow) {");
            this.d_writer.tab();
            this.d_writer.print("super(" + dim + ", new int[] {");
            this.printArgs("", "l", dim);
            this.d_writer.print("}");
            this.d_writer.print(", new int[] {");
            this.printArgs("", "u", dim);
            this.d_writer.print("}");
            this.d_writer.println(", isRow);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.writeComment("Create a " + dim + " dimensional array with the specified, upper bounds.  Lower bounds are all 0", true);
            this.d_writer.print("public Array" + dim + "(");
            this.printArgs("int", "s", dim);
            this.d_writer.println(", boolean isRow)  {");
            this.d_writer.tab();
            this.d_writer.print("super(" + dim + ", new int[] {");
            for (i = 0; i < dim; ++i) {
                this.d_writer.print(" 0");
                if (i == dim - 1) {
                    this.d_writer.print("}");
                    continue;
                }
                this.d_writer.print(",");
            }
            this.d_writer.print(", new int[] {");
            for (i = 0; i < dim; ++i) {
                this.d_writer.print(" s" + i + "-1");
                if (i == dim - 1) continue;
                this.d_writer.print(",");
            }
            this.d_writer.print("}");
            this.d_writer.println(", isRow);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.beginBlockComment(true);
            this.d_writer.println("");
            this.d_writer.println("Create a " + dim + " dimensional array using the specified java array.");
            this.d_writer.println("The lower bounds of the constructed array will start at zero.");
            this.d_writer.println("An array index out of range exception will be thrown if the ");
            this.d_writer.println("bounds are invalid.");
            this.d_writer.endBlockComment(true);
            this.d_writer.print("public Array" + dim + "(" + elemType);
            for (i = 0; i < dim; ++i) {
                this.d_writer.print("[]");
            }
            this.d_writer.println(" array, boolean isRow) {");
            this.d_writer.tab();
            this.d_writer.println("super();");
            this.d_writer.println("fromArray(array, isRow);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            if (dim == 1) {
                this.d_writer.writeComment("Get the length of the array", true);
                this.d_writer.println("public int length() {");
                this.d_writer.tab();
                this.d_writer.println("return super._length(0);");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.println();
            } else {
                this.d_writer.writeComment("Get the length of the array in the specified dimension", true);
                this.d_writer.println("public int length(int dim) {");
                this.d_writer.tab();
                this.d_writer.println("return super._length(dim);");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.println();
            }
            this.d_writer.writeComment("Get the element at the specified array w/o bounds checking (Is not written for 7 dimensions, as this functionality is inherited from Array", true);
            if (dim != 7) {
                this.d_writer.print("public " + elemType + ".Wrapper _get(");
                this.printArgs("int", "j", dim);
                this.d_writer.println(") {");
                this.d_writer.tab();
                this.d_writer.print("return (" + elemType + ".Wrapper)_get(");
                this.printArgsEndInZeros("", "j", dim, 7);
                this.d_writer.println(");");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.println();
            }
            this.d_writer.writeComment("Get the element at the specified array with bounds checking", true);
            this.d_writer.print("public " + elemType + ".Wrapper get(");
            this.printArgs("int", "j", dim);
            this.d_writer.println(") {");
            this.d_writer.tab();
            this.d_writer.print("checkBounds(");
            this.printArgs("", "j", dim);
            this.d_writer.println(");");
            this.d_writer.println(elemType + ".Wrapper ret = null;");
            this.d_writer.print("ret = (" + elemType + ".Wrapper) _get(");
            this.printArgsEndInZeros("", "j", dim, 7);
            this.d_writer.println(");");
            this.d_writer.println("return ret;");
            this.d_writer.println();
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.writeComment("Make a copy of a borrowed array, addref otherwise", true);
            this.d_writer.println("public " + elemType + ".Array" + dim + " smartCopy() {");
            this.d_writer.tab();
            this.d_writer.println(elemType + ".Array" + dim + " ret = null;");
            this.d_writer.println(elemType + ".Array preCast = null;");
            this.d_writer.println("preCast = (" + elemType + ".Array)_smartCopy();");
            this.d_writer.println("return new " + elemType + ".Array" + dim + "(get_ior_pointer(), true);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.writeComment("Copy elements of this array into a passed in array of exactly the smae size", true);
            this.d_writer.println("public void copy(" + elemType + ".Array" + dim + " dest) {");
            this.d_writer.tab();
            this.d_writer.println("_copy((" + elemType + ".Array) dest);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.writeComment("Reallocate the " + dim + " dimensional array with the specified, upper and lower bounds", true);
            this.d_writer.print("public void reallocate(");
            this.printArgs("int", "l", dim);
            this.d_writer.print(",");
            this.printArgs("int", "u", dim);
            this.d_writer.println(", boolean isRow)  {");
            this.d_writer.tab();
            this.d_writer.print("reallocate(" + dim + ", new int[] {");
            this.printArgs("", "l", dim);
            this.d_writer.print("}");
            this.d_writer.print(", new int[] {");
            this.printArgs("", "u", dim);
            this.d_writer.print("}");
            this.d_writer.println(", isRow);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.writeComment("Set the element at the specified array w/o bounds checking", true);
            this.d_writer.print("public void _set(");
            this.printArgs("int", "j", dim);
            this.d_writer.print(",");
            this.d_writer.println(elemType + " value) {");
            this.d_writer.tab();
            this.d_writer.print("_set(");
            this.printArgsEndInZeros("", "j", dim, 7);
            this.d_writer.println(", value);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.writeComment("Set the element at the specified array with bounds checking", true);
            this.d_writer.print("public void set(");
            this.printArgs("int", "j", dim);
            this.d_writer.print(",");
            this.d_writer.println(elemType + " value) {");
            this.d_writer.tab();
            this.d_writer.print("checkBounds(");
            this.printArgs("", "j", dim);
            this.d_writer.println(");");
            this.d_writer.print("_set(");
            this.printArgsEndInZeros("", "j", dim, 7);
            this.d_writer.println(", value);");
            this.d_writer.println();
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.writeComment("Set the element at the specified array with bounds checking", true);
            this.d_writer.print("public void fromArray( ");
            this.d_writer.print(elemType);
            for (i = 0; i < dim; ++i) {
                this.d_writer.print("[]");
            }
            this.d_writer.println(" orray , boolean inRow) {");
            this.d_writer.tab();
            this.d_writer.println("int[] lower = new int[7];");
            for (i = 0; i < dim; ++i) {
                this.d_writer.print("lower[" + i + "] = orray");
                for (int j = 1; j < i; ++j) {
                    this.d_writer.print("[0]");
                }
                this.d_writer.println(".length-1;");
            }
            this.d_writer.println("_fromArray(orray, " + dim + ", lower, inRow);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.writeToFromArrayFunctions(id, dim);
            SymbolID aSymbol = new SymbolID(elemType + "$Array" + dim, id.getVersion());
            this.writeHolderClass(aSymbol);
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
    }

    private void writeToFromArrayFunctions(SymbolID id, int dim) {
        String elemType = Java.getFullJavaSymbolName(id);
        switch (dim) {
            case 1: {
                this.d_writer.beginBlockComment(true);
                this.d_writer.println("");
                this.d_writer.println("Convert the sidl array into a Java array.  This method will copy");
                this.d_writer.println("the sidl array into the Java array.  The resulting Java array will");
                this.d_writer.println("(obviously) start with a zero lower bound.  If the sidl array is");
                this.d_writer.println("empty (null), then a null Java array will be returned.");
                this.d_writer.println("");
                this.d_writer.endBlockComment(true);
                this.d_writer.println("public " + elemType + "[] toArray() {");
                this.d_writer.tab();
                this.d_writer.println("" + elemType + "[] array = null;");
                this.d_writer.println("if (!isNull()) {");
                this.d_writer.tab();
                this.d_writer.println("checkDimension(1);");
                this.d_writer.println("int l0 = _lower(0);");
                this.d_writer.println("int u0 = _upper(0);");
                this.d_writer.println("array = new " + elemType + "[u0-l0+1];");
                this.d_writer.println("for (int i = l0; i <= u0; i++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i-l0] = _get(i);");
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("return array;");
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("");
                this.d_writer.println("");
                break;
            }
            case 2: {
                this.d_writer.beginBlockComment(true);
                this.d_writer.println("");
                this.d_writer.println("Convert the sidl array into a Java array.  This method will copy");
                this.d_writer.println("the sidl array into the Java array.  The resulting Java array will");
                this.d_writer.println("(obviously) start with a zero lower bound.  If the sidl array is");
                this.d_writer.println("empty (null), then a null Java array will be returned.");
                this.d_writer.println("");
                this.d_writer.endBlockComment(true);
                this.d_writer.println("public " + elemType + "[][] toArray() {");
                this.d_writer.tab();
                this.d_writer.println("" + elemType + "[][] array = null;");
                this.d_writer.println("if (!isNull()) {");
                this.d_writer.tab();
                this.d_writer.println("checkDimension(2);");
                this.d_writer.println("int l0 = _lower(0);");
                this.d_writer.println("int u0 = _upper(0);");
                this.d_writer.println("int l1 = _lower(1);");
                this.d_writer.println("int u1 = _upper(1);");
                this.d_writer.println("array = new " + elemType + "[u0-l0+1][];");
                this.d_writer.println("for (int i = l0; i <= u0; i++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i] = new " + elemType + "[u1-l1+1];");
                this.d_writer.println("for (int j = l1; j <= u1; j++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i-l0][j-l1] = _get(i, j);");
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("return array;");
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("");
                break;
            }
            case 3: {
                this.d_writer.beginBlockComment(true);
                this.d_writer.println("");
                this.d_writer.println("Convert the sidl array into a Java array.  This method will copy");
                this.d_writer.println("the sidl array into the Java array.  The resulting Java array will");
                this.d_writer.println("(obviously) start with a zero lower bound.  If the sidl array is");
                this.d_writer.println("empty (null), then a null Java array will be returned.");
                this.d_writer.println("");
                this.d_writer.endBlockComment(true);
                this.d_writer.println("public " + elemType + "[][][] toArray() {");
                this.d_writer.tab();
                this.d_writer.println("" + elemType + "[][][] array = null;");
                this.d_writer.println("if (!isNull()) {");
                this.d_writer.tab();
                this.d_writer.println("checkDimension(3);");
                this.d_writer.println("int l0 = _lower(0);");
                this.d_writer.println("int u0 = _upper(0);");
                this.d_writer.println("int l1 = _lower(1);");
                this.d_writer.println("int u1 = _upper(1);");
                this.d_writer.println("int l2 = _lower(2);");
                this.d_writer.println("int u2 = _upper(2);");
                this.d_writer.println("array = new " + elemType + "[u0-l0+1][][];");
                this.d_writer.println("for (int i = l0; i <= u0; i++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i] = new " + elemType + "[u1-l1+1][];");
                this.d_writer.println("for (int j = l1; j <= u1; j++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j] = new " + elemType + "[u2-l2+1];");
                this.d_writer.println("for (int k = l2; k <= u2; k++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i-l0][j-l1][k-l2] = _get(i, j, k);");
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("return array;");
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("");
                break;
            }
            case 4: {
                this.d_writer.beginBlockComment(true);
                this.d_writer.println("");
                this.d_writer.println("Convert the sidl array into a Java array.  This method will copy");
                this.d_writer.println("the sidl array into the Java array.  The resulting Java array will");
                this.d_writer.println("(obviously) start with a zero lower bound.  If the sidl array is");
                this.d_writer.println("empty (null), then a null Java array will be returned.");
                this.d_writer.println("");
                this.d_writer.endBlockComment(true);
                this.d_writer.println("public " + elemType + "[][][][] toArray() {");
                this.d_writer.tab();
                this.d_writer.println("" + elemType + "[][][][] array = null;");
                this.d_writer.println("if (!isNull()) {");
                this.d_writer.tab();
                this.d_writer.println("checkDimension(4);");
                this.d_writer.println("int l0 = _lower(0);");
                this.d_writer.println("int u0 = _upper(0);");
                this.d_writer.println("int l1 = _lower(1);");
                this.d_writer.println("int u1 = _upper(1);");
                this.d_writer.println("int l2 = _lower(2);");
                this.d_writer.println("int u2 = _upper(2);");
                this.d_writer.println("int l3 = _lower(3);");
                this.d_writer.println("int u3 = _upper(3);");
                this.d_writer.println("array = new " + elemType + "[u0-l0+1][][][];");
                this.d_writer.println("for (int i = l0; i <= u0; i++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i] = new " + elemType + "[u1-l1+1][][];");
                this.d_writer.println("for (int j = l1; j <= u1; j++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j] = new " + elemType + "[u2-l2+1][];");
                this.d_writer.println("for (int k = l2; k <= u2; k++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j][k] = new " + elemType + "[u3-l3+1];");
                this.d_writer.println("for (int l = l3; l <= u3; l++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i-l0][j-l1][k-l2][l-l3] = _get(i, j, k, l);");
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("return array;");
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("");
                break;
            }
            case 5: {
                this.d_writer.beginBlockComment(true);
                this.d_writer.println("");
                this.d_writer.println("Convert the sidl array into a Java array.  This method will copy");
                this.d_writer.println("the sidl array into the Java array.  The resulting Java array will");
                this.d_writer.println("(obviously) start with a zero lower bound.  If the sidl array is");
                this.d_writer.println("empty (null), then a null Java array will be returned.");
                this.d_writer.println("");
                this.d_writer.endBlockComment(true);
                this.d_writer.println("public " + elemType + "[][][][][] toArray() {");
                this.d_writer.tab();
                this.d_writer.println("" + elemType + "[][][][][] array = null;");
                this.d_writer.println("if (!isNull()) {");
                this.d_writer.tab();
                this.d_writer.println("checkDimension(5);");
                this.d_writer.println("int l0 = _lower(0);");
                this.d_writer.println("int u0 = _upper(0);");
                this.d_writer.println("int l1 = _lower(1);");
                this.d_writer.println("int u1 = _upper(1);");
                this.d_writer.println("int l2 = _lower(2);");
                this.d_writer.println("int u2 = _upper(2);");
                this.d_writer.println("int l3 = _lower(3);");
                this.d_writer.println("int u3 = _upper(3);");
                this.d_writer.println("int l4 = _lower(4);");
                this.d_writer.println("int u4 = _upper(4);");
                this.d_writer.println("array = new " + elemType + "[u0-l0+1][][][][];");
                this.d_writer.println("for (int i = l0; i <= u0; i++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i] = new " + elemType + "[u1-l1+1][][][];");
                this.d_writer.println("for (int j = l1; j <= u1; j++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j] = new " + elemType + "[u2-l2+1][][];");
                this.d_writer.println("for (int k = l2; k <= u2; k++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j][k] = new " + elemType + "[u3-l3+1][];");
                this.d_writer.println("for (int l = l3; l <= u3; l++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j][k][l] = new " + elemType + "[u4-l4+1];");
                this.d_writer.println("for (int m = l4; m <= u4; m++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i-l0][j-l1][k-l2][l-l3][m-l4] = _get(i, j, k, l, m);");
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("return array;");
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("");
                break;
            }
            case 6: {
                this.d_writer.beginBlockComment(true);
                this.d_writer.println("");
                this.d_writer.println("Convert the sidl array into a Java array.  This method will copy");
                this.d_writer.println("the sidl array into the Java array.  The resulting Java array will");
                this.d_writer.println("(obviously) start with a zero lower bound.  If the sidl array is");
                this.d_writer.println("empty (null), then a null Java array will be returned.");
                this.d_writer.println("");
                this.d_writer.endBlockComment(true);
                this.d_writer.println("public " + elemType + "[][][][][][] toArray() {");
                this.d_writer.tab();
                this.d_writer.println("" + elemType + "[][][][][][] array = null;");
                this.d_writer.println("if (!isNull()) {");
                this.d_writer.tab();
                this.d_writer.println("checkDimension(6);");
                this.d_writer.println("int l0 = _lower(0);");
                this.d_writer.println("int u0 = _upper(0);");
                this.d_writer.println("int l1 = _lower(1);");
                this.d_writer.println("int u1 = _upper(1);");
                this.d_writer.println("int l2 = _lower(2);");
                this.d_writer.println("int u2 = _upper(2);");
                this.d_writer.println("int l3 = _lower(3);");
                this.d_writer.println("int u3 = _upper(3);");
                this.d_writer.println("int l4 = _lower(4);");
                this.d_writer.println("int u4 = _upper(4);");
                this.d_writer.println("int l5 = _lower(5);");
                this.d_writer.println("int u5 = _upper(5);");
                this.d_writer.println("array = new " + elemType + "[u0-l0+1][][][][][];");
                this.d_writer.println("for (int i = l0; i <= u0; i++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i] = new " + elemType + "[u1-l1+1][][][][];");
                this.d_writer.println("for (int j = l1; j <= u1; j++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j] = new " + elemType + "[u2-l2+1][][][];");
                this.d_writer.println("for (int k = l2; k <= u2; k++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j][k] = new " + elemType + "[u3-l3+1][][];");
                this.d_writer.println("for (int l = l3; l <= u3; l++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j][k][l] = new " + elemType + "[u4-l4+1][];");
                this.d_writer.println("for (int m = l4; m <= u4; m++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j][k][l][m] = new " + elemType + "[u4-l4+1];");
                this.d_writer.println("for (int n = l5; n <= u5; n++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i-l0][j-l1][k-l2][l-l3][m-l4][n-l5] = _get(i, j, k, l, m, n);");
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("return array;");
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("");
                break;
            }
            case 7: {
                this.d_writer.beginBlockComment(true);
                this.d_writer.println("");
                this.d_writer.println("Convert the sidl array into a Java array.  This method will copy");
                this.d_writer.println("the sidl array into the Java array.  The resulting Java array will");
                this.d_writer.println("(obviously) start with a zero lower bound.  If the sidl array is");
                this.d_writer.println("empty (null), then a null Java array will be returned.");
                this.d_writer.println("");
                this.d_writer.endBlockComment(true);
                this.d_writer.println("public " + elemType + "[][][][][][][] toArray() {");
                this.d_writer.tab();
                this.d_writer.println("" + elemType + "[][][][][][][] array = null;");
                this.d_writer.println("if (!isNull()) {");
                this.d_writer.tab();
                this.d_writer.println("checkDimension(6);");
                this.d_writer.println("int l0 = _lower(0);");
                this.d_writer.println("int u0 = _upper(0);");
                this.d_writer.println("int l1 = _lower(1);");
                this.d_writer.println("int u1 = _upper(1);");
                this.d_writer.println("int l2 = _lower(2);");
                this.d_writer.println("int u2 = _upper(2);");
                this.d_writer.println("int l3 = _lower(3);");
                this.d_writer.println("int u3 = _upper(3);");
                this.d_writer.println("int l4 = _lower(4);");
                this.d_writer.println("int u4 = _upper(4);");
                this.d_writer.println("int l5 = _lower(5);");
                this.d_writer.println("int u5 = _upper(5);");
                this.d_writer.println("int l6 = _lower(6);");
                this.d_writer.println("int u6 = _upper(6);");
                this.d_writer.println("array = new " + elemType + "[u0-l0+1][][][][][][];");
                this.d_writer.println("for (int i = l0; i <= u0; i++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i] = new " + elemType + "[u1-l1+1][][][][][];");
                this.d_writer.println("for (int j = l1; j <= u1; j++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j] = new " + elemType + "[u2-l2+1][][][][];");
                this.d_writer.println("for (int k = l2; k <= u2; k++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j][k] = new " + elemType + "[u3-l3+1][][][];");
                this.d_writer.println("for (int l = l3; l <= u3; l++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j][k][l] = new " + elemType + "[u4-l4+1][][];");
                this.d_writer.println("for (int m = l4; m <= u4; m++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j][k][l][m] = new " + elemType + "[u4-l4+1][];");
                this.d_writer.println("for (int n = l5; n <= u5; n++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i][j][k][l][m][n] = new " + elemType + "[u5-l5+1];");
                this.d_writer.println("for (int o = l6; o <= u6; o++) {");
                this.d_writer.tab();
                this.d_writer.println("array[i-l0][j-l1][k-l2][l-l3][m-l4][n-l5][o-l6] = _get(i, j, k, l, m, n,o);");
                this.d_writer.println("");
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("}");
                this.d_writer.backTab();
                this.d_writer.println("return array;");
                this.d_writer.println("}");
                this.d_writer.backTab();
            }
        }
    }
}

