/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.aspectj.org.eclipse.jdt.core.IBuffer;
import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaModelStatus;
import org.aspectj.org.eclipse.jdt.core.IPackageFragment;
import org.aspectj.org.eclipse.jdt.core.JavaConventions;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElementDelta;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelOperation;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelStatus;
import org.aspectj.org.eclipse.jdt.internal.core.util.Messages;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class CreateCompilationUnitOperation
extends JavaModelOperation {
    protected String fName;
    protected String fSource = null;

    public CreateCompilationUnitOperation(IPackageFragment parentElement, String name, String source, boolean force) {
        super(null, new IJavaElement[]{parentElement}, force);
        this.fName = name;
        this.fSource = source;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        try {
            block15: {
                this.beginTask(Messages.operation_createUnitProgress, 2);
                JavaElementDelta delta = this.newJavaElementDelta();
                ICompilationUnit unit = this.getCompilationUnit();
                IPackageFragment pkg = (IPackageFragment)this.getParentElement();
                IContainer folder = (IContainer)pkg.getResource();
                this.worked(1);
                IFile compilationUnitFile = folder.getFile(new Path(this.fName));
                if (compilationUnitFile.exists()) {
                    if (!this.force) throw new JavaModelException(new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, compilationUnitFile.getFullPath().toString())));
                    IBuffer buffer = unit.getBuffer();
                    if (buffer == null) {
                        Object var9_9 = null;
                        this.done();
                        return;
                    }
                    buffer.setContents(this.fSource);
                    unit.save(new NullProgressMonitor(), false);
                    this.resultElements = new IJavaElement[]{unit};
                    if (!Util.isExcluded(unit) && unit.getParent().exists()) {
                        int i = 0;
                        while (true) {
                            if (i >= this.resultElements.length) {
                                this.addDelta(delta);
                                break;
                            }
                            delta.changed(this.resultElements[i], 1);
                            ++i;
                        }
                    }
                } else {
                    try {
                        String encoding = null;
                        try {
                            encoding = folder.getDefaultCharset();
                        }
                        catch (CoreException i) {
                            // empty catch block
                        }
                        ByteArrayInputStream stream = new ByteArrayInputStream(encoding == null ? this.fSource.getBytes() : this.fSource.getBytes(encoding));
                        this.createFile(folder, unit.getElementName(), stream, this.force);
                        this.resultElements = new IJavaElement[]{unit};
                        if (Util.isExcluded(unit) || !unit.getParent().exists()) break block15;
                        int i = 0;
                        while (true) {
                            if (i >= this.resultElements.length) {
                                this.addDelta(delta);
                                break;
                            }
                            delta.added(this.resultElements[i]);
                            ++i;
                        }
                    }
                    catch (IOException e) {
                        throw new JavaModelException(e, 985);
                    }
                }
            }
            this.worked(1);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.done();
            return;
        }
    }

    protected ICompilationUnit getCompilationUnit() {
        return ((IPackageFragment)this.getParentElement()).getCompilationUnit(this.fName);
    }

    protected ISchedulingRule getSchedulingRule() {
        IResource resource = this.getCompilationUnit().getResource();
        IWorkspace workspace = resource.getWorkspace();
        if (resource.exists()) {
            return workspace.getRuleFactory().modifyRule(resource);
        }
        return workspace.getRuleFactory().createRule(resource);
    }

    public IJavaModelStatus verify() {
        if (this.getParentElement() == null) {
            return new JavaModelStatus(968);
        }
        if (JavaConventions.validateCompilationUnitName(this.fName).getSeverity() == 4) {
            return new JavaModelStatus(983, this.fName);
        }
        if (this.fSource == null) {
            return new JavaModelStatus(984);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

