/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.IInitializer;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.IPackageFragment;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.core.BinaryType;
import org.aspectj.org.eclipse.jdt.internal.core.ClasspathEntry;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElementRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.NameLookup;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragmentRoot;

class SearchableEnvironmentRequestor
extends JavaElementRequestor {
    protected ISearchRequestor requestor;
    protected ICompilationUnit unitToSkip;
    protected IJavaProject project;
    protected NameLookup nameLookup;
    protected boolean checkAccessRestrictions;

    public SearchableEnvironmentRequestor(ISearchRequestor requestor) {
        this.requestor = requestor;
        this.unitToSkip = null;
        this.project = null;
        this.nameLookup = null;
        this.checkAccessRestrictions = false;
    }

    public SearchableEnvironmentRequestor(ISearchRequestor requestor, ICompilationUnit unitToSkip, IJavaProject project, NameLookup nameLookup) {
        this.requestor = requestor;
        this.unitToSkip = unitToSkip;
        this.project = project;
        this.nameLookup = nameLookup;
        this.checkAccessRestrictions = !"ignore".equals(project.getOption("org.aspectj.org.eclipse.jdt.core.compiler.problem.forbiddenReference", true));
    }

    public void acceptInitializer(IInitializer initializer) {
    }

    public void acceptPackageFragment(IPackageFragment packageFragment) {
        this.requestor.acceptPackage(packageFragment.getElementName().toCharArray());
    }

    public void acceptType(IType type) {
        try {
            PackageFragmentRoot root;
            ClasspathEntry entry;
            if (this.unitToSkip != null && this.unitToSkip.equals(type.getCompilationUnit())) {
                return;
            }
            String packageName = type.getPackageFragment().getElementName();
            String typeName = type.getElementName();
            boolean isBinary = type instanceof BinaryType;
            AccessRestriction accessRestriction = null;
            if (this.checkAccessRestrictions && (isBinary || !type.getJavaProject().equals(this.project)) && (entry = (ClasspathEntry)this.nameLookup.rootToResolvedEntries.get(root = (PackageFragmentRoot)type.getAncestor(3))) != null && (accessRestriction = entry.getImportRestriction()) != null) {
                char[][] packageChars = CharOperation.splitOn('.', packageName.toCharArray());
                char[] typeChars = typeName.toCharArray();
                accessRestriction = accessRestriction.getViolatedRestriction(CharOperation.concatWith(packageChars, typeChars, '/'), null);
            }
            if (type.isClass()) {
                this.requestor.acceptClass(type.getPackageFragment().getElementName().toCharArray(), type.getElementName().toCharArray(), type.getFlags(), accessRestriction);
            } else {
                this.requestor.acceptInterface(type.getPackageFragment().getElementName().toCharArray(), type.getElementName().toCharArray(), type.getFlags(), accessRestriction);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }
}

