/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.classfmt;

import org.aspectj.org.eclipse.jdt.core.Signature;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.aspectj.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.Util;

public class FieldInfo
extends ClassFileStruct
implements AttributeNamesConstants,
IBinaryField,
Comparable,
TypeIds {
    private int accessFlags;
    private int attributeBytes;
    private Constant constant;
    private int[] constantPoolOffsets;
    private char[] descriptor;
    private char[] name;
    private char[] signature;
    private int signatureUtf8Offset;
    private long tagBits;
    private Object wrappedConstantValue;

    public FieldInfo(byte[] classFileBytes, int[] offsets, int offset) {
        super(classFileBytes, offset);
        this.constantPoolOffsets = offsets;
        this.accessFlags = -1;
        int attributesCount = this.u2At(6);
        int readOffset = 8;
        this.signatureUtf8Offset = -1;
        int i = 0;
        while (i < attributesCount) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(readOffset)] - this.structOffset;
            char[] attributeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
            if (attributeName.length > 0) {
                switch (attributeName[0]) {
                    case 'S': {
                        if (!CharOperation.equals(AttributeNamesConstants.SignatureName, attributeName)) break;
                        this.signatureUtf8Offset = this.constantPoolOffsets[this.u2At(readOffset + 6)] - this.structOffset;
                        break;
                    }
                    case 'R': {
                        if (!CharOperation.equals(attributeName, AttributeNamesConstants.RuntimeVisibleAnnotationsName)) break;
                        this.decodeStandardAnnotations(readOffset);
                    }
                }
            }
            readOffset = (int)((long)readOffset + (6L + this.u4At(readOffset + 2)));
            ++i;
        }
        this.attributeBytes = readOffset;
    }

    public int compareTo(Object o) {
        if (!(o instanceof FieldInfo)) {
            throw new ClassCastException();
        }
        return new String(this.getName()).compareTo(new String(((FieldInfo)o).getName()));
    }

    private int decodeAnnotation(int offset) {
        char[] lastPart;
        int readOffset = offset;
        int utf8Offset = this.constantPoolOffsets[this.u2At(offset)] - this.structOffset;
        char[] typeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
        typeName = Signature.toCharArray(typeName);
        CharOperation.replace(typeName, '/', '.');
        char[][] qualifiedTypeName = CharOperation.splitOn('.', typeName);
        int numberOfPairs = this.u2At(offset + 2);
        readOffset += 4;
        if (qualifiedTypeName.length == 3 && (lastPart = qualifiedTypeName[2])[0] == 'D' && CharOperation.equals(qualifiedTypeName, TypeConstants.JAVA_LANG_DEPRECATED)) {
            this.tagBits |= 0x200000000000L;
            return readOffset;
        }
        int i = 0;
        while (i < numberOfPairs) {
            readOffset += 2;
            readOffset = this.decodeElementValue(readOffset);
            ++i;
        }
        return readOffset;
    }

    private int decodeElementValue(int offset) {
        int readOffset = offset;
        int tag = this.u1At(readOffset);
        ++readOffset;
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                readOffset += 2;
                break;
            }
            case 101: {
                readOffset += 4;
                break;
            }
            case 99: {
                readOffset += 2;
                break;
            }
            case 64: {
                readOffset += this.decodeAnnotation(readOffset);
                break;
            }
            case 91: {
                int numberOfValues = this.u2At(readOffset);
                readOffset += 2;
                int i = 0;
                while (i < numberOfValues) {
                    readOffset = this.decodeElementValue(readOffset);
                    ++i;
                }
                break;
            }
        }
        return readOffset;
    }

    private void decodeStandardAnnotations(int offset) {
        int numberOfAnnotations = this.u2At(offset + 6);
        int readOffset = offset + 8;
        int i = 0;
        while (i < numberOfAnnotations) {
            readOffset = this.decodeAnnotation(readOffset);
            ++i;
        }
    }

    public Constant getConstant() {
        if (this.constant == null) {
            this.readConstantAttribute();
        }
        return this.constant;
    }

    public char[] getGenericSignature() {
        if (this.signatureUtf8Offset != -1) {
            if (this.signature == null) {
                this.signature = this.utf8At(this.signatureUtf8Offset + 3, this.u2At(this.signatureUtf8Offset + 1));
            }
            return this.signature;
        }
        return null;
    }

    public int getModifiers() {
        if (this.accessFlags == -1) {
            this.accessFlags = this.u2At(0);
            this.readModifierRelatedAttributes();
        }
        return this.accessFlags;
    }

    public char[] getName() {
        if (this.name == null) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(2)] - this.structOffset;
            this.name = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
        }
        return this.name;
    }

    public long getTagBits() {
        return this.tagBits;
    }

    public char[] getTypeName() {
        if (this.descriptor == null) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(4)] - this.structOffset;
            this.descriptor = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
        }
        return this.descriptor;
    }

    public Object getWrappedConstantValue() {
        if (this.wrappedConstantValue == null && this.hasConstant()) {
            Constant fieldConstant = this.getConstant();
            switch (fieldConstant.typeID()) {
                case 10: {
                    this.wrappedConstantValue = new Integer(fieldConstant.intValue());
                    break;
                }
                case 3: {
                    this.wrappedConstantValue = new Byte(fieldConstant.byteValue());
                    break;
                }
                case 4: {
                    this.wrappedConstantValue = new Short(fieldConstant.shortValue());
                    break;
                }
                case 2: {
                    this.wrappedConstantValue = new Character(fieldConstant.charValue());
                    break;
                }
                case 9: {
                    this.wrappedConstantValue = new Float(fieldConstant.floatValue());
                    break;
                }
                case 8: {
                    this.wrappedConstantValue = new Double(fieldConstant.doubleValue());
                    break;
                }
                case 5: {
                    this.wrappedConstantValue = Util.toBoolean(fieldConstant.booleanValue());
                    break;
                }
                case 7: {
                    this.wrappedConstantValue = new Long(fieldConstant.longValue());
                    break;
                }
                case 11: {
                    this.wrappedConstantValue = fieldConstant.stringValue();
                }
            }
        }
        return this.wrappedConstantValue;
    }

    public boolean hasConstant() {
        return this.getConstant() != Constant.NotAConstant;
    }

    void initialize() {
        this.getModifiers();
        this.getName();
        this.getConstant();
        this.getTypeName();
        this.getGenericSignature();
        this.reset();
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    private void readConstantAttribute() {
        int attributesCount = this.u2At(6);
        int readOffset = 8;
        boolean isConstant = false;
        int i = 0;
        while (i < attributesCount) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(readOffset)] - this.structOffset;
            char[] attributeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
            if (CharOperation.equals(attributeName, AttributeNamesConstants.ConstantValueName)) {
                isConstant = true;
                int relativeOffset = this.constantPoolOffsets[this.u2At(readOffset + 6)] - this.structOffset;
                block0 : switch (this.u1At(relativeOffset)) {
                    case 3: {
                        char[] sign = this.getTypeName();
                        if (sign.length == 1) {
                            switch (sign[0]) {
                                case 'Z': {
                                    this.constant = new BooleanConstant(this.i4At(relativeOffset + 1) == 1);
                                    break block0;
                                }
                                case 'I': {
                                    this.constant = new IntConstant(this.i4At(relativeOffset + 1));
                                    break block0;
                                }
                                case 'C': {
                                    this.constant = new CharConstant((char)this.i4At(relativeOffset + 1));
                                    break block0;
                                }
                                case 'B': {
                                    this.constant = new ByteConstant((byte)this.i4At(relativeOffset + 1));
                                    break block0;
                                }
                                case 'S': {
                                    this.constant = new ShortConstant((short)this.i4At(relativeOffset + 1));
                                    break block0;
                                }
                            }
                            this.constant = Constant.NotAConstant;
                            break;
                        }
                        this.constant = Constant.NotAConstant;
                        break;
                    }
                    case 4: {
                        this.constant = new FloatConstant(this.floatAt(relativeOffset + 1));
                        break;
                    }
                    case 6: {
                        this.constant = new DoubleConstant(this.doubleAt(relativeOffset + 1));
                        break;
                    }
                    case 5: {
                        this.constant = new LongConstant(this.i8At(relativeOffset + 1));
                        break;
                    }
                    case 8: {
                        utf8Offset = this.constantPoolOffsets[this.u2At(relativeOffset + 1)] - this.structOffset;
                        this.constant = new StringConstant(String.valueOf(this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1))));
                    }
                }
            }
            readOffset = (int)((long)readOffset + (6L + this.u4At(readOffset + 2)));
            ++i;
        }
        if (!isConstant) {
            this.constant = Constant.NotAConstant;
        }
    }

    private void readModifierRelatedAttributes() {
        int attributesCount = this.u2At(6);
        int readOffset = 8;
        int i = 0;
        while (i < attributesCount) {
            int utf8Offset = this.constantPoolOffsets[this.u2At(readOffset)] - this.structOffset;
            char[] attributeName = this.utf8At(utf8Offset + 3, this.u2At(utf8Offset + 1));
            if (attributeName.length != 0) {
                switch (attributeName[0]) {
                    case 'D': {
                        if (!CharOperation.equals(attributeName, AttributeNamesConstants.DeprecatedName)) break;
                        this.accessFlags |= 0x100000;
                        break;
                    }
                    case 'S': {
                        if (!CharOperation.equals(attributeName, AttributeNamesConstants.SyntheticName)) break;
                        this.accessFlags |= 0x1000;
                    }
                }
            }
            readOffset = (int)((long)readOffset + (6L + this.u4At(readOffset + 2)));
            ++i;
        }
    }

    protected void reset() {
        this.constantPoolOffsets = null;
        super.reset();
    }

    public int sizeInBytes() {
        return this.attributeBytes;
    }

    public void throwFormatException() throws ClassFormatException {
        throw new ClassFormatException(17);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        int modifiers = this.getModifiers();
        return buffer.append("{").append(String.valueOf((modifiers & 0x100000) != 0 ? "deprecated " : "") + ((modifiers & 1) == 1 ? "public " : "") + ((modifiers & 2) == 2 ? "private " : "") + ((modifiers & 4) == 4 ? "protected " : "") + ((modifiers & 8) == 8 ? "static " : "") + ((modifiers & 0x10) == 16 ? "final " : "") + ((modifiers & 0x40) == 64 ? "volatile " : "") + ((modifiers & 0x80) == 128 ? "transient " : "")).append(this.getTypeName()).append(" ").append(this.getName()).append(" ").append(this.getConstant()).append("}").toString();
    }
}

