.TH ZABBIX_PROXY 8 "2018\-10\-11" Zabbix
.SH NAME
zabbix_proxy \- Zabbix proxy daemon
.SH SYNOPSIS
.B zabbix_proxy
.RB [ \-c
.IR config\-file ]
.br
.B zabbix_proxy
.RB [ \-c
.IR config\-file ]
.B \-R
.I runtime\-option
.br
.B zabbix_proxy \-h
.br
.B zabbix_proxy \-V
.SH DESCRIPTION
.B zabbix_proxy
is a daemon that collects monitoring data from devices and sends it to Zabbix server.
.SH OPTIONS
.IP "\fB\-c\fR, \fB\-\-config\fR \fIconfig\-file\fR"
Use the alternate \fIconfig\-file\fR instead of the default one.
Absolute path should be specified.
.IP "\fB\-f\fR, \fB\-\-foreground\fR"
Run Zabbix proxy in foreground.
.IP "\fB\-R\fR, \fB\-\-runtime\-control\fR \fIruntime\-option\fR"
Perform administrative functions according to \fIruntime\-option\fR.
.SS
.RS 4
Runtime control options
.RS 4
.TP 4
.B config_cache_reload
Reload configuration cache.
Ignored if cache is being currently loaded.
Active Zabbix proxy will connect to the Zabbix server and request configuration data.
Default configuration file (unless \fB\-c\fR option is specified) will be used to find PID file and signal will be sent to process, listed in PID file.
.RE
.RS 4
.TP 4
.B housekeeper_execute
Execute the housekeeper.
Ignored if housekeeper is being currently executed.
.RE
.RS 4
.TP 4
\fBlog_level_increase\fR[=\fItarget\fR]
Increase log level, affects all processes if target is not specified
.RE
.RS 4
.TP 4
\fBlog_level_decrease\fR[=\fItarget\fR]
Decrease log level, affects all processes if target is not specified
.RE
.RE
.SS
.RS 4
Log level control targets
.RS 4
.TP 4
.I process\-type
All processes of specified type (e.g., poller)
.RE
.RS 4
.TP 4
.I process\-type,N
Process type and number (e.g., poller,3)
.RE
.RS 4
.TP 4
.I pid
Process identifier, up to 65535. For larger values specify target as "process\-type,N" 
.RE
.RE
.IP "\fB\-h\fR, \fB\-\-help\fR"
Display this help and exit.
.IP "\fB\-V\fR, \fB\-\-version\fR"
Output version information and exit.
.SH FILES
.TP
.I /usr/local/etc/zabbix_proxy.conf
Default location of Zabbix proxy configuration file (if not modified during compile time).
.SH "SEE ALSO"
.BR zabbix_agentd (8),
.BR zabbix_get (8),
.BR zabbix_sender (8),
.BR zabbix_server (8)
.SH AUTHOR
Alexei Vladishev <alex@zabbix.com>
