#!/usr/local/bin/perl
# index.cgi
# Display syslog rules

require './syslog-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1, 0,
	&help_search_link("syslog", "man", "doc"));
print "<hr>\n";

if ($config{'m4_conf'}) {
	# Does the config file need to be passed through m4?
	$oldslash = $/;
	$/ = undef;
	open(CONF, $config{'syslog_conf'});
	$conf1 = <CONF>;
	close(CONF);
	open(CONF, "$config{'m4_path'} $config{'syslog_conf'} |");
	$conf2 = <CONF>;
	close(CONF);
	$/ = $oldslash;
	if ($conf1 ne $conf2) {
		# syslog.conf has m4 directives .. ask the user if he wants
		# to filter the file
		print "<p>",&text('index_m4msg',
				  "<tt>$config{'syslog_conf'}</tt>"),"\n";
		print "<center><form action=m4.cgi>\n";
		print "<input type=submit value='$text{'index_m4'}'>\n";
		print "</form></center>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}
	}

$conf = &get_config();
%access = &get_module_acl();
if ($access{'icons'}) {
	# Display log files and maybe contents
	&ReadParse();
	&foreign_require("proc", "proc-lib.pl");
	foreach $c (@$conf) {
		next if ($c->{'tag'} || !$c->{'active'});
		if ($c->{'file'} && -f $c->{'file'}) {
			local $t = $text{$config{"file_$c->{'file'}"}};
			push(@icons, "images/icon.gif");
			push(@links, "index.cgi?idx=$c->{'index'}&".
				     "lines=$in{'lines'}");
			push(@titles, $t ? "$c->{'file'}<br>($t)"
					 : $c->{'file'});
			}
		}
	&icons_table(\@links, \@titles, \@icons, 5);

	if (defined($in{'idx'})) {
		$log = $conf->[$in{'idx'}];
		print "<hr>\n";
		print "<form action=index.cgi>\n";
		print "<input type=hidden name=idx value='$in{'idx'}'>\n";
		$lines = $in{'lines'} ? $in{'lines'} : $config{'lines'};

		$| = 1;
		print "<pre>";
		$got = &foreign_call("proc", "safe_process_exec",
			      	     "tail -$lines $log->{'file'}", 0, 0,
				     STDOUT, undef, 1);
		print "<i>$text{'view_empty'}</i>\n" if (!$got);
		print "</pre>\n";
		print &text('view_header',
			    "<input name=lines size=3 value='$lines'>",
			    "<tt>$log->{'file'}</tt>"),"\n";
		print "&nbsp;&nbsp;\n";
		print "<input type=submit value='$text{'view_refresh'}'><br>\n";

		print "</form>\n";
		}
	}
else {
	# Display syslog rules
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'index_to'}</b></td> ",
	      $config{'tags'} ? "<td><b>$text{'index_tag'}</b></td>" : "",
	      "<td><b>$text{'index_active'}</b></td> ",
	      "<td colspan=2><b>$text{'index_rule'}</b></td> </tr>\n";
	foreach $c (@$conf) {
		next if ($c->{'tag'});
		print "<tr $cb> <td>\n";
		print "<a href='edit_log.cgi?idx=$c->{'index'}'>"
			if (!$access{'noedit'});
		if ($c->{'file'}) {
			print &text('index_file',
				"<tt>".&html_escape($c->{'file'})."</tt>");
			}
		elsif ($c->{'pipe'} && $config{'pipe'} == 1) {
			print &text('index_pipe',
				"<tt>".&html_escape($c->{'pipe'})."</tt>");
			}
		elsif ($c->{'pipe'} && $config{'pipe'} == 2) {
			print &text('index_pipe2',
				"<tt>".&html_escape($c->{'pipe'})."</tt>");
			}
		elsif ($c->{'host'}) {
			print &text('index_host',
				"<tt>".&html_escape($c->{'host'})."</tt>");
			}
		elsif ($c->{'all'}) {
			print $text{'index_all'};
			}
		else {
			print &text('index_users',
				"<tt>".join(" ", map { &html_escape($_) }
						 @{$c->{'users'}})."</tt>");
			}
		print "</a>\n" if (!$access{'noedit'});
		print "</td>\n";
		if ($config{'tags'}) {
			printf "<td>%s</td>\n",
				$c->{'section'}->{'tag'} eq '*'
				? $text{'all'} : $c->{'section'}->{'tag'};
			}
		print "<td>",$c->{'active'} ? $text{'yes'}
					    : "<font color=#ff0000>$text{'no'}</font>",
		      "</td> <td>\n";
		print join("&nbsp;;&nbsp;",
			   map { &html_escape($_) } @{$c->{'sel'}});
		print "</td> <td width=10>\n";
		if ($c->{'file'} && -f $c->{'file'}) {
			print "<a href='save_log.cgi?idx=$c->{'index'}&",
			      "view=1'>$text{'index_view'}</a>\n";
			}
		else { print "<br>\n"; }
		print "</td> </tr>\n";
		}
	print "</table>\n";
	print "<a href='edit_log.cgi?new=1'>$text{'index_add'}</a>\n"
		if (!$access{'noedit'});
	print "<p>\n";
	}

if (!$access{'icons'} && !$access{'noedit'}) {
	print "<hr>\n";
	if ($config{'pid_file'}) {
		if (open(PID, $config{'pid_file'}) &&
		    <PID> =~ /^(\d+)$/ && kill(0, $1)) {
			$pid = $1;
			}
		}
	else {
		($pid) = &find_byname("syslogd");
		}
	if ($pid) {
		print "<form action=restart.cgi>\n";
		print "<table width=100%><tr>\n";
		print "<input type=hidden name=pid value='$pid'>\n";
		print "<td><input type=submit value='$text{'index_restart'}'></td>\n";
		print "<td>$text{'index_restartmsg'}</td>\n";
		print "</tr></table></form>\n";
		}
	else {
		print "<form action=start.cgi>\n";
		print "<table width=100%><tr>\n";
		print "<td><input type=submit value='$text{'index_start'}'></td>\n";
		print "<td>",&text('index_startmsg', "<tt>$config{'syslogd'}</tt>"),
		      "</td>\n";
		print "</tr></table></form>\n";
		}
	close(PID);
	}

print "<hr>\n";
&footer("/", $text{'index'});

