#!/usr/local/bin/perl
# file_info.cgi
# Display information about a file owned by the package management system

require './software-lib.pl';
&ReadParse();
$f = $in{'file'};
&header($text{'file_title'}, "", "file_info");
print "<hr>\n";

$f =~ s/\/$//;
if ($f !~ /^\//) {
	# if the filename is not absolute, look for it
	foreach $p (split(/:/, $ENV{'PATH'})) {
		last if (&installed_file("$p/$f"));
		}
	}
else {
	# absolute path.. must exist in DB
	&installed_file($f);
	}

if (!%file) {
	print "<h3>",&text('file_notfound', "<i>$f</i>"),"</h3>\n";
	}
else {
	# display file info
	$nc = "width=10% nowrap";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'file_title'}</b></td> </tr>\n";
	print "<tr $cb> <td><table width=100%>\n";

	print "<tr> <td $nc><b>$text{'file_path'}</b></td>\n";
	print "<td colspan=3><font size=+1>$file{'path'}</font></td> </tr>\n";

	print "<tr> <td $nc><b>$text{'file_type'}</b></td>\n";
	print "<td>$type_map[$file{'type'}]</td>\n";

	if ($file{'type'} != 3 && $file{'type'} != 4) {
		print "<td $nc><b>$text{'file_perms'}</b></td>\n";
		print "<td>$file{'mode'}</td> </tr>\n";

		print "<tr> <td $nc><b>$text{'file_owner'}</b></td>\n";
		print "<td>$file{'user'}</td>\n";
		print "<td $nc><b>$text{'file_group'}</b></td>\n";
		print "<td>$file{'group'}</td> </tr>\n";

		if ($file{'type'} == 0) {
			print "<tr> <td $nc><b>$text{'file_size'}</b></td>\n";
			print "<td>$file{'size'}</td> </tr>\n";
			}
		}
	else {
		print "<td $nc><b>$text{'file_link'}</b></td>\n";
		print "<td>$file{'link'}</td> </tr>\n";
		}
	print "</table></tr> </tr></table><p>\n";

	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'file_pack'}</b></td> ",
	      "<td><b>$text{'file_class'}</b></td> ",
	      "<td><b>$text{'file_desc'}</b></td> </tr>\n";
	$n = &list_packages(split(/\s+/, $file{'packages'}));
	for($i=0; $i<$n; $i++) {
		print "<tr $cb> <td><a href=\"edit_pack.cgi?package=",
		      &urlize($packages{$i,'name'}),
		      "\">$packages{$i,'name'}</a></td>\n";
		$c = $packages{$i,'class'};
		print "<td>",$c ? $c : $text{'file_none'},"</td>\n";
		print "<td>$packages{$i,'desc'}</td> </tr>\n";
		}
	print "</table><p>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

